/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.com.esri.core.geometry;

import com.linkedin.coral.com.esri.core.geometry.Envelope;
import com.linkedin.coral.com.esri.core.geometry.Envelope2D;
import com.linkedin.coral.com.esri.core.geometry.Geometry;
import com.linkedin.coral.com.esri.core.geometry.GeometryAccelerators;
import com.linkedin.coral.com.esri.core.geometry.GeometryException;
import com.linkedin.coral.com.esri.core.geometry.MultiPathImpl;
import com.linkedin.coral.com.esri.core.geometry.MultiPoint;
import com.linkedin.coral.com.esri.core.geometry.MultiVertexGeometry;
import com.linkedin.coral.com.esri.core.geometry.MultiVertexGeometryImpl;
import com.linkedin.coral.com.esri.core.geometry.Point;
import com.linkedin.coral.com.esri.core.geometry.Point2D;
import com.linkedin.coral.com.esri.core.geometry.Polygon;
import com.linkedin.coral.com.esri.core.geometry.PolygonUtils;
import com.linkedin.coral.com.esri.core.geometry.Polyline;
import com.linkedin.coral.com.esri.core.geometry.RasterizedGeometry2D;
import com.linkedin.coral.com.esri.core.geometry.Segment;
import com.linkedin.coral.com.esri.core.geometry.SegmentIteratorImpl;

class OperatorInternalRelationUtils {
    OperatorInternalRelationUtils() {
    }

    public static int quickTest2D(Geometry geomA, Geometry geomB, double tolerance, int testType) {
        if (geomB.isEmpty() || geomA.isEmpty()) {
            return 4;
        }
        int geomAtype = geomA.getType().value();
        int geomBtype = geomB.getType().value();
        if (Geometry.isSegment(geomAtype)) {
            Polyline autoPolyA = new Polyline(geomA.getDescription());
            geomA = autoPolyA;
            autoPolyA.addSegment((Segment)geomA, true);
        }
        if (Geometry.isSegment(geomBtype)) {
            Polyline autoPolyB = new Polyline(geomB.getDescription());
            geomB = autoPolyB;
            autoPolyB.addSegment((Segment)geomB, true);
        }
        switch (geomAtype) {
            case 33: {
                switch (geomBtype) {
                    case 33: {
                        return OperatorInternalRelationUtils.quickTest2DPointPoint((Point)geomA, (Point)geomB, tolerance);
                    }
                    case 197: {
                        return OperatorInternalRelationUtils.reverseResult(OperatorInternalRelationUtils.quickTest2DEnvelopePoint((Envelope)geomB, (Point)geomA, tolerance));
                    }
                    case 550: {
                        return OperatorInternalRelationUtils.reverseResult(OperatorInternalRelationUtils.quickTest2DMultiPointPoint((MultiPoint)geomB, (Point)geomA, tolerance));
                    }
                    case 1607: {
                        return OperatorInternalRelationUtils.reverseResult(OperatorInternalRelationUtils.quickTest2DPolylinePoint((Polyline)geomB, (Point)geomA, tolerance, testType));
                    }
                    case 1736: {
                        return OperatorInternalRelationUtils.reverseResult(OperatorInternalRelationUtils.quickTest2DPolygonPoint((Polygon)geomB, (Point)geomA, tolerance));
                    }
                }
                throw GeometryException.GeometryInternalError();
            }
            case 197: {
                switch (geomBtype) {
                    case 33: {
                        return OperatorInternalRelationUtils.quickTest2DEnvelopePoint((Envelope)geomA, (Point)geomB, tolerance);
                    }
                    case 197: {
                        return OperatorInternalRelationUtils.quickTest2DEnvelopeEnvelope((Envelope)geomA, (Envelope)geomB, tolerance);
                    }
                    case 550: {
                        return OperatorInternalRelationUtils.reverseResult(OperatorInternalRelationUtils.quickTest2DMultiPointEnvelope((MultiPoint)geomB, (Envelope)geomA, tolerance, testType));
                    }
                    case 1607: {
                        return OperatorInternalRelationUtils.reverseResult(OperatorInternalRelationUtils.quickTest2DPolylineEnvelope((Polyline)geomB, (Envelope)geomA, tolerance));
                    }
                    case 1736: {
                        return OperatorInternalRelationUtils.reverseResult(OperatorInternalRelationUtils.quickTest2DPolygonEnvelope((Polygon)geomB, (Envelope)geomA, tolerance));
                    }
                }
                throw GeometryException.GeometryInternalError();
            }
            case 550: {
                switch (geomBtype) {
                    case 33: {
                        return OperatorInternalRelationUtils.quickTest2DMultiPointPoint((MultiPoint)geomA, (Point)geomB, tolerance);
                    }
                    case 197: {
                        return OperatorInternalRelationUtils.quickTest2DMultiPointEnvelope((MultiPoint)geomA, (Envelope)geomB, tolerance, testType);
                    }
                    case 550: {
                        return OperatorInternalRelationUtils.quickTest2DMultiPointMultiPoint((MultiPoint)geomA, (MultiPoint)geomB, tolerance, testType);
                    }
                    case 1607: {
                        return OperatorInternalRelationUtils.reverseResult(OperatorInternalRelationUtils.quickTest2DPolylineMultiPoint((Polyline)geomB, (MultiPoint)geomA, tolerance));
                    }
                    case 1736: {
                        return OperatorInternalRelationUtils.reverseResult(OperatorInternalRelationUtils.quickTest2DPolygonMultiPoint((Polygon)geomB, (MultiPoint)geomA, tolerance));
                    }
                }
                throw GeometryException.GeometryInternalError();
            }
            case 1607: {
                switch (geomBtype) {
                    case 33: {
                        return OperatorInternalRelationUtils.quickTest2DPolylinePoint((Polyline)geomA, (Point)geomB, tolerance, testType);
                    }
                    case 197: {
                        return OperatorInternalRelationUtils.quickTest2DPolylineEnvelope((Polyline)geomA, (Envelope)geomB, tolerance);
                    }
                    case 550: {
                        return OperatorInternalRelationUtils.quickTest2DPolylineMultiPoint((Polyline)geomA, (MultiPoint)geomB, tolerance);
                    }
                    case 1607: {
                        return OperatorInternalRelationUtils.quickTest2DPolylinePolyline((Polyline)geomA, (Polyline)geomB, tolerance);
                    }
                    case 1736: {
                        return OperatorInternalRelationUtils.reverseResult(OperatorInternalRelationUtils.quickTest2DPolygonPolyline((Polygon)geomB, (Polyline)geomA, tolerance));
                    }
                }
                throw GeometryException.GeometryInternalError();
            }
            case 1736: {
                switch (geomBtype) {
                    case 33: {
                        return OperatorInternalRelationUtils.quickTest2DPolygonPoint((Polygon)geomA, (Point)geomB, tolerance);
                    }
                    case 197: {
                        return OperatorInternalRelationUtils.quickTest2DPolygonEnvelope((Polygon)geomA, (Envelope)geomB, tolerance);
                    }
                    case 550: {
                        return OperatorInternalRelationUtils.quickTest2DPolygonMultiPoint((Polygon)geomA, (MultiPoint)geomB, tolerance);
                    }
                    case 1607: {
                        return OperatorInternalRelationUtils.quickTest2DPolygonPolyline((Polygon)geomA, (Polyline)geomB, tolerance);
                    }
                    case 1736: {
                        return OperatorInternalRelationUtils.quickTest2DPolygonPolygon((Polygon)geomA, (Polygon)geomB, tolerance);
                    }
                }
                throw GeometryException.GeometryInternalError();
            }
        }
        throw GeometryException.GeometryInternalError();
    }

    private static int quickTest2DPointPoint(Point geomA, Point geomB, double tolerance) {
        Point2D ptA = geomA.getXY();
        Point2D ptB = geomB.getXY();
        return OperatorInternalRelationUtils.quickTest2DPointPoint(ptA, ptB, tolerance);
    }

    private static int quickTest2DPointPoint(Point2D ptA, Point2D ptB, double tolerance) {
        ptA.sub(ptB);
        double len = ptA.sqrLength();
        if (len <= tolerance * tolerance) {
            return 3;
        }
        return 4;
    }

    private static int quickTest2DEnvelopePoint(Envelope geomA, Point geomB, double tolerance) {
        Envelope2D geomAEnv = new Envelope2D();
        geomA.queryEnvelope2D(geomAEnv);
        Point2D ptB = geomB.getXY();
        return OperatorInternalRelationUtils.quickTest2DEnvelopePoint(geomAEnv, ptB, tolerance);
    }

    private static int quickTest2DEnvelopePoint(Envelope2D geomAEnv, Point2D ptB, double tolerance) {
        Envelope2D envAMinus = geomAEnv;
        envAMinus.inflate(-tolerance, -tolerance);
        if (envAMinus.contains(ptB)) {
            return 1;
        }
        Envelope2D envAPlus = geomAEnv;
        envAPlus.inflate(tolerance, tolerance);
        if (envAPlus.contains(ptB)) {
            return 8;
        }
        return 4;
    }

    private static int quickTest2DEnvelopePoint(Envelope2D envAPlus, Envelope2D envAMinus, Point2D ptB, double tolerance) {
        if (envAMinus.contains(ptB)) {
            return 1;
        }
        if (envAPlus.contains(ptB)) {
            return 8;
        }
        return 4;
    }

    private static int quickTest2DEnvelopeEnvelope(Envelope geomA, Envelope geomB, double tolerance) {
        Envelope2D geomAEnv = new Envelope2D();
        geomA.queryEnvelope2D(geomAEnv);
        Envelope2D geomBEnv = new Envelope2D();
        geomB.queryEnvelope2D(geomBEnv);
        return OperatorInternalRelationUtils.quickTest2DEnvelopeEnvelope(geomAEnv, geomBEnv, tolerance);
    }

    private static int quickTest2DEnvelopeEnvelope(Envelope2D geomAEnv, Envelope2D geomBEnv, double tolerance) {
        int res = 0;
        if (geomAEnv.contains(geomBEnv)) {
            res |= 1;
        }
        if (geomBEnv.contains(geomAEnv)) {
            res |= 2;
        }
        if (res != 0) {
            return res;
        }
        Envelope2D envAMinus = geomAEnv;
        envAMinus.inflate(-tolerance, -tolerance);
        Envelope2D envBMinus = geomBEnv;
        envBMinus.inflate(-tolerance, -tolerance);
        if (envAMinus.isIntersecting(envBMinus)) {
            Envelope2D envAPlus = geomAEnv;
            envAPlus.inflate(tolerance, tolerance);
            res = envAPlus.contains(geomBEnv) ? 1 : 0;
            Envelope2D envBPlus = geomBEnv;
            envBPlus.inflate(tolerance, tolerance);
            if ((res |= envBPlus.contains(geomAEnv) ? 2 : 0) != 0) {
                return res;
            }
            return 32;
        }
        Envelope2D envAPlus = geomAEnv;
        envAPlus.inflate(tolerance, tolerance);
        Envelope2D envBPlus = geomBEnv;
        envBPlus.inflate(tolerance, tolerance);
        if (envAPlus.isIntersecting(envBPlus)) {
            return 8;
        }
        return 4;
    }

    private static int quickTest2DMultiPointPoint(MultiPoint geomA, Point geomB, double tolerance) {
        Point2D ptB = geomB.getXY();
        return OperatorInternalRelationUtils.quickTest2DMultiPointPoint(geomA, ptB, tolerance);
    }

    private static int quickTest2DMultiPointPoint(MultiPoint geomA, Point2D ptB, double tolerance) {
        int n = geomA.getPointCount();
        for (int i = 0; i < n; ++i) {
            Point2D ptA = geomA.getXY(i);
            int res = OperatorInternalRelationUtils.quickTest2DPointPoint(ptA, ptB, tolerance);
            if (res == 4) continue;
            if ((res & 2) != 0 && n != 1) {
                return 1;
            }
            return res;
        }
        return 4;
    }

    private static int quickTest2DMultiPointEnvelope(MultiPoint geomA, Envelope geomB, double tolerance, int testType) {
        Envelope2D geomBEnv = new Envelope2D();
        geomB.queryEnvelope2D(geomBEnv);
        return OperatorInternalRelationUtils.quickTest2DMultiPointEnvelope(geomA, geomBEnv, tolerance, testType);
    }

    private static int quickTest2DMultiPointEnvelope(MultiPoint geomA, Envelope2D geomBEnv, double tolerance, int testType) {
        Envelope2D envBMinus = geomBEnv;
        envBMinus.inflate(-tolerance, -tolerance);
        Envelope2D envBPlus = geomBEnv;
        envBPlus.inflate(tolerance, tolerance);
        int dres = 0;
        int n = geomA.getPointCount();
        for (int i = 0; i < n; ++i) {
            Point2D ptA = geomA.getXY(i);
            int res = OperatorInternalRelationUtils.reverseResult(OperatorInternalRelationUtils.quickTest2DEnvelopePoint(envBPlus, envBMinus, ptA, tolerance));
            if (res == 4) continue;
            dres |= res;
            if (testType != 4) continue;
            return 0x40000000;
        }
        if (dres == 0) {
            return 4;
        }
        if (dres == 2) {
            return dres;
        }
        return 32;
    }

    private static int quickTest2DMultiPointMultiPoint(MultiPoint geomA, MultiPoint geomB, double tolerance, int testType) {
        int counter = 0;
        int nb = geomB.getPointCount();
        for (int ib = 0; ib < nb; ++ib) {
            Point2D ptB = geomB.getXY(ib);
            int res = OperatorInternalRelationUtils.quickTest2DMultiPointPoint(geomA, ptB, tolerance);
            if (res == 4) continue;
            ++counter;
            if (testType != 4) continue;
            return 0x40000000;
        }
        if (counter > 0) {
            if (counter == geomB.getPointCount()) {
                if (testType == 3) {
                    int res = OperatorInternalRelationUtils.quickTest2DMultiPointMultiPoint(geomB, geomA, tolerance, 1);
                    return res == 1 ? 3 : 0;
                }
                return 1;
            }
            return 32;
        }
        return 0;
    }

    private static int quickTest2DPolylinePoint(Polyline geomA, Point geomB, double tolerance, int testType) {
        Point2D ptB = geomB.getXY();
        return OperatorInternalRelationUtils.quickTest2DPolylinePoint(geomA, ptB, tolerance, testType);
    }

    private static int quickTest2DMVPointRasterOnly(MultiVertexGeometry geomA, Point2D ptB, double tolerance) {
        RasterizedGeometry2D rgeomA = null;
        MultiVertexGeometryImpl mpImpl = (MultiVertexGeometryImpl)geomA._getImpl();
        GeometryAccelerators gaccel = mpImpl._getAccelerators();
        if (gaccel != null) {
            rgeomA = gaccel.getRasterizedGeometry();
        }
        if (rgeomA != null) {
            RasterizedGeometry2D.HitType hitres = rgeomA.queryPointInGeometry(ptB.x, ptB.y);
            if (hitres == RasterizedGeometry2D.HitType.Outside) {
                return 4;
            }
            if (hitres == RasterizedGeometry2D.HitType.Inside) {
                return 1;
            }
        } else {
            return -1;
        }
        return 0;
    }

    private static int quickTest2DPolylinePoint(Polyline geomA, Point2D ptB, double tolerance, int testType) {
        int mask = 0x4000000F;
        if ((testType & mask) == 0) {
            return 64;
        }
        int res = OperatorInternalRelationUtils.quickTest2DMVPointRasterOnly(geomA, ptB, tolerance);
        if (res > 0) {
            return res;
        }
        double toleranceSqr = tolerance * tolerance;
        MultiPathImpl mpImpl = (MultiPathImpl)geomA._getImpl();
        SegmentIteratorImpl iter = mpImpl.querySegmentIterator();
        while (iter.nextPath()) {
            int pathIndex = iter.getPathIndex();
            if (!geomA.isClosedPath(pathIndex)) {
                int pathSize = geomA.getPathSize(pathIndex);
                int pathStart = geomA.getPathStart(pathIndex);
                if (pathSize == 0) continue;
                if (Point2D.sqrDistance(geomA.getXY(pathStart), ptB) <= toleranceSqr || pathSize > 1 && Point2D.sqrDistance(geomA.getXY(pathStart + pathSize - 1), ptB) <= toleranceSqr) {
                    return 8;
                }
            }
            if (testType == 8) continue;
            while (iter.hasNextSegment()) {
                double t;
                Segment segment = iter.nextSegment();
                Point2D pt = segment.getCoord2D(t = segment.getClosestCoordinate(ptB, false));
                if (!(Point2D.sqrDistance(pt, ptB) <= toleranceSqr)) continue;
                if ((testType & 0x40000004) != 0) {
                    return 0x40000000;
                }
                return 1;
            }
        }
        return (testType & 0x40000004) != 0 ? 4 : 64;
    }

    private static int quickTest2DPolylineEnvelope(Polyline geomA, Envelope geomB, double tolerance) {
        Envelope2D geomBEnv = new Envelope2D();
        geomB.queryEnvelope2D(geomBEnv);
        return OperatorInternalRelationUtils.quickTest2DPolylineEnvelope(geomA, geomBEnv, tolerance);
    }

    private static int quickTest2DPolylineEnvelope(Polyline geomA, Envelope2D geomBEnv, double tolerance) {
        int res = OperatorInternalRelationUtils.quickTest2DMVEnvelopeRasterOnly(geomA, geomBEnv, tolerance);
        if (res > 0) {
            return res;
        }
        return 0;
    }

    private static int quickTest2DMVEnvelopeRasterOnly(MultiVertexGeometry geomA, Envelope2D geomBEnv, double tolerance) {
        MultiVertexGeometryImpl mpImpl = (MultiVertexGeometryImpl)geomA._getImpl();
        GeometryAccelerators gaccel = mpImpl._getAccelerators();
        if (gaccel == null) {
            return -1;
        }
        RasterizedGeometry2D rgeomA = gaccel.getRasterizedGeometry();
        if (rgeomA != null) {
            RasterizedGeometry2D.HitType hitres = rgeomA.queryEnvelopeInGeometry(geomBEnv);
            if (hitres == RasterizedGeometry2D.HitType.Outside) {
                return 4;
            }
            if (hitres == RasterizedGeometry2D.HitType.Inside) {
                return 1;
            }
        } else {
            return -1;
        }
        return 0;
    }

    private static int quickTest2DPolylineMultiPoint(Polyline geomA, MultiPoint geomB, double tolerance) {
        Envelope2D geomBEnv = new Envelope2D();
        geomB.queryEnvelope2D(geomBEnv);
        int res = OperatorInternalRelationUtils.quickTest2DMVEnvelopeRasterOnly(geomA, geomBEnv, tolerance);
        if (res > 0) {
            return res;
        }
        return 0;
    }

    private static int quickTest2DMVMVRasterOnly(MultiVertexGeometry geomA, MultiVertexGeometry geomB, double tolerance) {
        Envelope2D geomBEnv = new Envelope2D();
        geomB.queryEnvelope2D(geomBEnv);
        int res = OperatorInternalRelationUtils.quickTest2DMVEnvelopeRasterOnly(geomA, geomBEnv, tolerance);
        if (res > 0) {
            return res;
        }
        if (res == -1) {
            Envelope2D geomAEnv = new Envelope2D();
            geomA.queryEnvelope2D(geomAEnv);
            res = OperatorInternalRelationUtils.quickTest2DMVEnvelopeRasterOnly(geomB, geomAEnv, tolerance);
            if (res > 0) {
                return OperatorInternalRelationUtils.reverseResult(res);
            }
        }
        return 0;
    }

    private static int quickTest2DPolylinePolyline(Polyline geomA, Polyline geomB, double tolerance) {
        int res = OperatorInternalRelationUtils.quickTest2DMVMVRasterOnly(geomA, geomB, tolerance);
        if (res > 0) {
            return res;
        }
        return 0;
    }

    private static int quickTest2DPolygonPoint(Polygon geomA, Point geomB, double tolerance) {
        Point2D ptB = geomB.getXY();
        return OperatorInternalRelationUtils.quickTest2DPolygonPoint(geomA, ptB, tolerance);
    }

    private static int quickTest2DPolygonPoint(Polygon geomA, Point2D ptB, double tolerance) {
        PolygonUtils.PiPResult pipres = PolygonUtils.isPointInPolygon2D(geomA, ptB, tolerance);
        if (pipres == PolygonUtils.PiPResult.PiPOutside) {
            return 4;
        }
        if (pipres == PolygonUtils.PiPResult.PiPInside) {
            return 1;
        }
        if (pipres == PolygonUtils.PiPResult.PiPBoundary) {
            return 8;
        }
        throw GeometryException.GeometryInternalError();
    }

    private static int quickTest2DPolygonEnvelope(Polygon geomA, Envelope geomB, double tolerance) {
        Envelope2D geomBEnv = new Envelope2D();
        geomB.queryEnvelope2D(geomBEnv);
        return OperatorInternalRelationUtils.quickTest2DPolygonEnvelope(geomA, geomBEnv, tolerance);
    }

    private static int quickTest2DPolygonEnvelope(Polygon geomA, Envelope2D geomBEnv, double tolerance) {
        int res = OperatorInternalRelationUtils.quickTest2DMVEnvelopeRasterOnly(geomA, geomBEnv, tolerance);
        if (res > 0) {
            return res;
        }
        return 0;
    }

    private static int quickTest2DPolygonMultiPoint(Polygon geomA, MultiPoint geomB, double tolerance) {
        int res = OperatorInternalRelationUtils.quickTest2DMVMVRasterOnly(geomA, geomB, tolerance);
        if (res > 0) {
            return res;
        }
        return 0;
    }

    private static int quickTest2DPolygonPolyline(Polygon geomA, Polyline geomB, double tolerance) {
        int res = OperatorInternalRelationUtils.quickTest2DMVMVRasterOnly(geomA, geomB, tolerance);
        if (res > 0) {
            return res;
        }
        return 0;
    }

    private static int quickTest2DPolygonPolygon(Polygon geomA, Polygon geomB, double tolerance) {
        int res = OperatorInternalRelationUtils.quickTest2DMVMVRasterOnly(geomA, geomB, tolerance);
        if (res > 0) {
            return res;
        }
        return 0;
    }

    public static int quickTest2D_Accelerated_DisjointOrContains(Geometry geomA, Geometry geomB, double tolerance) {
        RasterizedGeometry2D.HitType hit;
        RasterizedGeometry2D rgeom;
        MultiVertexGeometryImpl impl;
        GeometryAccelerators accel;
        int gtA = geomA.getType().value();
        int gtB = geomB.getType().value();
        boolean endWhileStatement = false;
        do {
            if (!Geometry.isMultiVertex(gtA) || (accel = (impl = (MultiVertexGeometryImpl)geomA._getImpl())._getAccelerators()) == null || (rgeom = accel.getRasterizedGeometry()) == null) continue;
            if (gtB == 33) {
                Point2D ptB = ((Point)geomB).getXY();
                hit = rgeom.queryPointInGeometry(ptB.x, ptB.y);
                if (hit == RasterizedGeometry2D.HitType.Inside) {
                    return 1;
                }
                if (hit != RasterizedGeometry2D.HitType.Outside) break;
                return 4;
            }
            Envelope2D envB = new Envelope2D();
            geomB.queryEnvelope2D(envB);
            hit = rgeom.queryEnvelopeInGeometry(envB);
            if (hit == RasterizedGeometry2D.HitType.Inside) {
                return 1;
            }
            if (hit != RasterizedGeometry2D.HitType.Outside) break;
            return 4;
        } while (endWhileStatement);
        accel = null;
        do {
            if (!Geometry.isMultiVertex(gtB) || (accel = (impl = (MultiVertexGeometryImpl)geomB._getImpl())._getAccelerators()) == null || (rgeom = accel.getRasterizedGeometry()) == null) continue;
            if (gtA == 33) {
                Point2D ptA = ((Point)geomA).getXY();
                hit = rgeom.queryPointInGeometry(ptA.x, ptA.y);
                if (hit == RasterizedGeometry2D.HitType.Inside) {
                    return 2;
                }
                if (hit != RasterizedGeometry2D.HitType.Outside) break;
                return 4;
            }
            Envelope2D envA = new Envelope2D();
            geomA.queryEnvelope2D(envA);
            hit = rgeom.queryEnvelopeInGeometry(envA);
            if (hit == RasterizedGeometry2D.HitType.Inside) {
                return 2;
            }
            if (hit != RasterizedGeometry2D.HitType.Outside) break;
            return 4;
        } while (endWhileStatement);
        return 0;
    }

    private static int reverseResult(int resIn) {
        int res = resIn;
        if ((res & 1) != 0) {
            res &= 0xFFFFFFFE;
            res |= 2;
        }
        if ((res & 2) != 0) {
            res &= 0xFFFFFFFD;
            res |= 1;
        }
        return res;
    }

    static interface Relation {
        public static final int Unknown = 0;
        public static final int Contains = 1;
        public static final int Within = 2;
        public static final int Equals = 3;
        public static final int Disjoint = 4;
        public static final int Touches = 8;
        public static final int Crosses = 16;
        public static final int Overlaps = 32;
        public static final int NoThisRelation = 64;
        public static final int Intersects = 0x40000000;
        public static final int IntersectsOrDisjoint = 0x40000004;
    }
}

