/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import io.trino.plugin.exchange.FileStatus;
import io.trino.plugin.exchange.FileSystemExchangeSinkHandle;
import io.trino.plugin.exchange.FileSystemExchangeSinkInstanceHandle;
import io.trino.plugin.exchange.FileSystemExchangeSourceHandle;
import io.trino.plugin.exchange.FileSystemExchangeStorage;
import io.trino.spi.exchange.Exchange;
import io.trino.spi.exchange.ExchangeContext;
import io.trino.spi.exchange.ExchangeSinkHandle;
import io.trino.spi.exchange.ExchangeSinkInstanceHandle;
import io.trino.spi.exchange.ExchangeSourceHandle;
import io.trino.spi.exchange.ExchangeSourceSplitter;
import io.trino.spi.exchange.ExchangeSourceStatistics;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.security.Key;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;
import javax.crypto.SecretKey;

public class FileSystemExchange
implements Exchange {
    private static final Pattern PARTITION_FILE_NAME_PATTERN = Pattern.compile("(\\d+)\\.data");
    private final URI baseDirectory;
    private final FileSystemExchangeStorage exchangeStorage;
    private final ExchangeContext exchangeContext;
    private final int outputPartitionCount;
    private final Optional<SecretKey> secretKey;
    private final ExecutorService executor;
    @GuardedBy(value="this")
    private final Set<Integer> allSinks = new HashSet<Integer>();
    @GuardedBy(value="this")
    private final Set<Integer> finishedSinks = new HashSet<Integer>();
    @GuardedBy(value="this")
    private boolean noMoreSinks;
    @GuardedBy(value="this")
    private boolean exchangeSourceHandlesCreationStarted;
    private final CompletableFuture<List<ExchangeSourceHandle>> exchangeSourceHandlesFuture = new CompletableFuture();

    public FileSystemExchange(URI baseDirectory, FileSystemExchangeStorage exchangeStorage, ExchangeContext exchangeContext, int outputPartitionCount, Optional<SecretKey> secretKey, ExecutorService executor) {
        this.baseDirectory = Objects.requireNonNull(baseDirectory, "baseDirectory is null");
        this.exchangeStorage = Objects.requireNonNull(exchangeStorage, "exchangeStorage is null");
        this.exchangeContext = Objects.requireNonNull(exchangeContext, "exchangeContext is null");
        this.outputPartitionCount = outputPartitionCount;
        this.secretKey = Objects.requireNonNull(secretKey, "secretKey is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
    }

    public void initialize() {
        try {
            this.exchangeStorage.createDirectories(this.getExchangeDirectory());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public synchronized ExchangeSinkHandle addSink(int taskPartition) {
        FileSystemExchangeSinkHandle sinkHandle = new FileSystemExchangeSinkHandle(taskPartition, this.secretKey.map(Key::getEncoded));
        this.allSinks.add(taskPartition);
        return sinkHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noMoreSinks() {
        FileSystemExchange fileSystemExchange = this;
        synchronized (fileSystemExchange) {
            this.noMoreSinks = true;
        }
        this.checkInputReady();
    }

    public ExchangeSinkInstanceHandle instantiateSink(ExchangeSinkHandle sinkHandle, int taskAttemptId) {
        FileSystemExchangeSinkHandle fileSystemExchangeSinkHandle = (FileSystemExchangeSinkHandle)sinkHandle;
        URI outputDirectory = this.getExchangeDirectory().resolve(fileSystemExchangeSinkHandle.getPartitionId() + "/").resolve(taskAttemptId + "/");
        try {
            this.exchangeStorage.createDirectories(outputDirectory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new FileSystemExchangeSinkInstanceHandle(fileSystemExchangeSinkHandle, outputDirectory, this.outputPartitionCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sinkFinished(ExchangeSinkInstanceHandle handle) {
        FileSystemExchange fileSystemExchange = this;
        synchronized (fileSystemExchange) {
            FileSystemExchangeSinkInstanceHandle instanceHandle = (FileSystemExchangeSinkInstanceHandle)handle;
            this.finishedSinks.add(instanceHandle.getSinkHandle().getPartitionId());
        }
        this.checkInputReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInputReady() {
        Verify.verify((!Thread.holdsLock(this) ? 1 : 0) != 0);
        CompletableFuture<List> exchangeSourceHandlesCreationFuture = null;
        FileSystemExchange fileSystemExchange = this;
        synchronized (fileSystemExchange) {
            if (this.exchangeSourceHandlesCreationStarted) {
                return;
            }
            if (this.noMoreSinks && this.finishedSinks.containsAll(this.allSinks)) {
                this.exchangeSourceHandlesCreationStarted = true;
                exchangeSourceHandlesCreationFuture = CompletableFuture.supplyAsync(this::createExchangeSourceHandles, this.executor);
            }
        }
        if (exchangeSourceHandlesCreationFuture != null) {
            exchangeSourceHandlesCreationFuture.whenComplete((exchangeSourceHandles, throwable) -> {
                if (throwable != null) {
                    this.exchangeSourceHandlesFuture.completeExceptionally((Throwable)throwable);
                } else {
                    this.exchangeSourceHandlesFuture.complete((List<ExchangeSourceHandle>)exchangeSourceHandles);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExchangeSourceHandle> createExchangeSourceHandles() {
        ImmutableList finishedTaskPartitions;
        ArrayListMultimap partitionFiles = ArrayListMultimap.create();
        FileSystemExchange fileSystemExchange = this;
        synchronized (fileSystemExchange) {
            finishedTaskPartitions = ImmutableList.copyOf(this.finishedSinks);
        }
        for (Integer taskPartition : finishedTaskPartitions) {
            URI committedAttemptPath = this.getCommittedAttemptPath(taskPartition);
            Map<Integer, FileStatus> partitions = this.getCommittedPartitions(committedAttemptPath);
            partitions.forEach((arg_0, arg_1) -> ((Multimap)partitionFiles).put(arg_0, arg_1));
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (Integer partitionId : partitionFiles.keySet()) {
            result.add((Object)new FileSystemExchangeSourceHandle(partitionId, (List<FileStatus>)ImmutableList.copyOf((Collection)partitionFiles.get((Object)partitionId)), this.secretKey.map(Key::getEncoded)));
        }
        return result.build();
    }

    private URI getCommittedAttemptPath(Integer taskPartition) {
        URI sinkOutputBasePath = this.getExchangeDirectory().resolve(taskPartition + "/");
        try {
            List<URI> attemptPaths = this.exchangeStorage.listDirectories(sinkOutputBasePath);
            Preconditions.checkState((!attemptPaths.isEmpty() ? 1 : 0) != 0, (String)"No attempts found under sink output path %s", (Object)sinkOutputBasePath);
            return attemptPaths.stream().filter(this::isCommitted).findFirst().orElseThrow(() -> new IllegalStateException(String.format("No committed attempts found under sink output path %s", sinkOutputBasePath)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean isCommitted(URI attemptPath) {
        URI commitMarkerFilePath = attemptPath.resolve("committed");
        try {
            return this.exchangeStorage.exists(commitMarkerFilePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Map<Integer, FileStatus> getCommittedPartitions(URI committedAttemptPath) {
        try {
            List partitionFiles = (List)this.exchangeStorage.listFiles(committedAttemptPath).stream().filter(file -> file.getFilePath().endsWith(".data")).collect(ImmutableList.toImmutableList());
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (FileStatus partitionFile : partitionFiles) {
                Matcher matcher = PARTITION_FILE_NAME_PATTERN.matcher(new File(partitionFile.getFilePath()).getName());
                Preconditions.checkState((boolean)matcher.matches(), (String)"Unexpected partition file: %s", (Object)partitionFile);
                int partitionId = Integer.parseInt(matcher.group(1));
                result.put((Object)partitionId, (Object)partitionFile);
            }
            return result.buildOrThrow();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private URI getExchangeDirectory() {
        return this.baseDirectory.resolve(this.exchangeContext.getQueryId() + "." + this.exchangeContext.getExchangeId() + "/");
    }

    public CompletableFuture<List<ExchangeSourceHandle>> getSourceHandles() {
        return this.exchangeSourceHandlesFuture;
    }

    public ExchangeSourceSplitter split(ExchangeSourceHandle handle, long targetSizeInBytes) {
        final FileSystemExchangeSourceHandle sourceHandle = (FileSystemExchangeSourceHandle)handle;
        final Iterator<FileStatus> filesIterator = sourceHandle.getFiles().iterator();
        return new ExchangeSourceSplitter(){

            public CompletableFuture<Void> isBlocked() {
                return CompletableFuture.completedFuture(null);
            }

            public Optional<ExchangeSourceHandle> getNext() {
                if (filesIterator.hasNext()) {
                    return Optional.of(new FileSystemExchangeSourceHandle(sourceHandle.getPartitionId(), (List<FileStatus>)ImmutableList.of((Object)((FileStatus)filesIterator.next())), FileSystemExchange.this.secretKey.map(Key::getEncoded)));
                }
                return Optional.empty();
            }

            public void close() {
            }
        };
    }

    public ExchangeSourceStatistics getExchangeSourceStatistics(ExchangeSourceHandle handle) {
        FileSystemExchangeSourceHandle sourceHandle = (FileSystemExchangeSourceHandle)handle;
        long sizeInBytes = sourceHandle.getFiles().stream().mapToLong(FileStatus::getFileSize).sum();
        return new ExchangeSourceStatistics(sizeInBytes);
    }

    public void close() {
        this.exchangeStorage.deleteRecursively(this.getExchangeDirectory());
    }
}

