/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.trino.plugin.exchange.FileSystemExchange;
import io.trino.plugin.exchange.FileSystemExchangeConfig;
import io.trino.plugin.exchange.FileSystemExchangeSink;
import io.trino.plugin.exchange.FileSystemExchangeSinkInstanceHandle;
import io.trino.plugin.exchange.FileSystemExchangeSource;
import io.trino.plugin.exchange.FileSystemExchangeSourceHandle;
import io.trino.plugin.exchange.FileSystemExchangeStorage;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.exchange.Exchange;
import io.trino.spi.exchange.ExchangeContext;
import io.trino.spi.exchange.ExchangeManager;
import io.trino.spi.exchange.ExchangeSink;
import io.trino.spi.exchange.ExchangeSinkInstanceHandle;
import io.trino.spi.exchange.ExchangeSource;
import io.trino.spi.exchange.ExchangeSourceHandle;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;

public class FileSystemExchangeManager
implements ExchangeManager {
    public static final String PATH_SEPARATOR = "/";
    private static final int KEY_BITS = 256;
    private final FileSystemExchangeStorage exchangeStorage;
    private final URI baseDirectory;
    private final boolean exchangeEncryptionEnabled;
    private final int exchangeSinkBufferPoolMinSize;
    private final ExecutorService executor;

    @Inject
    public FileSystemExchangeManager(FileSystemExchangeStorage exchangeStorage, FileSystemExchangeConfig fileSystemExchangeConfig) {
        Objects.requireNonNull(fileSystemExchangeConfig, "fileSystemExchangeConfig is null");
        this.exchangeStorage = Objects.requireNonNull(exchangeStorage, "exchangeStorage is null");
        Object baseDirectory = Objects.requireNonNull(fileSystemExchangeConfig.getBaseDirectory(), "baseDirectory is null");
        if (!((String)baseDirectory).endsWith(PATH_SEPARATOR)) {
            baseDirectory = (String)baseDirectory + PATH_SEPARATOR;
        }
        this.baseDirectory = URI.create((String)baseDirectory);
        this.exchangeEncryptionEnabled = fileSystemExchangeConfig.isExchangeEncryptionEnabled();
        this.exchangeSinkBufferPoolMinSize = fileSystemExchangeConfig.getExchangeSinkBufferPoolMinSize();
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"exchange-source-handles-creation-%s"));
    }

    public Exchange createExchange(ExchangeContext context, int outputPartitionCount) {
        Optional<SecretKey> secretKey = Optional.empty();
        if (this.exchangeEncryptionEnabled) {
            try {
                KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
                keyGenerator.init(256);
                secretKey = Optional.of(keyGenerator.generateKey());
            }
            catch (NoSuchAlgorithmException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to generate new secret key: " + e.getMessage(), (Throwable)e);
            }
        }
        FileSystemExchange exchange = new FileSystemExchange(this.baseDirectory, this.exchangeStorage, context, outputPartitionCount, secretKey, this.executor);
        exchange.initialize();
        return exchange;
    }

    public ExchangeSink createSink(ExchangeSinkInstanceHandle handle, boolean preserveRecordsOrder) {
        FileSystemExchangeSinkInstanceHandle instanceHandle = (FileSystemExchangeSinkInstanceHandle)handle;
        return new FileSystemExchangeSink(this.exchangeStorage, instanceHandle.getOutputDirectory(), instanceHandle.getOutputPartitionCount(), instanceHandle.getSinkHandle().getSecretKey().map(key -> new SecretKeySpec((byte[])key, 0, ((byte[])key).length, "AES")), this.exchangeSinkBufferPoolMinSize);
    }

    public ExchangeSource createSource(List<ExchangeSourceHandle> handles) {
        List files = (List)handles.stream().map(FileSystemExchangeSourceHandle.class::cast).flatMap(handle -> handle.getFiles().stream()).map(fileStatus -> URI.create(fileStatus.getFilePath())).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder secretKeys = ImmutableList.builder();
        for (ExchangeSourceHandle handle2 : handles) {
            FileSystemExchangeSourceHandle sourceHandle = (FileSystemExchangeSourceHandle)handle2;
            secretKeys.addAll(Collections.nCopies(sourceHandle.getFiles().size(), sourceHandle.getSecretKey().map(key -> new SecretKeySpec((byte[])key, 0, ((byte[])key).length, "AES"))));
        }
        return new FileSystemExchangeSource(this.exchangeStorage, files, (List<Optional<SecretKey>>)secretKeys.build());
    }
}

