/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.exchange.FileSystemExchangeConfig;
import io.trino.plugin.exchange.FileSystemExchangeManager;
import io.trino.plugin.exchange.FileSystemExchangeStorage;
import io.trino.plugin.exchange.local.LocalFileSystemExchangeStorage;
import io.trino.plugin.exchange.s3.ExchangeS3Config;
import io.trino.plugin.exchange.s3.S3FileSystemExchangeStorage;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.net.URI;
import java.util.Objects;

public class FileSystemExchangeModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.bind(FileSystemExchangeManager.class).in(Scopes.SINGLETON);
        FileSystemExchangeConfig fileSystemExchangeConfig = (FileSystemExchangeConfig)this.buildConfigObject(FileSystemExchangeConfig.class);
        String scheme = URI.create(Objects.requireNonNull(fileSystemExchangeConfig.getBaseDirectory(), "baseDirectory is null")).getScheme();
        if (scheme == null || scheme.equals("file")) {
            binder.bind(FileSystemExchangeStorage.class).to(LocalFileSystemExchangeStorage.class).in(Scopes.SINGLETON);
        } else if (ImmutableSet.of((Object)"s3", (Object)"s3a", (Object)"s3n").contains((Object)scheme)) {
            binder.bind(FileSystemExchangeStorage.class).to(S3FileSystemExchangeStorage.class).in(Scopes.SINGLETON);
            ConfigBinder.configBinder((Binder)binder).bindConfig(ExchangeS3Config.class);
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Scheme %s is not supported as exchange spooling storage", scheme));
        }
    }
}

