/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.plugin.exchange.ExchangeStorageWriter;
import io.trino.plugin.exchange.FileSystemExchangeStorage;
import io.trino.spi.exchange.ExchangeSink;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.SecretKey;
import org.openjdk.jol.info.ClassLayout;

@ThreadSafe
public class FileSystemExchangeSink
implements ExchangeSink {
    public static final String COMMITTED_MARKER_FILE_NAME = "committed";
    public static final String DATA_FILE_SUFFIX = ".data";
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(FileSystemExchangeSink.class).instanceSize();
    private final FileSystemExchangeStorage exchangeStorage;
    private final URI outputDirectory;
    private final int outputPartitionCount;
    private final Optional<SecretKey> secretKey;
    private final BufferPool bufferPool;
    private final Map<Integer, BufferedStorageWriter> writersMap = new ConcurrentHashMap<Integer, BufferedStorageWriter>();
    private final AtomicReference<Throwable> failure = new AtomicReference();
    private volatile boolean closed;

    public FileSystemExchangeSink(FileSystemExchangeStorage exchangeStorage, URI outputDirectory, int outputPartitionCount, Optional<SecretKey> secretKey, int exchangeSinkBufferPoolMinSize) {
        this.exchangeStorage = Objects.requireNonNull(exchangeStorage, "exchangeStorage is null");
        this.outputDirectory = Objects.requireNonNull(outputDirectory, "outputDirectory is null");
        this.outputPartitionCount = outputPartitionCount;
        this.secretKey = Objects.requireNonNull(secretKey, "secretKey is null");
        this.bufferPool = new BufferPool(Math.max(outputPartitionCount * 2, exchangeSinkBufferPoolMinSize), exchangeStorage.getWriteBufferSize());
    }

    public CompletableFuture<Void> isBlocked() {
        return this.bufferPool.isBlocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int partitionId, Slice data) {
        BufferedStorageWriter writer;
        this.throwIfFailed();
        Preconditions.checkArgument((partitionId < this.outputPartitionCount ? 1 : 0) != 0, (String)"partition id is expected to be less than %s: %s", (int)this.outputPartitionCount, (int)partitionId);
        FileSystemExchangeSink fileSystemExchangeSink = this;
        synchronized (fileSystemExchangeSink) {
            if (this.closed) {
                return;
            }
            writer = this.writersMap.computeIfAbsent(partitionId, this::createWriter);
        }
        writer.write(data);
    }

    private BufferedStorageWriter createWriter(int partitionId) {
        URI outputPath = this.outputDirectory.resolve(partitionId + DATA_FILE_SUFFIX);
        try {
            return new BufferedStorageWriter(this.exchangeStorage.createExchangeStorageWriter(outputPath, this.secretKey), this.bufferPool, this.failure);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public long getMemoryUsage() {
        return (long)INSTANCE_SIZE + this.bufferPool.getRetainedSize() + SizeOf.estimatedSizeOf(this.writersMap, SizeOf::sizeOf, BufferedStorageWriter::getRetainedSize);
    }

    public synchronized CompletableFuture<Void> finish() {
        if (this.closed) {
            return CompletableFuture.failedFuture(new IllegalStateException("Exchange sink has already closed"));
        }
        ListenableFuture finishFuture = MoreFutures.asVoid((ListenableFuture)Futures.allAsList((Iterable)((Iterable)this.writersMap.values().stream().map(BufferedStorageWriter::finish).collect(ImmutableList.toImmutableList()))));
        MoreFutures.addSuccessCallback((ListenableFuture)finishFuture, this::destroy);
        finishFuture = Futures.transformAsync((ListenableFuture)finishFuture, ignored -> this.exchangeStorage.createEmptyFile(this.outputDirectory.resolve(COMMITTED_MARKER_FILE_NAME)), (Executor)MoreExecutors.directExecutor());
        Futures.addCallback((ListenableFuture)finishFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                FileSystemExchangeSink.this.closed = true;
            }

            public void onFailure(Throwable ignored) {
                FileSystemExchangeSink.this.abort();
            }
        }, (Executor)MoreExecutors.directExecutor());
        return MoreFutures.toCompletableFuture((ListenableFuture)finishFuture);
    }

    public synchronized CompletableFuture<Void> abort() {
        if (this.closed) {
            return CompletableFuture.completedFuture(null);
        }
        this.closed = true;
        ListenableFuture abortFuture = MoreFutures.asVoid((ListenableFuture)Futures.allAsList((Iterable)((Iterable)this.writersMap.values().stream().map(BufferedStorageWriter::abort).collect(ImmutableList.toImmutableList()))));
        MoreFutures.addSuccessCallback((ListenableFuture)abortFuture, this::destroy);
        return MoreFutures.toCompletableFuture((ListenableFuture)Futures.transformAsync((ListenableFuture)abortFuture, ignored -> this.exchangeStorage.deleteRecursively(this.outputDirectory), (Executor)MoreExecutors.directExecutor()));
    }

    private void throwIfFailed() {
        Throwable throwable = this.failure.get();
        if (throwable != null) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private void destroy() {
        this.writersMap.clear();
        this.bufferPool.close();
    }

    @ThreadSafe
    private static class BufferPool {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(BufferPool.class).instanceSize();
        private final int numBuffers;
        private final long bufferRetainedSize;
        @GuardedBy(value="this")
        private final Queue<SliceOutput> freeBuffersQueue;
        @GuardedBy(value="this")
        private CompletableFuture<Void> blockedFuture = new CompletableFuture();
        @GuardedBy(value="this")
        private boolean closed;

        public BufferPool(int numBuffers, int writeBufferSize) {
            Preconditions.checkArgument((numBuffers >= 1 ? 1 : 0) != 0, (Object)"numBuffers must be at least one");
            this.numBuffers = numBuffers;
            this.freeBuffersQueue = new ArrayDeque<SliceOutput>(numBuffers);
            for (int i = 0; i < numBuffers; ++i) {
                this.freeBuffersQueue.add(Slices.allocate((int)writeBufferSize).getOutput());
            }
            this.bufferRetainedSize = this.freeBuffersQueue.peek().getRetainedSize();
        }

        public synchronized CompletableFuture<Void> isBlocked() {
            if (this.freeBuffersQueue.isEmpty()) {
                if (this.blockedFuture.isDone()) {
                    this.blockedFuture = new CompletableFuture();
                }
                return this.blockedFuture;
            }
            return ExchangeSink.NOT_BLOCKED;
        }

        public synchronized SliceOutput take() {
            while (!this.closed) {
                if (!this.freeBuffersQueue.isEmpty()) {
                    return this.freeBuffersQueue.poll();
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void offer(SliceOutput buffer) {
            CompletableFuture<Void> completableFuture;
            buffer.reset();
            BufferPool bufferPool = this;
            synchronized (bufferPool) {
                if (this.closed) {
                    return;
                }
                completableFuture = this.blockedFuture;
                this.freeBuffersQueue.add(buffer);
                this.notify();
            }
            completableFuture.complete(null);
        }

        public synchronized long getRetainedSize() {
            if (this.closed) {
                return INSTANCE_SIZE;
            }
            return (long)INSTANCE_SIZE + (long)this.numBuffers * this.bufferRetainedSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            CompletableFuture<Void> completableFuture;
            BufferPool bufferPool = this;
            synchronized (bufferPool) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                this.notifyAll();
                completableFuture = this.blockedFuture;
                this.freeBuffersQueue.clear();
            }
            completableFuture.complete(null);
        }
    }

    @ThreadSafe
    private static class BufferedStorageWriter {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(BufferedStorageWriter.class).instanceSize();
        private final ExchangeStorageWriter storageWriter;
        private final BufferPool bufferPool;
        private final AtomicReference<Throwable> failure;
        @GuardedBy(value="this")
        private SliceOutput currentBuffer;

        public BufferedStorageWriter(ExchangeStorageWriter storageWriter, BufferPool bufferPool, AtomicReference<Throwable> failure) {
            this.storageWriter = Objects.requireNonNull(storageWriter, "storageWriter is null");
            this.bufferPool = Objects.requireNonNull(bufferPool, "bufferPool is null");
            this.failure = Objects.requireNonNull(failure, "failure is null");
        }

        public synchronized void write(Slice data) {
            this.writeInternal(Slices.wrappedIntArray((int[])new int[]{data.length()}));
            this.writeInternal(data);
        }

        public synchronized ListenableFuture<Void> finish() {
            this.flushIfNeeded(true);
            return this.storageWriter.finish();
        }

        public synchronized ListenableFuture<Void> abort() {
            return this.storageWriter.abort();
        }

        public synchronized long getRetainedSize() {
            return (long)INSTANCE_SIZE + this.storageWriter.getRetainedSize();
        }

        private void writeInternal(Slice slice) {
            int writableBytes;
            for (int position = 0; position < slice.length(); position += writableBytes) {
                if (this.currentBuffer == null) {
                    this.currentBuffer = this.bufferPool.take();
                    if (this.currentBuffer == null) {
                        return;
                    }
                }
                writableBytes = Math.min(this.currentBuffer.writableBytes(), slice.length() - position);
                this.currentBuffer.writeBytes(slice.getBytes(position, writableBytes));
                this.flushIfNeeded(false);
            }
        }

        private void flushIfNeeded(boolean finished) {
            SliceOutput buffer = this.currentBuffer;
            if (buffer != null && (!buffer.isWritable() || finished)) {
                if (!buffer.isWritable()) {
                    this.currentBuffer = null;
                }
                ListenableFuture<Void> writeFuture = this.storageWriter.write(buffer.slice());
                writeFuture.addListener(() -> this.bufferPool.offer(buffer), MoreExecutors.directExecutor());
                MoreFutures.addExceptionCallback(writeFuture, throwable -> this.failure.compareAndSet((Throwable)null, (Throwable)throwable));
            }
        }
    }
}

