/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.trino.plugin.exchange.FileSystemExchangeStorage;
import io.trino.spi.exchange.ExchangeSource;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.crypto.SecretKey;

public class FileSystemExchangeSource
implements ExchangeSource {
    private final FileSystemExchangeStorage exchangeStorage;
    @GuardedBy(value="this")
    private final Iterator<URI> files;
    @GuardedBy(value="this")
    private final Iterator<Optional<SecretKey>> secretKeys;
    @GuardedBy(value="this")
    private SliceInput sliceInput;
    @GuardedBy(value="this")
    private boolean closed;

    public FileSystemExchangeSource(FileSystemExchangeStorage exchangeStorage, List<URI> files, List<Optional<SecretKey>> secretKeys) {
        this.exchangeStorage = Objects.requireNonNull(exchangeStorage, "exchangeStorage is null");
        Preconditions.checkArgument((Objects.requireNonNull(files, "files is null").size() == Objects.requireNonNull(secretKeys, "secretKeys is null").size() ? 1 : 0) != 0, (Object)String.format("number of files (%d) doesn't match number of secretKeys (%d)", files.size(), secretKeys.size()));
        this.files = ImmutableList.copyOf(files).iterator();
        this.secretKeys = ImmutableList.copyOf(secretKeys).iterator();
    }

    public CompletableFuture<Void> isBlocked() {
        return NOT_BLOCKED;
    }

    public synchronized boolean isFinished() {
        return this.closed || !this.files.hasNext() && this.sliceInput == null;
    }

    @Nullable
    public synchronized Slice read() {
        if (this.isFinished()) {
            return null;
        }
        if (this.sliceInput != null && !this.sliceInput.isReadable()) {
            this.sliceInput.close();
            this.sliceInput = null;
        }
        if (this.sliceInput == null && this.files.hasNext()) {
            URI file = this.files.next();
            Optional<SecretKey> secretKey = this.secretKeys.next();
            try {
                this.sliceInput = this.exchangeStorage.getSliceInput(file, secretKey);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (this.sliceInput == null) {
            return null;
        }
        if (!this.sliceInput.isReadable()) {
            this.sliceInput.close();
            this.sliceInput = null;
            return null;
        }
        int size = this.sliceInput.readInt();
        return this.sliceInput.readSlice(size);
    }

    public synchronized long getMemoryUsage() {
        return this.sliceInput != null ? this.sliceInput.getRetainedSize() : 0L;
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.sliceInput != null) {
                this.sliceInput.close();
                this.sliceInput = null;
            }
        }
    }
}

