/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.local;

import com.google.common.collect.ImmutableList;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.units.DataSize;
import io.trino.plugin.exchange.ExchangeStorageWriter;
import io.trino.plugin.exchange.FileStatus;
import io.trino.plugin.exchange.FileSystemExchangeStorage;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.openjdk.jol.info.ClassLayout;

public class LocalFileSystemExchangeStorage
implements FileSystemExchangeStorage {
    private static final int BUFFER_SIZE_IN_BYTES = Math.toIntExact(DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.KILOBYTE).toBytes());

    @Override
    public void createDirectories(URI dir) throws IOException {
        Files.createDirectories(Paths.get(dir.getPath(), new String[0]), new FileAttribute[0]);
    }

    @Override
    public SliceInput getSliceInput(URI file, Optional<SecretKey> secretKey) throws IOException {
        if (secretKey.isPresent()) {
            try {
                Cipher cipher = Cipher.getInstance("AES");
                cipher.init(2, secretKey.get());
                return new InputStreamSliceInput((InputStream)new CipherInputStream(new FileInputStream(Paths.get(file.getPath(), new String[0]).toFile()), cipher), BUFFER_SIZE_IN_BYTES);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to create CipherInputStream: " + e.getMessage(), (Throwable)e);
            }
        }
        return new InputStreamSliceInput((InputStream)new FileInputStream(Paths.get(file.getPath(), new String[0]).toFile()), BUFFER_SIZE_IN_BYTES);
    }

    @Override
    public ExchangeStorageWriter createExchangeStorageWriter(URI file, Optional<SecretKey> secretKey) throws IOException {
        return new LocalExchangeStorageWriter(file, secretKey);
    }

    @Override
    public boolean exists(URI file) {
        return Files.exists(Paths.get(file.getPath(), new String[0]), new LinkOption[0]);
    }

    @Override
    public ListenableFuture<Void> createEmptyFile(URI file) {
        try {
            Files.createFile(Paths.get(file.getPath(), new String[0]), new FileAttribute[0]);
        }
        catch (IOException | RuntimeException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    public ListenableFuture<Void> deleteRecursively(URI dir) {
        try {
            MoreFiles.deleteRecursively((Path)Paths.get(dir.getPath(), new String[0]), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        catch (IOException | RuntimeException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    public List<FileStatus> listFiles(URI dir) throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Path file : LocalFileSystemExchangeStorage.listPaths(dir, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]))) {
            builder.add((Object)new FileStatus(file.toUri().toString(), Files.size(file)));
        }
        return builder.build();
    }

    @Override
    public List<URI> listDirectories(URI dir) throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Path subDir : LocalFileSystemExchangeStorage.listPaths(dir, x$0 -> Files.isDirectory(x$0, new LinkOption[0]))) {
            builder.add((Object)subDir.toUri());
        }
        return builder.build();
    }

    @Override
    public int getWriteBufferSize() {
        return BUFFER_SIZE_IN_BYTES;
    }

    @Override
    public void close() {
    }

    private static List<Path> listPaths(URI directory, Predicate<Path> predicate) throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        try (Stream<Path> dir = Files.list(Paths.get(directory.getPath(), new String[0]));){
            dir.filter(predicate).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        }
        return builder.build();
    }

    private static class LocalExchangeStorageWriter
    implements ExchangeStorageWriter {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(LocalExchangeStorageWriter.class).instanceSize();
        private final OutputStream outputStream;

        public LocalExchangeStorageWriter(URI file, Optional<SecretKey> secretKey) throws FileNotFoundException {
            if (secretKey.isPresent()) {
                try {
                    Cipher cipher = Cipher.getInstance("AES");
                    cipher.init(1, secretKey.get());
                    this.outputStream = new CipherOutputStream(new FileOutputStream(Paths.get(file.getPath(), new String[0]).toFile()), cipher);
                }
                catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to create CipherOutputStream: " + e.getMessage(), (Throwable)e);
                }
            } else {
                this.outputStream = new FileOutputStream(Paths.get(file.getPath(), new String[0]).toFile());
            }
        }

        @Override
        public ListenableFuture<Void> write(Slice slice) {
            try {
                this.outputStream.write(slice.getBytes());
            }
            catch (IOException | RuntimeException e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
            return Futures.immediateVoidFuture();
        }

        @Override
        public ListenableFuture<Void> finish() {
            try {
                this.outputStream.close();
            }
            catch (IOException | RuntimeException e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
            return Futures.immediateVoidFuture();
        }

        @Override
        public ListenableFuture<Void> abort() {
            try {
                this.outputStream.close();
            }
            catch (IOException | RuntimeException e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
            return Futures.immediateVoidFuture();
        }

        @Override
        public long getRetainedSize() {
            return INSTANCE_SIZE;
        }
    }
}

