/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.s3;

import io.airlift.log.Logger;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.AsyncRequestBody;

public final class ByteBufferAsyncRequestBody
implements AsyncRequestBody {
    private static final Logger log = Logger.get(ByteBufferAsyncRequestBody.class);
    private final ByteBuffer byteBuffer;
    private final String mimetype;

    public ByteBufferAsyncRequestBody(ByteBuffer byteBuffer, String mimetype) {
        this.byteBuffer = Objects.requireNonNull(byteBuffer, "byteBuffer is null");
        this.mimetype = Objects.requireNonNull(mimetype, "mimetype is null");
    }

    public Optional<Long> contentLength() {
        return Optional.of(Long.valueOf(this.byteBuffer.remaining()));
    }

    public String contentType() {
        return this.mimetype;
    }

    public void subscribe(final Subscriber<? super ByteBuffer> s) {
        if (s == null) {
            throw new NullPointerException("Subscription MUST NOT be null.");
        }
        try {
            s.onSubscribe(new Subscription(){
                private boolean done;

                public void request(long n) {
                    if (this.done) {
                        return;
                    }
                    if (n > 0L) {
                        this.done = true;
                        s.onNext((Object)ByteBufferAsyncRequestBody.this.byteBuffer.asReadOnlyBuffer());
                        s.onComplete();
                    } else {
                        s.onError((Throwable)new IllegalArgumentException("\u00a73.9: non-positive requests are not allowed!"));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void cancel() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (!this.done) {
                            this.done = true;
                        }
                    }
                }
            });
        }
        catch (Throwable ex) {
            log.error(ex, " violated the Reactive Streams rule 2.13 by throwing an exception from onSubscribe.");
        }
    }

    static AsyncRequestBody fromByteBuffer(ByteBuffer byteBuffer) {
        return new ByteBufferAsyncRequestBody(byteBuffer, "application/octet-stream");
    }
}

