/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.s3;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.DataSize;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import java.util.Locale;
import java.util.Optional;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import software.amazon.awssdk.regions.Region;

public class ExchangeS3Config {
    private String s3AwsAccessKey;
    private String s3AwsSecretKey;
    private Optional<Region> s3Region = Optional.empty();
    private Optional<String> s3Endpoint = Optional.empty();
    private int s3MaxErrorRetries = 3;
    private DataSize s3UploadPartSize = DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE);

    public String getS3AwsAccessKey() {
        return this.s3AwsAccessKey;
    }

    @Config(value="exchange.s3.aws-access-key")
    public ExchangeS3Config setS3AwsAccessKey(String s3AwsAccessKey) {
        this.s3AwsAccessKey = s3AwsAccessKey;
        return this;
    }

    public String getS3AwsSecretKey() {
        return this.s3AwsSecretKey;
    }

    @Config(value="exchange.s3.aws-secret-key")
    @ConfigSecuritySensitive
    public ExchangeS3Config setS3AwsSecretKey(String s3AwsSecretKey) {
        this.s3AwsSecretKey = s3AwsSecretKey;
        return this;
    }

    public Optional<Region> getS3Region() {
        return this.s3Region;
    }

    @Config(value="exchange.s3.region")
    public ExchangeS3Config setS3Region(String s3Region) {
        if (s3Region != null) {
            this.s3Region = Optional.of(Region.of((String)s3Region.toLowerCase(Locale.ENGLISH)));
        }
        return this;
    }

    public Optional<String> getS3Endpoint() {
        return this.s3Endpoint;
    }

    @Config(value="exchange.s3.endpoint")
    public ExchangeS3Config setS3Endpoint(String s3Endpoint) {
        this.s3Endpoint = Optional.ofNullable(s3Endpoint);
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getS3MaxErrorRetries() {
        return this.s3MaxErrorRetries;
    }

    @Config(value="exchange.s3.max-error-retries")
    public ExchangeS3Config setS3MaxErrorRetries(int s3MaxErrorRetries) {
        this.s3MaxErrorRetries = s3MaxErrorRetries;
        return this;
    }

    @NotNull
    @MinDataSize(value="5MB")
    @MaxDataSize(value="256MB")
    public @NotNull @MinDataSize(value="5MB") @MaxDataSize(value="256MB") DataSize getS3UploadPartSize() {
        return this.s3UploadPartSize;
    }

    @Config(value="exchange.s3.upload.part-size")
    @ConfigDescription(value="Part size for S3 multi-part upload")
    public ExchangeS3Config setS3UploadPartSize(DataSize s3UploadPartSize) {
        this.s3UploadPartSize = s3UploadPartSize;
        return this;
    }
}

