/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.s3;

import java.util.Base64;
import java.util.Optional;
import java.util.function.Consumer;
import javax.crypto.SecretKey;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.utils.Md5Utils;

public final class S3RequestUtil {
    private S3RequestUtil() {
    }

    static void configureEncryption(Optional<SecretKey> secretKey, PutObjectRequest.Builder requestBuilder) {
        S3RequestUtil.configureEncryption(secretKey, arg_0 -> ((PutObjectRequest.Builder)requestBuilder).sseCustomerAlgorithm(arg_0), arg_0 -> ((PutObjectRequest.Builder)requestBuilder).sseCustomerKey(arg_0), arg_0 -> ((PutObjectRequest.Builder)requestBuilder).sseCustomerKeyMD5(arg_0));
    }

    static void configureEncryption(Optional<SecretKey> secretKey, CreateMultipartUploadRequest.Builder requestBuilder) {
        S3RequestUtil.configureEncryption(secretKey, arg_0 -> ((CreateMultipartUploadRequest.Builder)requestBuilder).sseCustomerAlgorithm(arg_0), arg_0 -> ((CreateMultipartUploadRequest.Builder)requestBuilder).sseCustomerKey(arg_0), arg_0 -> ((CreateMultipartUploadRequest.Builder)requestBuilder).sseCustomerKeyMD5(arg_0));
    }

    static void configureEncryption(Optional<SecretKey> secretKey, UploadPartRequest.Builder requestBuilder) {
        S3RequestUtil.configureEncryption(secretKey, arg_0 -> ((UploadPartRequest.Builder)requestBuilder).sseCustomerAlgorithm(arg_0), arg_0 -> ((UploadPartRequest.Builder)requestBuilder).sseCustomerKey(arg_0), arg_0 -> ((UploadPartRequest.Builder)requestBuilder).sseCustomerKeyMD5(arg_0));
    }

    static void configureEncryption(Optional<SecretKey> secretKey, GetObjectRequest.Builder requestBuilder) {
        S3RequestUtil.configureEncryption(secretKey, arg_0 -> ((GetObjectRequest.Builder)requestBuilder).sseCustomerAlgorithm(arg_0), arg_0 -> ((GetObjectRequest.Builder)requestBuilder).sseCustomerKey(arg_0), arg_0 -> ((GetObjectRequest.Builder)requestBuilder).sseCustomerKeyMD5(arg_0));
    }

    static void configureEncryption(Optional<SecretKey> secretKey, HeadObjectRequest.Builder requestBuilder) {
        S3RequestUtil.configureEncryption(secretKey, arg_0 -> ((HeadObjectRequest.Builder)requestBuilder).sseCustomerAlgorithm(arg_0), arg_0 -> ((HeadObjectRequest.Builder)requestBuilder).sseCustomerKey(arg_0), arg_0 -> ((HeadObjectRequest.Builder)requestBuilder).sseCustomerKeyMD5(arg_0));
    }

    private static void configureEncryption(Optional<SecretKey> secretKey, Consumer<String> customAlgorithmSetter, Consumer<String> customKeySetter, Consumer<String> customMd5Setter) {
        secretKey.ifPresent(key -> {
            customAlgorithmSetter.accept(ServerSideEncryption.AES256.name());
            customKeySetter.accept(Base64.getEncoder().encodeToString(key.getEncoded()));
            customMd5Setter.accept(Md5Utils.md5AsBase64((byte[])key.getEncoded()));
        });
    }
}

