/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ml;

import com.google.common.base.Preconditions;
import io.trino.plugin.ml.AbstractFeatureTransformation;
import io.trino.plugin.ml.Dataset;
import io.trino.plugin.ml.FeatureVector;
import io.trino.plugin.ml.type.ModelType;
import java.util.HashMap;
import java.util.Map;

public class FeatureVectorUnitNormalizer
extends AbstractFeatureTransformation {
    @Override
    public ModelType getType() {
        return ModelType.MODEL;
    }

    @Override
    public byte[] getSerializedData() {
        return new byte[0];
    }

    public static FeatureVectorUnitNormalizer deserialize(byte[] modelData) {
        Preconditions.checkArgument((modelData.length == 0 ? 1 : 0) != 0, (Object)"modelData should be empty");
        return new FeatureVectorUnitNormalizer();
    }

    @Override
    public void train(Dataset dataset) {
    }

    @Override
    public FeatureVector transform(FeatureVector features) {
        double sumSquares = 0.0;
        for (Double value : features.getFeatures().values()) {
            sumSquares += value * value;
        }
        double magnitude = Math.sqrt(sumSquares);
        HashMap<Integer, Double> transformed = new HashMap<Integer, Double>();
        for (Map.Entry<Integer, Double> entry : features.getFeatures().entrySet()) {
            transformed.put(entry.getKey(), entry.getValue() / magnitude);
        }
        return new FeatureVector(transformed);
    }
}

