/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function;

import org.apache.pinot.common.function.TimeZoneKey;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.OffsetDateTimeField;
import org.joda.time.field.ScaledDurationField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateTimeUtils.class);
    private static final DateTimeFieldType QUARTER_OF_YEAR = new QuarterOfYearDateTimeField();

    public static DateTimeField getTimestampField(ISOChronology chronology, String unitString) {
        switch (unitString.toLowerCase()) {
            case "millisecond": {
                return chronology.millisOfSecond();
            }
            case "second": {
                return chronology.secondOfMinute();
            }
            case "minute": {
                return chronology.minuteOfHour();
            }
            case "hour": {
                return chronology.hourOfDay();
            }
            case "day": {
                return chronology.dayOfMonth();
            }
            case "week": {
                return chronology.weekOfWeekyear();
            }
            case "month": {
                return chronology.monthOfYear();
            }
            case "quarter": {
                return QUARTER_OF_YEAR.getField((Chronology)chronology);
            }
            case "year": {
                return chronology.year();
            }
        }
        throw new IllegalArgumentException("'" + unitString + "' is not a valid Timestamp field");
    }

    public static ISOChronology getChronology(TimeZoneKey timeZoneKey) {
        return DateTimeZoneIndex.getChronology(timeZoneKey);
    }

    public static final class QuarterOfYearDateTimeField
    extends DateTimeFieldType {
        private static final DateTimeFieldType QUARTER_OF_YEAR = new QuarterOfYearDateTimeField();
        private static final long serialVersionUID = -5677872459807379123L;
        private static final DurationFieldType QUARTER_OF_YEAR_DURATION_FIELD_TYPE = new QuarterOfYearDurationFieldType();

        private QuarterOfYearDateTimeField() {
            super("quarterOfYear");
        }

        public DurationFieldType getDurationType() {
            return QUARTER_OF_YEAR_DURATION_FIELD_TYPE;
        }

        public DurationFieldType getRangeDurationType() {
            return DurationFieldType.years();
        }

        public DateTimeField getField(Chronology chronology) {
            return new OffsetDateTimeField((DateTimeField)new DividedDateTimeField((DateTimeField)new OffsetDateTimeField(chronology.monthOfYear(), -1), QUARTER_OF_YEAR, 3), 1);
        }

        private static class QuarterOfYearDurationFieldType
        extends DurationFieldType {
            private static final long serialVersionUID = -8167713675442491871L;

            public QuarterOfYearDurationFieldType() {
                super("quarters");
            }

            public DurationField getField(Chronology chronology) {
                return new ScaledDurationField(chronology.months(), QUARTER_OF_YEAR_DURATION_FIELD_TYPE, 3);
            }
        }
    }

    public static final class DateTimeZoneIndex {
        private static final DateTimeZone[] DATE_TIME_ZONES = new DateTimeZone[TimeZoneKey.MAX_TIME_ZONE_KEY + 1];
        private static final ISOChronology[] CHRONOLOGIES = new ISOChronology[TimeZoneKey.MAX_TIME_ZONE_KEY + 1];
        private static final int[] FIXED_ZONE_OFFSET = new int[TimeZoneKey.MAX_TIME_ZONE_KEY + 1];
        private static final int VARIABLE_ZONE = Integer.MAX_VALUE;

        private DateTimeZoneIndex() {
        }

        public static ISOChronology getChronology(TimeZoneKey zoneKey) {
            return CHRONOLOGIES[zoneKey.getKey()];
        }

        public static DateTimeZone getDateTimeZone(TimeZoneKey zoneKey) {
            return DATE_TIME_ZONES[zoneKey.getKey()];
        }

        static {
            for (TimeZoneKey timeZoneKey : TimeZoneKey.getTimeZoneKeys()) {
                DateTimeZone dateTimeZone;
                short zoneKey = timeZoneKey.getKey();
                try {
                    dateTimeZone = DateTimeZone.forID((String)timeZoneKey.getId());
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Exception while extracting time zone field", (Throwable)e);
                    continue;
                }
                DateTimeZoneIndex.DATE_TIME_ZONES[zoneKey] = dateTimeZone;
                DateTimeZoneIndex.CHRONOLOGIES[zoneKey] = ISOChronology.getInstance((DateTimeZone)dateTimeZone);
                if (dateTimeZone.isFixed() && dateTimeZone.getOffset(0L) % 60000 == 0) {
                    DateTimeZoneIndex.FIXED_ZONE_OFFSET[zoneKey] = dateTimeZone.getOffset(0L) / 60000;
                    continue;
                }
                DateTimeZoneIndex.FIXED_ZONE_OFFSET[zoneKey] = Integer.MAX_VALUE;
            }
        }
    }
}

