/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.spi.annotations.ScalarFunction;
import org.apache.pinot.spi.utils.JsonUtils;

public class JsonFunctions {
    private JsonFunctions() {
    }

    @ScalarFunction
    public static String toJsonMapStr(Map map) throws JsonProcessingException {
        return JsonUtils.objectToString((Object)map);
    }

    @ScalarFunction
    public static String jsonFormat(Object object) throws JsonProcessingException {
        return JsonUtils.objectToString((Object)object);
    }

    @ScalarFunction
    public static Object jsonPath(Object object, String jsonPath) {
        if (object instanceof String) {
            return JsonPath.read((String)((String)object), (String)jsonPath, (Predicate[])new Predicate[0]);
        }
        return JsonPath.read((Object)object, (String)jsonPath, (Predicate[])new Predicate[0]);
    }

    @ScalarFunction
    public static Object[] jsonPathArray(Object object, String jsonPath) throws JsonProcessingException {
        if (object instanceof String) {
            return JsonFunctions.convertObjectToArray(JsonPath.read((String)((String)object), (String)jsonPath, (Predicate[])new Predicate[0]));
        }
        if (object instanceof Object[]) {
            return JsonFunctions.convertObjectToArray(JsonPath.read((String)JsonUtils.objectToString((Object)object), (String)jsonPath, (Predicate[])new Predicate[0]));
        }
        return JsonFunctions.convertObjectToArray(JsonPath.read((Object)object, (String)jsonPath, (Predicate[])new Predicate[0]));
    }

    private static Object[] convertObjectToArray(Object arrayObject) {
        if (arrayObject instanceof List) {
            return ((List)arrayObject).toArray();
        }
        if (arrayObject instanceof Object[]) {
            return (Object[])arrayObject;
        }
        return new Object[]{arrayObject};
    }

    @ScalarFunction
    public static String jsonPathString(Object object, String jsonPath) throws JsonProcessingException {
        Object jsonValue = JsonFunctions.jsonPath(object, jsonPath);
        if (jsonValue instanceof String) {
            return (String)jsonValue;
        }
        return JsonUtils.objectToString((Object)jsonValue);
    }

    @ScalarFunction
    public static String jsonPathString(Object object, String jsonPath, String defaultValue) {
        try {
            return JsonFunctions.jsonPathString(object, jsonPath);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @ScalarFunction
    public static long jsonPathLong(Object object, String jsonPath) {
        Object jsonValue = JsonFunctions.jsonPath(object, jsonPath);
        if (jsonValue == null) {
            return Long.MIN_VALUE;
        }
        if (jsonValue instanceof Number) {
            return ((Number)jsonValue).longValue();
        }
        return Long.parseLong(jsonValue.toString());
    }

    @ScalarFunction
    public static long jsonPathLong(Object object, String jsonPath, long defaultValue) {
        try {
            return JsonFunctions.jsonPathLong(object, jsonPath);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @ScalarFunction
    public static double jsonPathDouble(Object object, String jsonPath) {
        Object jsonValue = JsonFunctions.jsonPath(object, jsonPath);
        if (jsonValue instanceof Number) {
            return ((Number)jsonValue).doubleValue();
        }
        return Double.parseDouble(jsonValue.toString());
    }

    @ScalarFunction
    public static double jsonPathDouble(Object object, String jsonPath, double defaultValue) {
        try {
            return JsonFunctions.jsonPathDouble(object, jsonPath);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    static {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private final JsonProvider jsonProvider = new JacksonJsonProvider();
            private final MappingProvider mappingProvider = new JacksonMappingProvider();

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }
        });
    }
}

