/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.messages;

import java.util.UUID;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.Message;

public class RoutingTableRebuildMessage
extends Message {
    public static final String REBUILD_ROUTING_TABLE_MSG_SUB_TYPE = "REBUILD_ROUTING_TABLE";
    private static final String TABLE_NAME_KEY = "tableName";

    public RoutingTableRebuildMessage(String tableNameWithType) {
        super(Message.MessageType.USER_DEFINE_MSG, UUID.randomUUID().toString());
        this.setMsgSubType(REBUILD_ROUTING_TABLE_MSG_SUB_TYPE);
        this.setExecutionTimeout(-1);
        ZNRecord znRecord = this.getRecord();
        znRecord.setSimpleField(TABLE_NAME_KEY, tableNameWithType);
    }

    public RoutingTableRebuildMessage(Message message) {
        super(message.getRecord());
        if (!message.getMsgSubType().equals(REBUILD_ROUTING_TABLE_MSG_SUB_TYPE)) {
            throw new IllegalArgumentException("Invalid message subtype:" + message.getMsgSubType());
        }
    }

    public String getTableNameWithType() {
        return this.getRecord().getSimpleField(TABLE_NAME_KEY);
    }
}

