/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.I0Itec.zkclient.exception.ZkBadVersionException;
import org.apache.helix.AccessOption;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.metadata.instance.InstanceZKMetadata;
import org.apache.pinot.common.metadata.segment.LLCRealtimeSegmentZKMetadata;
import org.apache.pinot.common.metadata.segment.OfflineSegmentZKMetadata;
import org.apache.pinot.common.metadata.segment.RealtimeSegmentZKMetadata;
import org.apache.pinot.common.utils.SchemaUtils;
import org.apache.pinot.common.utils.SegmentName;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.common.utils.config.TableConfigUtils;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.config.ConfigUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZKMetadataProvider.class);
    private static final String CLUSTER_TENANT_ISOLATION_ENABLED_KEY = "tenantIsolationEnabled";
    private static final String PROPERTYSTORE_SEGMENTS_PREFIX = "/SEGMENTS";
    private static final String PROPERTYSTORE_SCHEMAS_PREFIX = "/SCHEMAS";
    private static final String PROPERTYSTORE_INSTANCE_PARTITIONS_PREFIX = "/INSTANCE_PARTITIONS";
    private static final String PROPERTYSTORE_TABLE_CONFIGS_PREFIX = "/CONFIGS/TABLE";
    private static final String PROPERTYSTORE_INSTANCE_CONFIGS_PREFIX = "/CONFIGS/INSTANCE";
    private static final String PROPERTYSTORE_CLUSTER_CONFIGS_PREFIX = "/CONFIGS/CLUSTER";
    private static final String PROPERTYSTORE_SEGMENT_LINEAGE = "/SEGMENT_LINEAGE";
    private static final String PROPERTYSTORE_MINION_TASK_METADATA_PREFIX = "/MINION_TASK_METADATA";

    private ZKMetadataProvider() {
    }

    public static void setRealtimeTableConfig(ZkHelixPropertyStore<ZNRecord> propertyStore, String realtimeTableName, ZNRecord znRecord) {
        propertyStore.set(ZKMetadataProvider.constructPropertyStorePathForResourceConfig(realtimeTableName), (Object)znRecord, AccessOption.PERSISTENT);
    }

    public static void setOfflineTableConfig(ZkHelixPropertyStore<ZNRecord> propertyStore, String offlineTableName, ZNRecord znRecord) {
        propertyStore.set(ZKMetadataProvider.constructPropertyStorePathForResourceConfig(offlineTableName), (Object)znRecord, AccessOption.PERSISTENT);
    }

    public static void setInstanceZKMetadata(ZkHelixPropertyStore<ZNRecord> propertyStore, InstanceZKMetadata instanceZKMetadata) {
        ZNRecord znRecord = instanceZKMetadata.toZNRecord();
        propertyStore.set(StringUtil.join("/", PROPERTYSTORE_INSTANCE_CONFIGS_PREFIX, instanceZKMetadata.getId()), (Object)znRecord, AccessOption.PERSISTENT);
    }

    public static InstanceZKMetadata getInstanceZKMetadata(ZkHelixPropertyStore<ZNRecord> propertyStore, String instanceId) {
        ZNRecord znRecord = (ZNRecord)propertyStore.get(StringUtil.join("/", PROPERTYSTORE_INSTANCE_CONFIGS_PREFIX, instanceId), null, AccessOption.PERSISTENT);
        if (znRecord == null) {
            return null;
        }
        return new InstanceZKMetadata(znRecord);
    }

    public static String constructPropertyStorePathForSegment(String resourceName, String segmentName) {
        return StringUtil.join("/", PROPERTYSTORE_SEGMENTS_PREFIX, resourceName, segmentName);
    }

    public static String constructPropertyStorePathForSchema(String schemaName) {
        return StringUtil.join("/", PROPERTYSTORE_SCHEMAS_PREFIX, schemaName);
    }

    public static String constructPropertyStorePathForInstancePartitions(String instancePartitionsName) {
        return StringUtil.join("/", PROPERTYSTORE_INSTANCE_PARTITIONS_PREFIX, instancePartitionsName);
    }

    public static String constructPropertyStorePathForResource(String resourceName) {
        return StringUtil.join("/", PROPERTYSTORE_SEGMENTS_PREFIX, resourceName);
    }

    public static String constructPropertyStorePathForResourceConfig(String resourceName) {
        return StringUtil.join("/", PROPERTYSTORE_TABLE_CONFIGS_PREFIX, resourceName);
    }

    public static String constructPropertyStorePathForControllerConfig(String controllerConfigKey) {
        return StringUtil.join("/", PROPERTYSTORE_CLUSTER_CONFIGS_PREFIX, controllerConfigKey);
    }

    public static String constructPropertyStorePathForSegmentLineage(String tableNameWithType) {
        return StringUtil.join("/", PROPERTYSTORE_SEGMENT_LINEAGE, tableNameWithType);
    }

    public static String constructPropertyStorePathForMinionTaskMetadata(String taskType, String tableNameWithType) {
        return StringUtil.join("/", PROPERTYSTORE_MINION_TASK_METADATA_PREFIX, taskType, tableNameWithType);
    }

    public static boolean isSegmentExisted(ZkHelixPropertyStore<ZNRecord> propertyStore, String resourceNameForResource, String segmentName) {
        return propertyStore.exists(ZKMetadataProvider.constructPropertyStorePathForSegment(resourceNameForResource, segmentName), AccessOption.PERSISTENT);
    }

    public static void removeResourceSegmentsFromPropertyStore(ZkHelixPropertyStore<ZNRecord> propertyStore, String resourceName) {
        String propertyStorePath = ZKMetadataProvider.constructPropertyStorePathForResource(resourceName);
        if (propertyStore.exists(propertyStorePath, AccessOption.PERSISTENT)) {
            propertyStore.remove(propertyStorePath, AccessOption.PERSISTENT);
        }
    }

    public static void removeResourceConfigFromPropertyStore(ZkHelixPropertyStore<ZNRecord> propertyStore, String resourceName) {
        String propertyStorePath = ZKMetadataProvider.constructPropertyStorePathForResourceConfig(resourceName);
        if (propertyStore.exists(propertyStorePath, AccessOption.PERSISTENT)) {
            propertyStore.remove(propertyStorePath, AccessOption.PERSISTENT);
        }
    }

    public static boolean setOfflineSegmentZKMetadata(ZkHelixPropertyStore<ZNRecord> propertyStore, String offlineTableName, OfflineSegmentZKMetadata offlineSegmentZKMetadata, int expectedVersion) {
        try {
            return propertyStore.set(ZKMetadataProvider.constructPropertyStorePathForSegment(offlineTableName, offlineSegmentZKMetadata.getSegmentName()), (Object)offlineSegmentZKMetadata.toZNRecord(), expectedVersion, AccessOption.PERSISTENT);
        }
        catch (ZkBadVersionException e) {
            return false;
        }
    }

    public static boolean setOfflineSegmentZKMetadata(ZkHelixPropertyStore<ZNRecord> propertyStore, String offlineTableName, OfflineSegmentZKMetadata offlineSegmentZKMetadata) {
        return propertyStore.set(ZKMetadataProvider.constructPropertyStorePathForSegment(offlineTableName, offlineSegmentZKMetadata.getSegmentName()), (Object)offlineSegmentZKMetadata.toZNRecord(), AccessOption.PERSISTENT);
    }

    public static boolean setRealtimeSegmentZKMetadata(ZkHelixPropertyStore<ZNRecord> propertyStore, String realtimeTableName, RealtimeSegmentZKMetadata realtimeSegmentZKMetadata) {
        return propertyStore.set(ZKMetadataProvider.constructPropertyStorePathForSegment(realtimeTableName, realtimeSegmentZKMetadata.getSegmentName()), (Object)realtimeSegmentZKMetadata.toZNRecord(), AccessOption.PERSISTENT);
    }

    @Nullable
    public static ZNRecord getZnRecord(@Nonnull ZkHelixPropertyStore<ZNRecord> propertyStore, @Nonnull String path) {
        Stat stat = new Stat();
        ZNRecord znRecord = (ZNRecord)propertyStore.get(path, stat, AccessOption.PERSISTENT);
        if (znRecord != null) {
            znRecord.setCreationTime(stat.getCtime());
            znRecord.setModifiedTime(stat.getMtime());
            znRecord.setVersion(stat.getVersion());
        }
        return znRecord;
    }

    @Nullable
    public static OfflineSegmentZKMetadata getOfflineSegmentZKMetadata(@Nonnull ZkHelixPropertyStore<ZNRecord> propertyStore, @Nonnull String tableName, @Nonnull String segmentName) {
        String offlineTableName = TableNameBuilder.OFFLINE.tableNameWithType(tableName);
        ZNRecord znRecord = (ZNRecord)propertyStore.get(ZKMetadataProvider.constructPropertyStorePathForSegment(offlineTableName, segmentName), null, AccessOption.PERSISTENT);
        if (znRecord == null) {
            return null;
        }
        return new OfflineSegmentZKMetadata(znRecord);
    }

    @Nullable
    public static RealtimeSegmentZKMetadata getRealtimeSegmentZKMetadata(@Nonnull ZkHelixPropertyStore<ZNRecord> propertyStore, @Nonnull String tableName, @Nonnull String segmentName) {
        String realtimeTableName = TableNameBuilder.REALTIME.tableNameWithType(tableName);
        ZNRecord znRecord = (ZNRecord)propertyStore.get(ZKMetadataProvider.constructPropertyStorePathForSegment(realtimeTableName, segmentName), null, AccessOption.PERSISTENT);
        if (znRecord == null) {
            return null;
        }
        if (SegmentName.isHighLevelConsumerSegmentName(segmentName)) {
            return new RealtimeSegmentZKMetadata(znRecord);
        }
        return new LLCRealtimeSegmentZKMetadata(znRecord);
    }

    @Nullable
    public static TableConfig getTableConfig(@Nonnull ZkHelixPropertyStore<ZNRecord> propertyStore, @Nonnull String tableNameWithType) {
        ZNRecord znRecord = (ZNRecord)propertyStore.get(ZKMetadataProvider.constructPropertyStorePathForResourceConfig(tableNameWithType), null, AccessOption.PERSISTENT);
        if (znRecord == null) {
            return null;
        }
        try {
            TableConfig tableConfig = TableConfigUtils.fromZNRecord(znRecord);
            return (TableConfig)ConfigUtils.applyConfigWithEnvVariables((BaseJsonConfig)tableConfig);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while getting table configuration for table: {}", (Object)tableNameWithType, (Object)e);
            return null;
        }
    }

    @Nullable
    public static TableConfig getOfflineTableConfig(@Nonnull ZkHelixPropertyStore<ZNRecord> propertyStore, @Nonnull String tableName) {
        return ZKMetadataProvider.getTableConfig(propertyStore, TableNameBuilder.OFFLINE.tableNameWithType(tableName));
    }

    @Nullable
    public static TableConfig getRealtimeTableConfig(@Nonnull ZkHelixPropertyStore<ZNRecord> propertyStore, @Nonnull String tableName) {
        return ZKMetadataProvider.getTableConfig(propertyStore, TableNameBuilder.REALTIME.tableNameWithType(tableName));
    }

    public static void setSchema(ZkHelixPropertyStore<ZNRecord> propertyStore, Schema schema) {
        propertyStore.set(ZKMetadataProvider.constructPropertyStorePathForSchema(schema.getSchemaName()), (Object)SchemaUtils.toZNRecord(schema), AccessOption.PERSISTENT);
    }

    @Nullable
    public static Schema getSchema(@Nonnull ZkHelixPropertyStore<ZNRecord> propertyStore, @Nonnull String schemaName) {
        try {
            ZNRecord schemaZNRecord = (ZNRecord)propertyStore.get(ZKMetadataProvider.constructPropertyStorePathForSchema(schemaName), null, AccessOption.PERSISTENT);
            if (schemaZNRecord == null) {
                return null;
            }
            return SchemaUtils.fromZNRecord(schemaZNRecord);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while getting schema: {}", (Object)schemaName, (Object)e);
            return null;
        }
    }

    @Nullable
    public static Schema getTableSchema(@Nonnull ZkHelixPropertyStore<ZNRecord> propertyStore, @Nonnull String tableName) {
        String offlineSchemaNameFromValidationConfig;
        TableConfig offlineTableConfig;
        String realtimeSchemaNameFromValidationConfig;
        TableConfig realtimeTableConfig;
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
        Schema schema = ZKMetadataProvider.getSchema(propertyStore, rawTableName);
        if (schema != null) {
            return schema;
        }
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        if ((tableType == null || tableType == TableType.REALTIME) && (realtimeTableConfig = ZKMetadataProvider.getRealtimeTableConfig(propertyStore, tableName)) != null && (realtimeSchemaNameFromValidationConfig = realtimeTableConfig.getValidationConfig().getSchemaName()) != null) {
            schema = ZKMetadataProvider.getSchema(propertyStore, realtimeSchemaNameFromValidationConfig);
        }
        if (schema == null && (tableType == null || tableType == TableType.OFFLINE) && (offlineTableConfig = ZKMetadataProvider.getOfflineTableConfig(propertyStore, tableName)) != null && (offlineSchemaNameFromValidationConfig = offlineTableConfig.getValidationConfig().getSchemaName()) != null) {
            schema = ZKMetadataProvider.getSchema(propertyStore, offlineSchemaNameFromValidationConfig);
        }
        if (schema != null) {
            LOGGER.warn("Schema name does not match raw table name, schema name: {}, raw table name: {}", (Object)schema.getSchemaName(), (Object)TableNameBuilder.extractRawTableName((String)tableName));
        }
        return schema;
    }

    public static List<OfflineSegmentZKMetadata> getOfflineSegmentZKMetadataListForTable(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableName) {
        String offlineTableName = TableNameBuilder.OFFLINE.tableNameWithType(tableName);
        String parentPath = ZKMetadataProvider.constructPropertyStorePathForResource(offlineTableName);
        List znRecords = propertyStore.getChildren(parentPath, null, AccessOption.PERSISTENT, 2, 50);
        if (znRecords != null) {
            int numZNRecords = znRecords.size();
            ArrayList<OfflineSegmentZKMetadata> offlineSegmentZKMetadataList = new ArrayList<OfflineSegmentZKMetadata>(numZNRecords);
            for (ZNRecord znRecord : znRecords) {
                if (znRecord == null) continue;
                offlineSegmentZKMetadataList.add(new OfflineSegmentZKMetadata(znRecord));
            }
            int numNullZNRecords = numZNRecords - offlineSegmentZKMetadataList.size();
            if (numNullZNRecords > 0) {
                LOGGER.warn("Failed to read {}/{} offline segment ZK metadata under path: {}", new Object[]{numZNRecords - numNullZNRecords, numZNRecords, parentPath});
            }
            return offlineSegmentZKMetadataList;
        }
        LOGGER.warn("Path: {} does not exist", (Object)parentPath);
        return Collections.emptyList();
    }

    public static List<RealtimeSegmentZKMetadata> getRealtimeSegmentZKMetadataListForTable(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableName) {
        String realtimeTableName = TableNameBuilder.REALTIME.tableNameWithType(tableName);
        String parentPath = ZKMetadataProvider.constructPropertyStorePathForResource(realtimeTableName);
        List znRecords = propertyStore.getChildren(parentPath, null, AccessOption.PERSISTENT, 2, 50);
        if (znRecords != null) {
            int numZNRecords = znRecords.size();
            ArrayList<RealtimeSegmentZKMetadata> realtimeSegmentZKMetadataList = new ArrayList<RealtimeSegmentZKMetadata>(numZNRecords);
            for (ZNRecord znRecord : znRecords) {
                if (znRecord == null) continue;
                realtimeSegmentZKMetadataList.add(new RealtimeSegmentZKMetadata(znRecord));
            }
            int numNullZNRecords = numZNRecords - realtimeSegmentZKMetadataList.size();
            if (numNullZNRecords > 0) {
                LOGGER.warn("Failed to read {}/{} realtime segment ZK metadata under path: {}", new Object[]{numZNRecords - numNullZNRecords, numZNRecords, parentPath});
            }
            return realtimeSegmentZKMetadataList;
        }
        LOGGER.warn("Path: {} does not exist", (Object)parentPath);
        return Collections.emptyList();
    }

    public static List<LLCRealtimeSegmentZKMetadata> getLLCRealtimeSegmentZKMetadataListForTable(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableName) {
        String realtimeTableName = TableNameBuilder.REALTIME.tableNameWithType(tableName);
        String parentPath = ZKMetadataProvider.constructPropertyStorePathForResource(realtimeTableName);
        List znRecords = propertyStore.getChildren(parentPath, null, AccessOption.PERSISTENT, 2, 50);
        if (znRecords != null) {
            int numZNRecords = znRecords.size();
            ArrayList<LLCRealtimeSegmentZKMetadata> llcRealtimeSegmentZKMetadataList = new ArrayList<LLCRealtimeSegmentZKMetadata>(numZNRecords);
            for (ZNRecord znRecord : znRecords) {
                if (znRecord == null) continue;
                llcRealtimeSegmentZKMetadataList.add(new LLCRealtimeSegmentZKMetadata(znRecord));
            }
            int numNullZNRecords = numZNRecords - llcRealtimeSegmentZKMetadataList.size();
            if (numNullZNRecords > 0) {
                LOGGER.warn("Failed to read {}/{} LLC realtime segment ZK metadata under path: {}", new Object[]{numZNRecords - numNullZNRecords, numZNRecords, parentPath});
            }
            return llcRealtimeSegmentZKMetadataList;
        }
        LOGGER.warn("Path: {} does not exist", (Object)parentPath);
        return Collections.emptyList();
    }

    public static List<String> getSegments(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableNameWithType) {
        String segmentsPath = ZKMetadataProvider.constructPropertyStorePathForResource(tableNameWithType);
        if (propertyStore.exists(segmentsPath, AccessOption.PERSISTENT)) {
            return propertyStore.getChildNames(segmentsPath, AccessOption.PERSISTENT);
        }
        return Collections.emptyList();
    }

    public static List<String> getLLCRealtimeSegments(ZkHelixPropertyStore<ZNRecord> propertyStore, String realtimeTableName) {
        ArrayList<String> llcRealtimeSegments = new ArrayList<String>();
        String segmentsPath = ZKMetadataProvider.constructPropertyStorePathForResource(realtimeTableName);
        if (propertyStore.exists(segmentsPath, AccessOption.PERSISTENT)) {
            List segments = propertyStore.getChildNames(segmentsPath, AccessOption.PERSISTENT);
            for (String segment : segments) {
                if (!SegmentName.isLowLevelConsumerSegmentName(segment)) continue;
                llcRealtimeSegments.add(segment);
            }
        }
        return llcRealtimeSegments;
    }

    public static void setClusterTenantIsolationEnabled(ZkHelixPropertyStore<ZNRecord> propertyStore, boolean isSingleTenantCluster) {
        String path = ZKMetadataProvider.constructPropertyStorePathForControllerConfig(CLUSTER_TENANT_ISOLATION_ENABLED_KEY);
        ZNRecord znRecord = !propertyStore.exists(path, AccessOption.PERSISTENT) ? new ZNRecord(CLUSTER_TENANT_ISOLATION_ENABLED_KEY) : (ZNRecord)propertyStore.get(path, null, AccessOption.PERSISTENT);
        znRecord.setBooleanField(CLUSTER_TENANT_ISOLATION_ENABLED_KEY, isSingleTenantCluster);
        propertyStore.set(path, (Object)znRecord, AccessOption.PERSISTENT);
    }

    public static boolean getClusterTenantIsolationEnabled(ZkHelixPropertyStore<ZNRecord> propertyStore) {
        String controllerConfigPath = ZKMetadataProvider.constructPropertyStorePathForControllerConfig(CLUSTER_TENANT_ISOLATION_ENABLED_KEY);
        if (propertyStore.exists(controllerConfigPath, AccessOption.PERSISTENT)) {
            ZNRecord znRecord = (ZNRecord)propertyStore.get(controllerConfigPath, null, AccessOption.PERSISTENT);
            if (znRecord.getSimpleFields().containsKey(CLUSTER_TENANT_ISOLATION_ENABLED_KEY)) {
                return znRecord.getBooleanField(CLUSTER_TENANT_ISOLATION_ENABLED_KEY, true);
            }
            return true;
        }
        return true;
    }
}

