/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metadata.segment;

import java.util.Map;
import org.apache.helix.ZNRecord;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.spi.utils.CommonConstants;
import org.apache.pinot.spi.utils.EqualityUtils;

public class OfflineSegmentZKMetadata
extends SegmentZKMetadata {
    private String _downloadUrl = null;
    private long _pushTime = Long.MIN_VALUE;
    private long _refreshTime = Long.MIN_VALUE;

    public OfflineSegmentZKMetadata() {
        this.setSegmentType(CommonConstants.Segment.SegmentType.OFFLINE);
    }

    public OfflineSegmentZKMetadata(ZNRecord znRecord) {
        super(znRecord);
        this.setSegmentType(CommonConstants.Segment.SegmentType.OFFLINE);
        this._downloadUrl = znRecord.getSimpleField("segment.offline.download.url");
        this._pushTime = znRecord.getLongField("segment.offline.push.time", Long.MIN_VALUE);
        this._refreshTime = znRecord.getLongField("segment.offline.refresh.time", Long.MIN_VALUE);
    }

    public String getDownloadUrl() {
        return this._downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this._downloadUrl = downloadUrl;
    }

    public long getPushTime() {
        return this._pushTime;
    }

    public void setPushTime(long pushTime) {
        this._pushTime = pushTime;
    }

    public long getRefreshTime() {
        return this._refreshTime;
    }

    public void setRefreshTime(long currentTimeMillis) {
        this._refreshTime = currentTimeMillis;
    }

    @Override
    public ZNRecord toZNRecord() {
        ZNRecord znRecord = super.toZNRecord();
        znRecord.setSimpleField("segment.offline.download.url", this._downloadUrl);
        znRecord.setLongField("segment.offline.push.time", this._pushTime);
        znRecord.setLongField("segment.offline.refresh.time", this._refreshTime);
        return znRecord;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        String newline = "\n";
        result.append(this.getClass().getName());
        result.append(" Object {");
        result.append(newline);
        result.append("  " + super.getClass().getName() + " : " + super.toString());
        result.append(newline);
        result.append("  segment.offline.download.url : " + this._downloadUrl);
        result.append(newline);
        result.append("  segment.offline.push.time : " + this._pushTime);
        result.append(newline);
        result.append("  segment.offline.refresh.time : " + this._refreshTime);
        result.append(newline);
        result.append("}");
        return result.toString();
    }

    @Override
    public boolean equals(Object segmentMetadata) {
        if (EqualityUtils.isSameReference((Object)this, (Object)segmentMetadata)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass((Object)this, (Object)segmentMetadata)) {
            return false;
        }
        OfflineSegmentZKMetadata metadata = (OfflineSegmentZKMetadata)segmentMetadata;
        return super.equals(metadata) && EqualityUtils.isEqual((long)this._pushTime, (long)metadata._pushTime) && EqualityUtils.isEqual((long)this._refreshTime, (long)metadata._refreshTime) && EqualityUtils.isEqual((Object)this._downloadUrl, (Object)metadata._downloadUrl);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = EqualityUtils.hashCodeOf((int)result, (Object)this._downloadUrl);
        result = EqualityUtils.hashCodeOf((int)result, (long)this._pushTime);
        result = EqualityUtils.hashCodeOf((int)result, (long)this._refreshTime);
        return result;
    }

    @Override
    public Map<String, String> toMap() {
        Map<String, String> configMap = super.toMap();
        configMap.put("segment.offline.download.url", this._downloadUrl);
        configMap.put("segment.offline.push.time", Long.toString(this._pushTime));
        configMap.put("segment.offline.refresh.time", Long.toString(this._refreshTime));
        configMap.put("segment.type", CommonConstants.Segment.SegmentType.OFFLINE.toString());
        return configMap;
    }
}

