/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metadata.segment;

import java.util.Map;
import org.apache.helix.ZNRecord;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.spi.utils.CommonConstants;
import org.apache.pinot.spi.utils.EqualityUtils;

public class RealtimeSegmentZKMetadata
extends SegmentZKMetadata {
    private CommonConstants.Segment.Realtime.Status _status = null;
    private int _sizeThresholdToFlushSegment = -1;
    private String _timeThresholdToFlushSegment = null;

    public RealtimeSegmentZKMetadata() {
        this.setSegmentType(CommonConstants.Segment.SegmentType.REALTIME);
    }

    public RealtimeSegmentZKMetadata(ZNRecord znRecord) {
        super(znRecord);
        this.setSegmentType(CommonConstants.Segment.SegmentType.REALTIME);
        this._status = CommonConstants.Segment.Realtime.Status.valueOf((String)znRecord.getSimpleField("segment.realtime.status"));
        this._sizeThresholdToFlushSegment = znRecord.getIntField("segment.flush.threshold.size", -1);
        String flushThresholdTime = znRecord.getSimpleField("segment.flush.threshold.time");
        if (flushThresholdTime != null && !flushThresholdTime.equals("null")) {
            this._timeThresholdToFlushSegment = znRecord.getSimpleField("segment.flush.threshold.time");
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        String newline = "\n";
        result.append(this.getClass().getName());
        result.append(" Object {");
        result.append(newline);
        result.append("  " + super.getClass().getName() + " : " + super.toString());
        result.append(newline);
        result.append("  segment.realtime.status : " + this._status);
        result.append(newline);
        result.append("}");
        return result.toString();
    }

    @Override
    public ZNRecord toZNRecord() {
        ZNRecord znRecord = super.toZNRecord();
        znRecord.setSimpleField("segment.realtime.status", this._status.toString());
        znRecord.setLongField("segment.flush.threshold.size", (long)this._sizeThresholdToFlushSegment);
        znRecord.setSimpleField("segment.flush.threshold.time", this._timeThresholdToFlushSegment);
        return znRecord;
    }

    @Override
    public boolean equals(Object segmentMetadata) {
        if (EqualityUtils.isSameReference((Object)this, (Object)segmentMetadata)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass((Object)this, (Object)segmentMetadata)) {
            return false;
        }
        RealtimeSegmentZKMetadata metadata = (RealtimeSegmentZKMetadata)segmentMetadata;
        return super.equals(metadata) && EqualityUtils.isEqual((Object)this._status, (Object)metadata._status) && EqualityUtils.isEqual((int)this._sizeThresholdToFlushSegment, (int)metadata._sizeThresholdToFlushSegment) && EqualityUtils.isEqual((Object)this._timeThresholdToFlushSegment, (Object)metadata._timeThresholdToFlushSegment);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = EqualityUtils.hashCodeOf((int)result, (Object)this._status);
        result = EqualityUtils.hashCodeOf((int)result, (int)this._sizeThresholdToFlushSegment);
        result = EqualityUtils.hashCodeOf((int)result, (Object)this._timeThresholdToFlushSegment);
        return result;
    }

    @Override
    public Map<String, String> toMap() {
        Map<String, String> configMap = super.toMap();
        configMap.put("segment.realtime.status", this._status.toString());
        configMap.put("segment.type", CommonConstants.Segment.SegmentType.REALTIME.toString());
        configMap.put("segment.flush.threshold.size", Integer.toString(this._sizeThresholdToFlushSegment));
        configMap.put("segment.flush.threshold.time", this._timeThresholdToFlushSegment);
        return configMap;
    }

    public CommonConstants.Segment.Realtime.Status getStatus() {
        return this._status;
    }

    public void setStatus(CommonConstants.Segment.Realtime.Status status) {
        this._status = status;
    }

    public void setSizeThresholdToFlushSegment(int sizeThresholdToFlushSegment) {
        this._sizeThresholdToFlushSegment = sizeThresholdToFlushSegment;
    }

    public int getSizeThresholdToFlushSegment() {
        return this._sizeThresholdToFlushSegment;
    }

    public String getTimeThresholdToFlushSegment() {
        return this._timeThresholdToFlushSegment;
    }

    public void setTimeThresholdToFlushSegment(String timeThresholdPeriodString) {
        this._timeThresholdToFlushSegment = timeThresholdPeriodString;
    }
}

