/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metrics.AbstractMetrics;

public enum BrokerGauge implements AbstractMetrics.Gauge
{
    QUERY_QUOTA_CAPACITY_UTILIZATION_RATE("tables", false),
    MAX_BURST_QPS("tables", false),
    QUERY_RATE_LIMIT_DISABLED("queryQuota", true),
    NETTY_CONNECTION_CONNECT_TIME_MS("nettyConnection", true),
    REQUEST_SIZE("requestSize", false),
    RESIZE_TIME_MS("milliseconds", false);

    private final String brokerGaugeName;
    private final String unit;
    private final boolean global;

    private BrokerGauge(String unit, boolean global) {
        this.unit = unit;
        this.global = global;
        this.brokerGaugeName = Utils.toCamelCase(this.name().toLowerCase());
    }

    @Override
    public String getGaugeName() {
        return this.brokerGaugeName;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public boolean isGlobal() {
        return this.global;
    }
}

