/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metrics.AbstractMetrics;

public enum BrokerMeter implements AbstractMetrics.Meter
{
    UNCAUGHT_GET_EXCEPTIONS("exceptions", true),
    UNCAUGHT_POST_EXCEPTIONS("exceptions", true),
    HEALTHCHECK_BAD_CALLS("healthcheck", true),
    HEALTHCHECK_OK_CALLS("healthcheck", true),
    QUERIES("queries", false),
    REQUEST_COMPILATION_EXCEPTIONS("exceptions", true),
    RESOURCE_MISSING_EXCEPTIONS("exceptions", true),
    QUERY_VALIDATION_EXCEPTIONS("exceptions", false),
    NO_SERVER_FOUND_EXCEPTIONS("exceptions", false),
    REQUEST_TIMEOUT_BEFORE_SCATTERED_EXCEPTIONS("exceptions", false),
    REQUEST_SEND_EXCEPTIONS("exceptions", false),
    RESPONSE_FETCH_EXCEPTIONS("exceptions", false),
    DATA_TABLE_DESERIALIZATION_EXCEPTIONS("exceptions", false),
    RESPONSE_MERGE_EXCEPTIONS("exceptions", false),
    BROKER_RESPONSES_WITH_PROCESSING_EXCEPTIONS("badResponses", false),
    BROKER_RESPONSES_WITH_PARTIAL_SERVERS_RESPONDED("badResponses", false),
    BROKER_RESPONSES_WITH_NUM_GROUPS_LIMIT_REACHED("badResponses", false),
    DOCUMENTS_SCANNED("documents", false),
    ENTRIES_SCANNED_IN_FILTER("documents", false),
    ENTRIES_SCANNED_POST_FILTER("documents", false),
    NUM_RESIZES("numResizes", false),
    REQUEST_CONNECTION_TIMEOUTS("timeouts", false),
    HELIX_ZOOKEEPER_RECONNECTS("reconnects", true),
    REQUEST_DROPPED_DUE_TO_SEND_ERROR("requestDropped", false),
    REQUEST_DROPPED_DUE_TO_CONNECTION_ERROR("requestDropped", false),
    REQUEST_DROPPED_DUE_TO_ACCESS_ERROR("requestsDropped", false),
    ROUTING_TABLE_REBUILD_FAILURES("failures", false),
    GROUP_BY_SIZE("queries", false),
    TOTAL_SERVER_RESPONSE_SIZE("queries", false),
    QUERY_QUOTA_EXCEEDED("exceptions", false),
    NO_SERVING_HOST_FOR_SEGMENT("badResponses", false),
    SERVER_MISSING_FOR_ROUTING("badResponses", false),
    NETTY_CONNECTION_REQUESTS_SENT("nettyConnection", true),
    NETTY_CONNECTION_BYTES_SENT("nettyConnection", true),
    NETTY_CONNECTION_BYTES_RECEIVED("nettyConnection", true),
    PROACTIVE_CLUSTER_CHANGE_CHECK("proactiveClusterChangeCheck", true);

    private final String brokerMeterName;
    private final String unit;
    private final boolean global;

    private BrokerMeter(String unit, boolean global) {
        this.unit = unit;
        this.global = global;
        this.brokerMeterName = Utils.toCamelCase(this.name().toLowerCase());
    }

    @Override
    public String getMeterName() {
        return this.brokerMeterName;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public boolean isGlobal() {
        return this.global;
    }
}

