/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.metrics.PinotMetricUtils;
import org.apache.pinot.spi.metrics.PinotGauge;
import org.apache.pinot.spi.metrics.PinotMetricName;
import org.apache.pinot.spi.metrics.PinotMetricsRegistry;

public class ValidationMetrics {
    private final PinotMetricsRegistry _metricsRegistry;
    private final Map<String, Long> _gaugeValues = new HashMap<String, Long>();
    private final Set<PinotMetricName> _metricNames = new HashSet<PinotMetricName>();
    private final StoredValueGaugeFactory _storedValueGaugeFactory = new StoredValueGaugeFactory();
    private final CurrentTimeMillisDeltaGaugeHoursFactory _currentTimeMillisDeltaGaugeHoursFactory = new CurrentTimeMillisDeltaGaugeHoursFactory();

    public ValidationMetrics(PinotMetricsRegistry metricsRegistry) {
        this._metricsRegistry = metricsRegistry;
    }

    public void updateMissingSegmentCountGauge(String resource, int missingSegmentCount) {
        String fullGaugeName = ValidationMetrics.makeGaugeName(resource, "missingSegmentCount");
        this.makeGauge(fullGaugeName, this.makeMetricName(fullGaugeName), this._storedValueGaugeFactory, missingSegmentCount);
    }

    public void updateOfflineSegmentDelayGauge(String resource, long lastOfflineSegmentTime) {
        String fullGaugeNameHours = ValidationMetrics.makeGaugeName(resource, "offlineSegmentDelayHours");
        this.makeGauge(fullGaugeNameHours, this.makeMetricName(fullGaugeNameHours), this._currentTimeMillisDeltaGaugeHoursFactory, lastOfflineSegmentTime);
    }

    public void updateLastPushTimeGauge(String resource, long lastPushTimeMillis) {
        String fullGaugeNameHours = ValidationMetrics.makeGaugeName(resource, "lastPushTimeDelayHours");
        this.makeGauge(fullGaugeNameHours, this.makeMetricName(fullGaugeNameHours), this._currentTimeMillisDeltaGaugeHoursFactory, lastPushTimeMillis);
    }

    public void updateTotalDocumentCountGauge(String resource, long documentCount) {
        String fullGaugeName = ValidationMetrics.makeGaugeName(resource, "TotalDocumentCount");
        this.makeGauge(fullGaugeName, this.makeMetricName(fullGaugeName), this._storedValueGaugeFactory, documentCount);
    }

    public void updateNonConsumingPartitionCountMetric(String resource, int partitionCount) {
        String fullGaugeName = ValidationMetrics.makeGaugeName(resource, "NonConsumingPartitionCount");
        this.makeGauge(fullGaugeName, this.makeMetricName(fullGaugeName), this._storedValueGaugeFactory, partitionCount);
    }

    public void updateSegmentCountGauge(String resource, long segmentCount) {
        String fullGaugeName = ValidationMetrics.makeGaugeName(resource, "SegmentCount");
        this.makeGauge(fullGaugeName, this.makeMetricName(fullGaugeName), this._storedValueGaugeFactory, segmentCount);
    }

    @VisibleForTesting
    public static String makeGaugeName(String resource, String gaugeName) {
        return "pinot.controller." + resource + "." + gaugeName;
    }

    private PinotMetricName makeMetricName(String gaugeName) {
        return PinotMetricUtils.makePinotMetricName(ValidationMetrics.class, gaugeName);
    }

    private void makeGauge(String gaugeName, PinotMetricName metricName, GaugeFactory<?> gaugeFactory, long value) {
        if (!this._gaugeValues.containsKey(gaugeName)) {
            this._gaugeValues.put(gaugeName, value);
            PinotMetricUtils.makeGauge(this._metricsRegistry, metricName, gaugeFactory.buildGauge(gaugeName));
            this._metricNames.add(metricName);
        } else {
            this._gaugeValues.put(gaugeName, value);
        }
    }

    public void unregisterAllMetrics() {
        for (PinotMetricName metricName : this._metricNames) {
            PinotMetricUtils.removeMetric(this._metricsRegistry, metricName);
        }
        this._metricNames.clear();
        this._gaugeValues.clear();
    }

    @VisibleForTesting
    public long getValueOfGauge(String fullGaugeName) {
        Long value = this._gaugeValues.get(fullGaugeName);
        if (value == null) {
            return 0L;
        }
        return value;
    }

    private class CurrentTimeMillisDeltaGaugeHoursFactory
    implements GaugeFactory<Double> {
        private CurrentTimeMillisDeltaGaugeHoursFactory() {
        }

        @Override
        public PinotGauge<Double> buildGauge(String key) {
            return new CurrentTimeMillisDeltaGaugeHours(key);
        }
    }

    private class StoredValueGaugeFactory
    implements GaugeFactory<Long> {
        private StoredValueGaugeFactory() {
        }

        @Override
        public PinotGauge<Long> buildGauge(String key) {
            return new StoredValueGauge(key);
        }
    }

    private static interface GaugeFactory<T> {
        public PinotGauge<T> buildGauge(String var1);
    }

    private class CurrentTimeMillisDeltaGaugeHours
    implements PinotGauge<Double> {
        private final String key;
        private final double MILLIS_PER_HOUR = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);

        public CurrentTimeMillisDeltaGaugeHours(String key) {
            this.key = key;
        }

        public Double value() {
            Long gaugeValue = ValidationMetrics.this._gaugeValues.get(this.key);
            if (gaugeValue != null && gaugeValue != Long.MIN_VALUE) {
                return (double)(System.currentTimeMillis() - gaugeValue) / this.MILLIS_PER_HOUR;
            }
            return Double.MIN_VALUE;
        }

        public Object getMetric() {
            return this.getGauge();
        }

        public Object getGauge() {
            return PinotMetricUtils.makePinotGauge(avoid -> this.value()).getGauge();
        }
    }

    private class StoredValueGauge
    implements PinotGauge<Long> {
        private final String key;

        public StoredValueGauge(String key) {
            this.key = key;
        }

        public Long value() {
            return ValidationMetrics.this._gaugeValues.get(this.key);
        }

        public Object getGauge() {
            return PinotMetricUtils.makePinotGauge(avoid -> this.value()).getGauge();
        }

        public Object getMetric() {
            return this.getGauge();
        }
    }
}

