/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.minion;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.helix.ZNRecord;
import org.apache.pinot.common.minion.Granularity;
import org.apache.pinot.spi.utils.JsonUtils;

public class MergeRollupTaskMetadata {
    private static final String WATERMARK_KEY_PREFIX = "watermarkMs_";
    private final String _tableNameWithType;
    private final Map<Granularity, Long> _watermarkMap;

    public MergeRollupTaskMetadata(String tableNameWithType, Map<Granularity, Long> watermarkMap) {
        this._tableNameWithType = tableNameWithType;
        this._watermarkMap = watermarkMap;
    }

    public String getTableNameWithType() {
        return this._tableNameWithType;
    }

    public Map<Granularity, Long> getWatermarkMap() {
        return this._watermarkMap;
    }

    public static MergeRollupTaskMetadata fromZNRecord(ZNRecord znRecord) {
        HashMap<Granularity, Long> watermarkMap = new HashMap<Granularity, Long>();
        Map fields = znRecord.getSimpleFields();
        for (Map.Entry entry : fields.entrySet()) {
            watermarkMap.put(Granularity.valueOf(((String)entry.getKey()).split(WATERMARK_KEY_PREFIX)[1]), Long.parseLong((String)entry.getValue()));
        }
        return new MergeRollupTaskMetadata(znRecord.getId(), watermarkMap);
    }

    public ZNRecord toZNRecord() {
        ZNRecord znRecord = new ZNRecord(this._tableNameWithType);
        for (Map.Entry<Granularity, Long> entry : this._watermarkMap.entrySet()) {
            znRecord.setLongField(WATERMARK_KEY_PREFIX + entry.getKey().name(), entry.getValue().longValue());
        }
        return znRecord;
    }

    public String toJsonString() {
        try {
            return JsonUtils.objectToString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return this.toJsonString();
    }
}

