/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.minion;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.helix.ZNRecord;
import org.apache.pinot.spi.utils.JsonUtils;

public class RealtimeToOfflineSegmentsTaskMetadata {
    private static final String WATERMARK_KEY = "watermarkMs";
    private final String _tableNameWithType;
    private final long _watermarkMs;

    public RealtimeToOfflineSegmentsTaskMetadata(String tableNameWithType, long watermarkMs) {
        this._tableNameWithType = tableNameWithType;
        this._watermarkMs = watermarkMs;
    }

    public String getTableNameWithType() {
        return this._tableNameWithType;
    }

    public long getWatermarkMs() {
        return this._watermarkMs;
    }

    public static RealtimeToOfflineSegmentsTaskMetadata fromZNRecord(ZNRecord znRecord) {
        long watermark = znRecord.getLongField(WATERMARK_KEY, 0L);
        return new RealtimeToOfflineSegmentsTaskMetadata(znRecord.getId(), watermark);
    }

    public ZNRecord toZNRecord() {
        ZNRecord znRecord = new ZNRecord(this._tableNameWithType);
        znRecord.setLongField(WATERMARK_KEY, this._watermarkMs);
        return znRecord;
    }

    public String toJsonString() {
        try {
            return JsonUtils.objectToString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return this.toJsonString();
    }
}

