/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.restlet.resources;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.exception.ExceptionUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"timestamp", "errorMessage", "stackTrace"})
public class SegmentErrorInfo {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss z";
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.getDefault());
    private final String _timestamp;
    private final String _errorMessage;
    private final String _stackTrace;

    @JsonCreator
    public SegmentErrorInfo(@JsonProperty(value="timestamp") String timestamp, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="stackTrace") String stackTrace) {
        this._timestamp = timestamp;
        this._errorMessage = errorMessage;
        this._stackTrace = stackTrace;
    }

    public SegmentErrorInfo(long timestampMs, String errorMessage, Exception exception) {
        this._timestamp = SegmentErrorInfo.epochToSDF(timestampMs);
        this._errorMessage = errorMessage;
        this._stackTrace = exception != null ? ExceptionUtils.getStackTrace((Throwable)exception) : null;
    }

    public String getStackTrace() {
        return this._stackTrace;
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public String getTimestamp() {
        return this._timestamp;
    }

    private static String epochToSDF(long millisSinceEpoch) {
        return SIMPLE_DATE_FORMAT.format(new Date(millisSinceEpoch));
    }

    static {
        SIMPLE_DATE_FORMAT.setTimeZone(TimeZone.getDefault());
    }
}

