/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.restlet.resources;

import com.google.common.collect.ImmutableMap;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.Map;

public class SystemResourceInfo {
    private static final int MEGA_BYTES = 0x100000;
    private final String NUM_CORES_KEY = "numCores";
    private final String TOTAL_MEMORY_MB_KEY = "totalMemoryMB";
    private final String MAX_HEAP_SIZE_MB_KEY = "maxHeapSizeMB";
    private final int _numCores;
    private final long _totalMemoryMB;
    private final long _maxHeapSizeMB;

    public SystemResourceInfo() {
        Runtime runtime = Runtime.getRuntime();
        this._numCores = runtime.availableProcessors();
        java.lang.management.OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (osMXBean instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean sunOsMXBean = (OperatingSystemMXBean)osMXBean;
            this._totalMemoryMB = sunOsMXBean.getTotalPhysicalMemorySize() / 0x100000L;
        } else {
            this._totalMemoryMB = runtime.totalMemory() / 0x100000L;
        }
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        this._maxHeapSizeMB = heapMemoryUsage.getMax() / 0x100000L;
    }

    public SystemResourceInfo(Map<String, String> map) {
        this._numCores = Integer.parseInt(map.get("numCores"));
        this._totalMemoryMB = Long.parseLong(map.get("totalMemoryMB"));
        this._maxHeapSizeMB = Long.parseLong(map.get("maxHeapSizeMB"));
    }

    public int getNumCores() {
        return this._numCores;
    }

    public long getTotalMemoryMB() {
        return this._totalMemoryMB;
    }

    public long getMaxHeapSizeMB() {
        return this._maxHeapSizeMB;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("numCores", Integer.toString(this._numCores));
        map.put("totalMemoryMB", Long.toString(this._totalMemoryMB));
        map.put("maxHeapSizeMB", Long.toString(this._maxHeapSizeMB));
        return ImmutableMap.copyOf(map);
    }
}

