/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.segment.generation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.utils.JsonUtils;

public class SegmentGenerationUtils {
    private static final String OFFLINE = "OFFLINE";
    public static final String PINOT_PLUGINS_TAR_GZ = "pinot-plugins.tar.gz";
    public static final String PINOT_PLUGINS_DIR = "pinot-plugins-dir";

    public static String generateSchemaURI(String controllerUri, String table) {
        return String.format("%s/tables/%s/schema", controllerUri, table);
    }

    public static String generateTableConfigURI(String controllerUri, String table) {
        return String.format("%s/tables/%s", controllerUri, table);
    }

    public static Schema getSchema(String schemaURIString) {
        return SegmentGenerationUtils.getSchema(schemaURIString, null);
    }

    public static Schema getSchema(String schemaURIString, String authToken) {
        String schemaJson;
        URI schemaURI;
        try {
            schemaURI = new URI(schemaURIString);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Schema URI is not valid - '" + schemaURIString + "'", e);
        }
        String scheme = schemaURI.getScheme();
        if (PinotFSFactory.isSchemeSupported((String)scheme)) {
            InputStream schemaStream;
            PinotFS pinotFS = PinotFSFactory.create((String)scheme);
            try {
                schemaStream = pinotFS.open(schemaURI);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to fetch schema from PinotFS - '" + schemaURI + "'", e);
            }
            try {
                schemaJson = IOUtils.toString((InputStream)schemaStream, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read from schema file data stream on Pinot fs - '" + schemaURI + "'", e);
            }
        }
        try {
            schemaJson = SegmentGenerationUtils.fetchUrl(schemaURI.toURL(), authToken);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read from Schema URI - '" + schemaURI + "'", e);
        }
        try {
            return Schema.fromString((String)schemaJson);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to decode Pinot schema from json string - '" + schemaJson + "'", e);
        }
    }

    @Deprecated
    public static TableConfig getTableConfig(String tableConfigURIStr) {
        return SegmentGenerationUtils.getTableConfig(tableConfigURIStr, null);
    }

    public static TableConfig getTableConfig(String tableConfigURIStr, String authToken) {
        JsonNode tableJsonNode;
        String tableConfigJson;
        URI tableConfigURI;
        try {
            tableConfigURI = new URI(tableConfigURIStr);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Table config URI is not valid - '" + tableConfigURIStr + "'", e);
        }
        String scheme = tableConfigURI.getScheme();
        if (PinotFSFactory.isSchemeSupported((String)scheme)) {
            PinotFS pinotFS = PinotFSFactory.create((String)scheme);
            try {
                tableConfigJson = IOUtils.toString((InputStream)pinotFS.open(tableConfigURI), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to open table config file stream on Pinot fs - '" + tableConfigURI + "'", e);
            }
        }
        try {
            tableConfigJson = SegmentGenerationUtils.fetchUrl(tableConfigURI.toURL(), authToken);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read from table config file data stream on Pinot fs - '" + tableConfigURI + "'", e);
        }
        try {
            tableJsonNode = new ObjectMapper().readTree(tableConfigJson);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to decode table config into JSON from String - '" + tableConfigJson + "'", e);
        }
        if (tableJsonNode.has(OFFLINE)) {
            tableJsonNode = tableJsonNode.get(OFFLINE);
        }
        try {
            return (TableConfig)JsonUtils.jsonNodeToObject((JsonNode)tableJsonNode, TableConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to decode table config from JSON - '" + tableJsonNode + "'", e);
        }
    }

    public static URI getRelativeOutputPath(URI baseInputDir, URI inputFile, URI outputDir) {
        URI relativePath = baseInputDir.relativize(inputFile);
        Preconditions.checkState((relativePath.getPath().length() > 0 && !relativePath.equals(inputFile) ? 1 : 0) != 0, (Object)("Unable to extract out the relative path for input file '" + inputFile + "', based on base input path: " + baseInputDir));
        String outputDirStr = outputDir.toString();
        outputDir = !outputDirStr.endsWith("/") ? URI.create(outputDirStr.concat("/")) : outputDir;
        URI relativeOutputURI = outputDir.resolve(relativePath).resolve(".");
        return relativeOutputURI;
    }

    public static String getFileName(URI inputFileURI) {
        String scheme = inputFileURI.getScheme();
        if (scheme != null && scheme.equalsIgnoreCase("file")) {
            return new File(inputFileURI).getName();
        }
        String[] pathSplits = inputFileURI.getPath().split("/");
        return pathSplits[pathSplits.length - 1];
    }

    public static URI getFileURI(String uriStr, URI fullUriForPathOnlyUriStr) throws URISyntaxException {
        URI fileURI = URI.create(uriStr);
        if (fileURI.getScheme() == null) {
            return new URI(fullUriForPathOnlyUriStr.getScheme(), fullUriForPathOnlyUriStr.getUserInfo(), fullUriForPathOnlyUriStr.getHost(), fullUriForPathOnlyUriStr.getPort(), fileURI.getPath(), fileURI.getQuery(), fileURI.getFragment());
        }
        return fileURI;
    }

    public static URI getDirectoryURI(String uriStr) throws URISyntaxException {
        URI uri = new URI(uriStr);
        if (uri.getScheme() == null) {
            uri = new File(uriStr).toURI();
        }
        return uri;
    }

    private static String fetchUrl(URL url, String authToken) throws IOException {
        URLConnection connection = url.openConnection();
        if (StringUtils.isNotBlank((CharSequence)authToken)) {
            connection.setRequestProperty("Authorization", authToken);
        }
        return IOUtils.toString((InputStream)connection.getInputStream(), (Charset)StandardCharsets.UTF_8);
    }
}

