/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.tier;

import org.apache.helix.HelixManager;
import org.apache.pinot.common.tier.PinotServerTierStorage;
import org.apache.pinot.common.tier.Tier;
import org.apache.pinot.common.tier.TimeBasedTierSegmentSelector;
import org.apache.pinot.spi.config.table.TierConfig;

public final class TierFactory {
    public static final String TIME_SEGMENT_SELECTOR_TYPE = "time";
    public static final String PINOT_SERVER_STORAGE_TYPE = "pinot_server";

    private TierFactory() {
    }

    public static Tier getTier(TierConfig tierConfig, HelixManager helixManager) {
        String segmentSelectorType = tierConfig.getSegmentSelectorType();
        if (!segmentSelectorType.equalsIgnoreCase(TIME_SEGMENT_SELECTOR_TYPE)) {
            throw new IllegalStateException("Unsupported segmentSelectorType: " + segmentSelectorType);
        }
        TimeBasedTierSegmentSelector segmentSelector = new TimeBasedTierSegmentSelector(helixManager, tierConfig.getSegmentAge());
        String storageSelectorType = tierConfig.getStorageType();
        if (!storageSelectorType.equalsIgnoreCase(PINOT_SERVER_STORAGE_TYPE)) {
            throw new IllegalStateException("Unsupported storageType: " + storageSelectorType);
        }
        PinotServerTierStorage storageSelector = new PinotServerTierStorage(tierConfig.getServerTag());
        return new Tier(tierConfig.getName(), segmentSelector, storageSelector);
    }
}

