/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.pinot.common.exception.HttpErrorStatusException;
import org.apache.pinot.common.restlet.resources.StartReplaceSegmentsRequest;
import org.apache.pinot.common.utils.SimpleHttpResponse;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.common.utils.URIUtils;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadDownloadClient
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUploadDownloadClient.class);
    public static SSLContext _defaultSSLContext;
    public static final int DEFAULT_SOCKET_TIMEOUT_MS = 600000;
    public static final int GET_REQUEST_SOCKET_TIMEOUT_MS = 5000;
    public static final int DELETE_REQUEST_SOCKET_TIMEOUT_MS = 10000;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String SCHEMA_PATH = "/schemas";
    private static final String OLD_SEGMENT_PATH = "/segments";
    private static final String SEGMENT_PATH = "/v2/segments";
    private static final String TABLES_PATH = "/tables";
    private static final String TYPE_DELIMITER = "type=";
    private static final String START_REPLACE_SEGMENTS_PATH = "/startReplaceSegments";
    private static final String END_REPLACE_SEGMENTS_PATH = "/endReplaceSegments";
    private static final String SEGMENT_LINEAGE_ENTRY_ID_PARAMETER = "&segmentLineageEntryId=";
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final List<String> SUPPORTED_PROTOCOLS;
    private final CloseableHttpClient _httpClient;

    public FileUploadDownloadClient() {
        this(_defaultSSLContext);
    }

    public FileUploadDownloadClient(@Nullable SSLContext sslContext) {
        if (sslContext == null) {
            sslContext = _defaultSSLContext;
        }
        this._httpClient = HttpClients.custom().setSSLContext(sslContext).build();
    }

    private static URI getURI(String protocol, String host, int port, String path) throws URISyntaxException {
        if (!SUPPORTED_PROTOCOLS.contains(protocol)) {
            throw new IllegalArgumentException(String.format("Unsupported protocol '%s'", protocol));
        }
        return new URI(protocol, null, host, port, path, null, null);
    }

    private static URI getURI(String protocol, String host, int port, String path, String query) throws URISyntaxException {
        if (!SUPPORTED_PROTOCOLS.contains(protocol)) {
            throw new IllegalArgumentException(String.format("Unsupported protocol '%s'", protocol));
        }
        return new URI(protocol, null, host, port, path, query, null);
    }

    @Deprecated
    public static URI getRetrieveTableConfigHttpURI(String host, int port, String rawTableName) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTP, host, port, "/tables/" + rawTableName);
    }

    public static URI getRetrieveTableConfigURI(String protocol, String host, int port, String rawTableName) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(protocol, host, port, "/tables/" + rawTableName);
    }

    @Deprecated
    public static URI getDeleteSegmentHttpUri(String host, int port, String rawTableName, String segmentName, String tableType) throws URISyntaxException {
        return new URI(StringUtil.join("/", StringUtils.chomp((String)("http://" + host + ":" + port), (String)"/"), OLD_SEGMENT_PATH, rawTableName + "/" + URIUtils.encode(segmentName) + "?type=" + tableType));
    }

    @Deprecated
    public static URI getRetrieveAllSegmentWithTableTypeHttpUri(String host, int port, String rawTableName, String tableType) throws URISyntaxException {
        return new URI(StringUtil.join("/", StringUtils.chomp((String)("http://" + host + ":" + port), (String)"/"), OLD_SEGMENT_PATH, rawTableName + "?type=" + tableType));
    }

    @Deprecated
    public static URI getRetrieveSchemaHttpURI(String host, int port, String schemaName) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTP, host, port, "/schemas/" + schemaName);
    }

    public static URI getRetrieveSchemaURI(String protocol, String host, int port, String schemaName) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(protocol, host, port, "/schemas/" + schemaName);
    }

    @Deprecated
    public static URI getUploadSchemaHttpURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTP, host, port, SCHEMA_PATH);
    }

    @Deprecated
    public static URI getUploadSchemaHttpsURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTPS, host, port, SCHEMA_PATH);
    }

    public static URI getUploadSchemaURI(String protocol, String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(protocol, host, port, SCHEMA_PATH);
    }

    public static URI getUploadSchemaURI(URI controllerURI) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(controllerURI.getScheme(), controllerURI.getHost(), controllerURI.getPort(), SCHEMA_PATH);
    }

    @Deprecated
    public static URI getOldUploadSegmentHttpURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTP, host, port, OLD_SEGMENT_PATH);
    }

    @Deprecated
    public static URI getOldUploadSegmentHttpsURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTPS, host, port, OLD_SEGMENT_PATH);
    }

    @Deprecated
    public static URI getUploadSegmentHttpURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTP, host, port, SEGMENT_PATH);
    }

    @Deprecated
    public static URI getUploadSegmentHttpsURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTPS, host, port, SEGMENT_PATH);
    }

    public static URI getUploadSegmentURI(String protocol, String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(protocol, host, port, SEGMENT_PATH);
    }

    public static URI getUploadSegmentURI(URI controllerURI) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(controllerURI.getScheme(), controllerURI.getHost(), controllerURI.getPort(), SEGMENT_PATH);
    }

    public static URI getStartReplaceSegmentsURI(URI controllerURI, String rawTableName, String tableType) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(controllerURI.getScheme(), controllerURI.getHost(), controllerURI.getPort(), "/segments/" + rawTableName + START_REPLACE_SEGMENTS_PATH, TYPE_DELIMITER + tableType);
    }

    public static URI getEndReplaceSegmentsURI(URI controllerURI, String rawTableName, String tableType, String segmentLineageEntryId) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(controllerURI.getScheme(), controllerURI.getHost(), controllerURI.getPort(), "/segments/" + rawTableName + END_REPLACE_SEGMENTS_PATH, TYPE_DELIMITER + tableType + SEGMENT_LINEAGE_ENTRY_ID_PARAMETER + segmentLineageEntryId);
    }

    private static HttpUriRequest getUploadFileRequest(String method, URI uri, ContentBody contentBody, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) {
        HttpEntity entity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addPart(contentBody.getFilename(), contentBody).build();
        RequestBuilder requestBuilder = RequestBuilder.create((String)method).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setUri(uri).setEntity(entity);
        FileUploadDownloadClient.addHeadersAndParameters(requestBuilder, headers, parameters);
        FileUploadDownloadClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static HttpUriRequest getDeleteFileRequest(String method, URI uri, ContentBody contentBody, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) {
        HttpEntity entity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addPart(contentBody.getFilename(), contentBody).build();
        RequestBuilder requestBuilder = RequestBuilder.create((String)method).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setUri(uri).setEntity(entity);
        FileUploadDownloadClient.addHeadersAndParameters(requestBuilder, headers, parameters);
        FileUploadDownloadClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static HttpUriRequest getAddSchemaRequest(URI uri, String schemaName, File schemaFile, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters) {
        return FileUploadDownloadClient.getUploadFileRequest("POST", uri, FileUploadDownloadClient.getContentBody(schemaName, schemaFile), headers, parameters, 600000);
    }

    private static HttpUriRequest getUploadSegmentRequest(URI uri, String segmentName, File segmentFile, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) {
        return FileUploadDownloadClient.getUploadFileRequest("POST", uri, FileUploadDownloadClient.getContentBody(segmentName, segmentFile), headers, parameters, socketTimeoutMs);
    }

    private static HttpUriRequest getUploadSegmentRequest(URI uri, String segmentName, InputStream inputStream, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) {
        return FileUploadDownloadClient.getUploadFileRequest("POST", uri, FileUploadDownloadClient.getContentBody(segmentName, inputStream), headers, parameters, socketTimeoutMs);
    }

    private static HttpUriRequest getUploadSegmentMetadataRequest(URI uri, String segmentName, File segmentFile, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) {
        return FileUploadDownloadClient.getUploadFileRequest("POST", uri, FileUploadDownloadClient.getContentBody(segmentName, segmentFile), headers, parameters, socketTimeoutMs);
    }

    private static HttpUriRequest getUploadSegmentMetadataFilesRequest(URI uri, Map<String, File> metadataFiles, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int segmentUploadRequestTimeoutMs) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (Map.Entry<String, File> entry : metadataFiles.entrySet()) {
            multipartEntityBuilder.addPart(entry.getKey(), FileUploadDownloadClient.getContentBody(entry.getKey(), entry.getValue()));
        }
        HttpEntity entity = multipartEntityBuilder.build();
        RequestBuilder requestBuilder = RequestBuilder.create((String)"POST").setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setUri(uri).setEntity(entity);
        FileUploadDownloadClient.addHeadersAndParameters(requestBuilder, headers, parameters);
        FileUploadDownloadClient.setTimeout(requestBuilder, segmentUploadRequestTimeoutMs);
        return requestBuilder.build();
    }

    private static HttpUriRequest getSendSegmentUriRequest(URI uri, String downloadUri, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) {
        RequestBuilder requestBuilder = RequestBuilder.post((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setHeader("UPLOAD_TYPE", FileUploadType.URI.toString()).setHeader("DOWNLOAD_URI", downloadUri).setHeader("Content-Type", JSON_CONTENT_TYPE);
        FileUploadDownloadClient.addHeadersAndParameters(requestBuilder, headers, parameters);
        FileUploadDownloadClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static HttpUriRequest getSendSegmentJsonRequest(URI uri, String jsonString, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) {
        RequestBuilder requestBuilder = RequestBuilder.post((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setHeader("UPLOAD_TYPE", FileUploadType.JSON.toString()).setEntity((HttpEntity)new StringEntity(jsonString, ContentType.APPLICATION_JSON));
        FileUploadDownloadClient.addHeadersAndParameters(requestBuilder, headers, parameters);
        FileUploadDownloadClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static HttpUriRequest getStartReplaceSegmentsRequest(URI uri, String jsonRequestBody, int socketTimeoutMs) {
        RequestBuilder requestBuilder = RequestBuilder.post((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setHeader("Content-Type", JSON_CONTENT_TYPE).setEntity((HttpEntity)new StringEntity(jsonRequestBody, ContentType.APPLICATION_JSON));
        FileUploadDownloadClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static HttpUriRequest getEndReplaceSegmentsRequest(URI uri, int socketTimeoutMs) {
        RequestBuilder requestBuilder = RequestBuilder.post((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setHeader("Content-Type", JSON_CONTENT_TYPE);
        FileUploadDownloadClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static HttpUriRequest getSegmentCompletionProtocolRequest(URI uri, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) {
        RequestBuilder requestBuilder = RequestBuilder.get((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        FileUploadDownloadClient.addHeadersAndParameters(requestBuilder, headers, parameters);
        FileUploadDownloadClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static HttpUriRequest getDownloadFileRequest(URI uri, int socketTimeoutMs, String authToken) {
        RequestBuilder requestBuilder = RequestBuilder.get((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        if (StringUtils.isNotBlank((String)authToken)) {
            requestBuilder.addHeader("Authorization", authToken);
        }
        FileUploadDownloadClient.setTimeout(requestBuilder, socketTimeoutMs);
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            String encoded = Base64.encodeBase64String((byte[])StringUtil.encodeUtf8(userInfo));
            String authHeader = "Basic " + encoded;
            requestBuilder.addHeader("Authorization", authHeader);
        }
        return requestBuilder.build();
    }

    private static ContentBody getContentBody(String fileName, File file) {
        return new FileBody(file, ContentType.DEFAULT_BINARY, fileName);
    }

    private static ContentBody getContentBody(String fileName, InputStream inputStream) {
        return new InputStreamBody(inputStream, ContentType.DEFAULT_BINARY, fileName);
    }

    private static void addHeadersAndParameters(RequestBuilder requestBuilder, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters) {
        if (headers != null) {
            for (Header header : headers) {
                requestBuilder.addHeader(header);
            }
        }
        if (parameters != null) {
            for (NameValuePair parameter : parameters) {
                requestBuilder.addParameter(parameter);
            }
        }
    }

    private static void setTimeout(RequestBuilder requestBuilder, int socketTimeoutMs) {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(socketTimeoutMs).build();
        requestBuilder.setConfig(requestConfig);
    }

    private SimpleHttpResponse sendRequest(HttpUriRequest request) throws IOException, HttpErrorStatusException {
        try (CloseableHttpResponse response = this._httpClient.execute(request);){
            int statusCode;
            String controllerHost = null;
            String controllerVersion = null;
            if (response.containsHeader("Pinot-Controller-Host")) {
                controllerHost = response.getFirstHeader("Pinot-Controller-Host").getValue();
                controllerVersion = response.getFirstHeader("Pinot-Controller-Version").getValue();
            }
            if (controllerHost != null) {
                LOGGER.info(String.format("Sending request: %s to controller: %s, version: %s", request.getURI(), controllerHost, controllerVersion));
            }
            if ((statusCode = response.getStatusLine().getStatusCode()) >= 300) {
                throw new HttpErrorStatusException(FileUploadDownloadClient.getErrorMessage(request, response), statusCode);
            }
            SimpleHttpResponse simpleHttpResponse = new SimpleHttpResponse(statusCode, EntityUtils.toString((HttpEntity)response.getEntity()));
            return simpleHttpResponse;
        }
    }

    private static String getErrorMessage(HttpUriRequest request, CloseableHttpResponse response) {
        String reason;
        String controllerHost = null;
        String controllerVersion = null;
        if (response.containsHeader("Pinot-Controller-Host")) {
            controllerHost = response.getFirstHeader("Pinot-Controller-Host").getValue();
            controllerVersion = response.getFirstHeader("Pinot-Controller-Version").getValue();
        }
        StatusLine statusLine = response.getStatusLine();
        try {
            reason = JsonUtils.stringToJsonNode((String)EntityUtils.toString((HttpEntity)response.getEntity())).get("error").asText();
        }
        catch (Exception e) {
            reason = "Failed to get reason";
        }
        String errorMessage = String.format("Got error status code: %d (%s) with reason: \"%s\" while sending request: %s", statusLine.getStatusCode(), statusLine.getReasonPhrase(), reason, request.getURI());
        if (controllerHost != null) {
            errorMessage = String.format("%s to controller: %s, version: %s", errorMessage, controllerHost, controllerVersion);
        }
        return errorMessage;
    }

    @Deprecated
    public SimpleHttpResponse sendGetRequest(URI uri) throws IOException, HttpErrorStatusException {
        RequestBuilder requestBuilder = RequestBuilder.get((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        FileUploadDownloadClient.setTimeout(requestBuilder, 5000);
        return this.sendRequest(requestBuilder.build());
    }

    public SimpleHttpResponse sendGetRequest(URI uri, String authToken) throws IOException, HttpErrorStatusException {
        RequestBuilder requestBuilder = RequestBuilder.get((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        requestBuilder.addHeader("Authorization", authToken);
        FileUploadDownloadClient.setTimeout(requestBuilder, 5000);
        return this.sendRequest(requestBuilder.build());
    }

    @Deprecated
    public SimpleHttpResponse sendDeleteRequest(URI uri) throws IOException, HttpErrorStatusException {
        RequestBuilder requestBuilder = RequestBuilder.delete((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        FileUploadDownloadClient.setTimeout(requestBuilder, 10000);
        return this.sendRequest(requestBuilder.build());
    }

    public SimpleHttpResponse sendDeleteRequest(URI uri, String authToken) throws IOException, HttpErrorStatusException {
        RequestBuilder requestBuilder = RequestBuilder.delete((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        requestBuilder.addHeader("Authorization", authToken);
        FileUploadDownloadClient.setTimeout(requestBuilder, 10000);
        return this.sendRequest(requestBuilder.build());
    }

    @Deprecated
    public SimpleHttpResponse addSchema(URI uri, String schemaName, File schemaFile) throws IOException, HttpErrorStatusException {
        return this.addSchema(uri, schemaName, schemaFile, Collections.emptyList(), Collections.emptyList());
    }

    public SimpleHttpResponse addSchema(URI uri, String schemaName, File schemaFile, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getAddSchemaRequest(uri, schemaName, schemaFile, headers, parameters));
    }

    @Deprecated
    public SimpleHttpResponse updateSchema(URI uri, String schemaName, File schemaFile) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getUploadFileRequest("PUT", uri, FileUploadDownloadClient.getContentBody(schemaName, schemaFile), null, null, 600000));
    }

    public SimpleHttpResponse updateSchema(URI uri, String schemaName, File schemaFile, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getUploadFileRequest("PUT", uri, FileUploadDownloadClient.getContentBody(schemaName, schemaFile), headers, parameters, 600000));
    }

    public SimpleHttpResponse uploadSegmentMetadata(URI uri, String segmentName, File segmentMetadataFile, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getUploadSegmentMetadataRequest(uri, segmentName, segmentMetadataFile, headers, parameters, socketTimeoutMs));
    }

    @Deprecated
    public SimpleHttpResponse uploadSegmentMetadataFiles(URI uri, Map<String, File> metadataFiles, int segmentUploadRequestTimeoutMs) throws IOException, HttpErrorStatusException {
        return this.uploadSegmentMetadataFiles(uri, metadataFiles, Collections.emptyList(), Collections.emptyList(), segmentUploadRequestTimeoutMs);
    }

    public SimpleHttpResponse uploadSegmentMetadataFiles(URI uri, Map<String, File> metadataFiles, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int segmentUploadRequestTimeoutMs) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getUploadSegmentMetadataFilesRequest(uri, metadataFiles, headers, parameters, segmentUploadRequestTimeoutMs));
    }

    public SimpleHttpResponse uploadSegment(URI uri, String segmentName, File segmentFile, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getUploadSegmentRequest(uri, segmentName, segmentFile, headers, parameters, socketTimeoutMs));
    }

    @Deprecated
    public SimpleHttpResponse uploadSegment(URI uri, String segmentName, File segmentFile, String tableName) throws IOException, HttpErrorStatusException {
        BasicNameValuePair tableNameValuePair = new BasicNameValuePair("tableName", tableName);
        List<BasicNameValuePair> parameters = Collections.singletonList(tableNameValuePair);
        return this.uploadSegment(uri, segmentName, segmentFile, null, parameters, 600000);
    }

    public SimpleHttpResponse uploadSegment(URI uri, String segmentName, File segmentFile, String tableName, TableType tableType) throws IOException, HttpErrorStatusException {
        BasicNameValuePair tableNameValuePair = new BasicNameValuePair("tableName", tableName);
        BasicNameValuePair tableTypeValuePair = new BasicNameValuePair("tableType", tableType.name());
        List<NameValuePair> parameters = Arrays.asList(tableNameValuePair, tableTypeValuePair);
        return this.uploadSegment(uri, segmentName, segmentFile, null, parameters, 600000);
    }

    public SimpleHttpResponse uploadSegment(URI uri, String segmentName, InputStream inputStream, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getUploadSegmentRequest(uri, segmentName, inputStream, headers, parameters, socketTimeoutMs));
    }

    public SimpleHttpResponse uploadSegment(URI uri, String segmentName, InputStream inputStream, String rawTableName) throws IOException, HttpErrorStatusException {
        BasicNameValuePair tableNameValuePair = new BasicNameValuePair("tableName", rawTableName);
        List<NameValuePair> parameters = Arrays.asList(tableNameValuePair);
        return this.uploadSegment(uri, segmentName, inputStream, null, parameters, 600000);
    }

    public SimpleHttpResponse sendSegmentUri(URI uri, String downloadUri, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getSendSegmentUriRequest(uri, downloadUri, headers, parameters, socketTimeoutMs));
    }

    @Deprecated
    public SimpleHttpResponse sendSegmentUri(URI uri, String downloadUri, String rawTableName) throws IOException, HttpErrorStatusException {
        BasicNameValuePair tableNameValuePair = new BasicNameValuePair("tableName", rawTableName);
        List<NameValuePair> parameters = Arrays.asList(tableNameValuePair);
        return this.sendSegmentUri(uri, downloadUri, null, parameters, 600000);
    }

    public SimpleHttpResponse sendSegmentJson(URI uri, String jsonString, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getSendSegmentJsonRequest(uri, jsonString, headers, parameters, socketTimeoutMs));
    }

    @Deprecated
    public SimpleHttpResponse sendSegmentJson(URI uri, String jsonString) throws IOException, HttpErrorStatusException {
        return this.sendSegmentJson(uri, jsonString, null, null, 600000);
    }

    public SimpleHttpResponse startReplaceSegments(URI uri, StartReplaceSegmentsRequest startReplaceSegmentsRequest) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getStartReplaceSegmentsRequest(uri, JsonUtils.objectToString((Object)startReplaceSegmentsRequest), 600000));
    }

    public SimpleHttpResponse endReplaceSegments(URI uri) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getEndReplaceSegmentsRequest(uri, 600000));
    }

    @Deprecated
    public SimpleHttpResponse sendSegmentCompletionProtocolRequest(URI uri, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return this.sendSegmentCompletionProtocolRequest(uri, Collections.emptyList(), Collections.emptyList(), socketTimeoutMs);
    }

    public SimpleHttpResponse sendSegmentCompletionProtocolRequest(URI uri, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getSegmentCompletionProtocolRequest(uri, headers, parameters, socketTimeoutMs));
    }

    @Deprecated
    public int downloadFile(URI uri, int socketTimeoutMs, File dest) throws IOException, HttpErrorStatusException {
        return this.downloadFile(uri, socketTimeoutMs, dest, null);
    }

    public int downloadFile(URI uri, int socketTimeoutMs, File dest, String authToken) throws IOException, HttpErrorStatusException {
        HttpUriRequest request = FileUploadDownloadClient.getDownloadFileRequest(uri, socketTimeoutMs, authToken);
        try (CloseableHttpResponse response = this._httpClient.execute(request);){
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode >= 300) {
                throw new HttpErrorStatusException(FileUploadDownloadClient.getErrorMessage(request, response), statusCode);
            }
            HttpEntity entity = response.getEntity();
            try (InputStream inputStream = response.getEntity().getContent();
                 BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(dest));){
                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
            }
            long contentLength = entity.getContentLength();
            if (contentLength >= 0L) {
                long fileLength = dest.length();
                Preconditions.checkState((fileLength == contentLength ? 1 : 0) != 0, (Object)String.format("While downloading file with uri: %s, file length: %d does not match content length: %d", uri, fileLength, contentLength));
            }
            int n = statusCode;
            return n;
        }
    }

    @Deprecated
    public int downloadFile(URI uri, File dest) throws IOException, HttpErrorStatusException {
        return this.downloadFile(uri, dest, null);
    }

    public int downloadFile(URI uri, File dest, String authToken) throws IOException, HttpErrorStatusException {
        return this.downloadFile(uri, 600000, dest, authToken);
    }

    @Override
    public void close() throws IOException {
        this._httpClient.close();
    }

    public static void installDefaultSSLContext(SSLContext sslContext) {
        _defaultSSLContext = sslContext;
    }

    public static List<Header> makeAuthHeader(String authToken) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)authToken)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new BasicHeader("Authorization", authToken));
    }

    public static List<NameValuePair> makeTableParam(String tableName) {
        return Collections.singletonList(new BasicNameValuePair("tableName", tableName));
    }

    static {
        SUPPORTED_PROTOCOLS = Arrays.asList(HTTP, HTTPS);
    }

    public static enum FileUploadType {
        URI,
        JSON,
        SEGMENT,
        METADATA;


        public static FileUploadType getDefaultUploadType() {
            return SEGMENT;
        }
    }

    public static class QueryParameters {
        public static final String ENABLE_PARALLEL_PUSH_PROTECTION = "enableParallelPushProtection";
        public static final String TABLE_NAME = "tableName";
        public static final String TABLE_TYPE = "tableType";
    }

    public static class CustomHeaders {
        public static final String UPLOAD_TYPE = "UPLOAD_TYPE";
        public static final String DOWNLOAD_URI = "DOWNLOAD_URI";
        public static final String SEGMENT_ZK_METADATA_CUSTOM_MAP_MODIFIER = "Pinot-SegmentZKMetadataCustomMapModifier";
        public static final String CRYPTER = "CRYPTER";
    }
}

