/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.sql.Timestamp;
import java.util.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.TimestampUtils;

public enum PinotDataType {
    BOOLEAN{

        @Override
        public int toInt(Object value) {
            return (Boolean)value != false ? 1 : 0;
        }

        @Override
        public long toLong(Object value) {
            return (Boolean)value != false ? 1L : 0L;
        }

        @Override
        public float toFloat(Object value) {
            return (Boolean)value != false ? 1.0f : 0.0f;
        }

        @Override
        public double toDouble(Object value) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }

        @Override
        public boolean toBoolean(Object value) {
            return (Boolean)value;
        }

        @Override
        public Timestamp toTimestamp(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from BOOLEAN to TIMESTAMP");
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }

        @Override
        public byte[] toBytes(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from BOOLEAN to BYTES");
        }

        @Override
        public Boolean convert(Object value, PinotDataType sourceType) {
            return sourceType.toBoolean(value);
        }

        @Override
        public Integer toInternal(Object value) {
            return (Boolean)value != false ? 1 : 0;
        }
    }
    ,
    BYTE{

        @Override
        public int toInt(Object value) {
            return ((Byte)value).intValue();
        }

        @Override
        public long toLong(Object value) {
            return ((Byte)value).longValue();
        }

        @Override
        public float toFloat(Object value) {
            return ((Byte)value).floatValue();
        }

        @Override
        public double toDouble(Object value) {
            return ((Byte)value).doubleValue();
        }

        @Override
        public boolean toBoolean(Object value) {
            return (Byte)value != 0;
        }

        @Override
        public Timestamp toTimestamp(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from BOOLEAN to TIMESTAMP");
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }

        @Override
        public byte[] toBytes(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from BYTE to BYTES");
        }
    }
    ,
    CHARACTER{

        @Override
        public int toInt(Object value) {
            return ((Character)value).charValue();
        }

        @Override
        public long toLong(Object value) {
            return ((Character)value).charValue();
        }

        @Override
        public float toFloat(Object value) {
            return ((Character)value).charValue();
        }

        @Override
        public double toDouble(Object value) {
            return ((Character)value).charValue();
        }

        @Override
        public boolean toBoolean(Object value) {
            return ((Character)value).charValue() != '\u0000';
        }

        @Override
        public Timestamp toTimestamp(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from CHARACTER to TIMESTAMP");
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }

        @Override
        public byte[] toBytes(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from CHARACTER to BYTES");
        }
    }
    ,
    SHORT{

        @Override
        public int toInt(Object value) {
            return ((Short)value).intValue();
        }

        @Override
        public long toLong(Object value) {
            return ((Short)value).longValue();
        }

        @Override
        public float toFloat(Object value) {
            return ((Short)value).floatValue();
        }

        @Override
        public double toDouble(Object value) {
            return ((Short)value).doubleValue();
        }

        @Override
        public boolean toBoolean(Object value) {
            return (Short)value != 0;
        }

        @Override
        public Timestamp toTimestamp(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from SHORT to TIMESTAMP");
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }

        @Override
        public byte[] toBytes(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from SHORT to BYTES");
        }
    }
    ,
    INTEGER{

        @Override
        public int toInt(Object value) {
            return (Integer)value;
        }

        @Override
        public long toLong(Object value) {
            return ((Integer)value).longValue();
        }

        @Override
        public float toFloat(Object value) {
            return ((Integer)value).floatValue();
        }

        @Override
        public double toDouble(Object value) {
            return ((Integer)value).doubleValue();
        }

        @Override
        public boolean toBoolean(Object value) {
            return (Integer)value != 0;
        }

        @Override
        public Timestamp toTimestamp(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from INTEGER to TIMESTAMP");
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }

        @Override
        public byte[] toBytes(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from INTEGER to BYTES");
        }

        @Override
        public Integer convert(Object value, PinotDataType sourceType) {
            return sourceType.toInt(value);
        }
    }
    ,
    LONG{

        @Override
        public int toInt(Object value) {
            return ((Long)value).intValue();
        }

        @Override
        public long toLong(Object value) {
            return (Long)value;
        }

        @Override
        public float toFloat(Object value) {
            return ((Long)value).floatValue();
        }

        @Override
        public double toDouble(Object value) {
            return ((Long)value).doubleValue();
        }

        @Override
        public boolean toBoolean(Object value) {
            return (Long)value != 0L;
        }

        @Override
        public Timestamp toTimestamp(Object value) {
            return new Timestamp((Long)value);
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }

        @Override
        public byte[] toBytes(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from LONG to BYTES");
        }

        @Override
        public Long convert(Object value, PinotDataType sourceType) {
            return sourceType.toLong(value);
        }
    }
    ,
    FLOAT{

        @Override
        public int toInt(Object value) {
            return ((Float)value).intValue();
        }

        @Override
        public long toLong(Object value) {
            return ((Float)value).longValue();
        }

        @Override
        public float toFloat(Object value) {
            return ((Float)value).floatValue();
        }

        @Override
        public double toDouble(Object value) {
            return ((Float)value).doubleValue();
        }

        @Override
        public boolean toBoolean(Object value) {
            return ((Float)value).floatValue() != 0.0f;
        }

        @Override
        public Timestamp toTimestamp(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from FLOAT to TIMESTAMP");
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }

        @Override
        public byte[] toBytes(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from FLOAT to BYTES");
        }

        @Override
        public Float convert(Object value, PinotDataType sourceType) {
            return Float.valueOf(sourceType.toFloat(value));
        }
    }
    ,
    DOUBLE{

        @Override
        public int toInt(Object value) {
            return ((Double)value).intValue();
        }

        @Override
        public long toLong(Object value) {
            return ((Double)value).longValue();
        }

        @Override
        public float toFloat(Object value) {
            return ((Double)value).floatValue();
        }

        @Override
        public double toDouble(Object value) {
            return (Double)value;
        }

        @Override
        public boolean toBoolean(Object value) {
            return (Double)value != 0.0;
        }

        @Override
        public Timestamp toTimestamp(Object value) {
            return new Timestamp(((Double)value).longValue());
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }

        @Override
        public byte[] toBytes(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from DOUBLE to BYTES");
        }

        @Override
        public Double convert(Object value, PinotDataType sourceType) {
            return sourceType.toDouble(value);
        }
    }
    ,
    TIMESTAMP{

        @Override
        public int toInt(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from TIMESTAMP to INTEGER");
        }

        @Override
        public long toLong(Object value) {
            return ((Timestamp)value).getTime();
        }

        @Override
        public float toFloat(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from TIMESTAMP to FLOAT");
        }

        @Override
        public double toDouble(Object value) {
            return ((Timestamp)value).getTime();
        }

        @Override
        public boolean toBoolean(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from TIMESTAMP to BOOLEAN");
        }

        @Override
        public Timestamp toTimestamp(Object value) {
            return (Timestamp)value;
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }

        @Override
        public byte[] toBytes(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from TIMESTAMP to BYTES");
        }

        @Override
        public Timestamp convert(Object value, PinotDataType sourceType) {
            return sourceType.toTimestamp(value);
        }

        @Override
        public Long toInternal(Object value) {
            return ((Timestamp)value).getTime();
        }
    }
    ,
    STRING{

        @Override
        public int toInt(Object value) {
            return Integer.parseInt(value.toString().trim());
        }

        @Override
        public long toLong(Object value) {
            return Long.parseLong(value.toString().trim());
        }

        @Override
        public float toFloat(Object value) {
            return Float.parseFloat(value.toString());
        }

        @Override
        public double toDouble(Object value) {
            return Double.parseDouble(value.toString());
        }

        @Override
        public boolean toBoolean(Object value) {
            return BooleanUtils.toBoolean((String)value.toString().trim());
        }

        @Override
        public Timestamp toTimestamp(Object value) {
            return TimestampUtils.toTimestamp((String)value.toString().trim());
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }

        @Override
        public byte[] toBytes(Object value) {
            return BytesUtils.toBytes((String)value.toString().trim());
        }

        @Override
        public String convert(Object value, PinotDataType sourceType) {
            return sourceType.toString(value);
        }
    }
    ,
    JSON{

        @Override
        public int toInt(Object value) {
            return Integer.parseInt(value.toString().trim());
        }

        @Override
        public long toLong(Object value) {
            return Long.parseLong(value.toString().trim());
        }

        @Override
        public float toFloat(Object value) {
            return Float.parseFloat(value.toString());
        }

        @Override
        public double toDouble(Object value) {
            return Double.parseDouble(value.toString());
        }

        @Override
        public boolean toBoolean(Object value) {
            return Boolean.parseBoolean(value.toString().trim());
        }

        @Override
        public Timestamp toTimestamp(Object value) {
            return TimestampUtils.toTimestamp((String)value.toString().trim());
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }

        @Override
        public byte[] toBytes(Object value) {
            try {
                return Base64.getDecoder().decode(value.toString());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to convert JSON base64 encoded string value to BYTES. Input value: " + value, e);
            }
        }

        @Override
        public String convert(Object value, PinotDataType sourceType) {
            return sourceType.toJson(value);
        }
    }
    ,
    BYTES{

        @Override
        public int toInt(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from BYTES to INTEGER");
        }

        @Override
        public long toLong(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from BYTES to LONG");
        }

        @Override
        public float toFloat(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from BYTES to FLOAT");
        }

        @Override
        public double toDouble(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from BYTES to DOUBLE");
        }

        @Override
        public boolean toBoolean(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from BYTES to BOOLEAN");
        }

        @Override
        public Timestamp toTimestamp(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from BYTES to TIMESTAMP");
        }

        @Override
        public String toString(Object value) {
            return BytesUtils.toHexString((byte[])((byte[])value));
        }

        @Override
        public byte[] toBytes(Object value) {
            return (byte[])value;
        }

        @Override
        public Object convert(Object value, PinotDataType sourceType) {
            return sourceType.toBytes(value);
        }
    }
    ,
    OBJECT{

        @Override
        public int toInt(Object value) {
            return ((Number)value).intValue();
        }

        @Override
        public long toLong(Object value) {
            return ((Number)value).longValue();
        }

        @Override
        public float toFloat(Object value) {
            return ((Number)value).floatValue();
        }

        @Override
        public double toDouble(Object value) {
            return ((Number)value).doubleValue();
        }

        @Override
        public boolean toBoolean(Object value) {
            return ((Number)value).intValue() > 0;
        }

        @Override
        public Timestamp toTimestamp(Object value) {
            return new Timestamp(((Number)value).longValue());
        }

        @Override
        public String toString(Object value) {
            return value.toString();
        }

        @Override
        public byte[] toBytes(Object value) {
            throw new UnsupportedOperationException("Cannot convert value from OBJECT to BYTES");
        }
    }
    ,
    BYTE_ARRAY{

        @Override
        public byte[] toBytes(Object value) {
            Object[] valueArray = (Object[])value;
            int length = valueArray.length;
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                bytes[i] = (Byte)valueArray[i];
            }
            return bytes;
        }
    }
    ,
    CHARACTER_ARRAY,
    SHORT_ARRAY,
    PRIMITIVE_INT_ARRAY{

        public int[] convert(Object value, PinotDataType sourceType) {
            return sourceType.toPrimitiveIntArray(value);
        }
    }
    ,
    INTEGER_ARRAY{

        public Integer[] convert(Object value, PinotDataType sourceType) {
            return sourceType.toIntegerArray(value);
        }
    }
    ,
    PRIMITIVE_LONG_ARRAY{

        public long[] convert(Object value, PinotDataType sourceType) {
            return sourceType.toPrimitiveLongArray(value);
        }
    }
    ,
    LONG_ARRAY{

        public Long[] convert(Object value, PinotDataType sourceType) {
            return sourceType.toLongArray(value);
        }
    }
    ,
    PRIMITIVE_FLOAT_ARRAY{

        public float[] convert(Object value, PinotDataType sourceType) {
            return sourceType.toPrimitiveFloatArray(value);
        }
    }
    ,
    FLOAT_ARRAY{

        public Float[] convert(Object value, PinotDataType sourceType) {
            return sourceType.toFloatArray(value);
        }
    }
    ,
    PRIMITIVE_DOUBLE_ARRAY{

        public double[] convert(Object value, PinotDataType sourceType) {
            return sourceType.toPrimitiveDoubleArray(value);
        }
    }
    ,
    DOUBLE_ARRAY{

        public Double[] convert(Object value, PinotDataType sourceType) {
            return sourceType.toDoubleArray(value);
        }
    }
    ,
    STRING_ARRAY{

        public String[] convert(Object value, PinotDataType sourceType) {
            return sourceType.toStringArray(value);
        }
    }
    ,
    OBJECT_ARRAY;


    public int toInt(Object value) {
        return this.getSingleValueType().toInt(PinotDataType.toObjectArray(value)[0]);
    }

    public long toLong(Object value) {
        return this.getSingleValueType().toLong(PinotDataType.toObjectArray(value)[0]);
    }

    public float toFloat(Object value) {
        return this.getSingleValueType().toFloat(PinotDataType.toObjectArray(value)[0]);
    }

    public double toDouble(Object value) {
        return this.getSingleValueType().toDouble(PinotDataType.toObjectArray(value)[0]);
    }

    public boolean toBoolean(Object value) {
        return this.getSingleValueType().toBoolean(((Object[])value)[0]);
    }

    public Timestamp toTimestamp(Object value) {
        return this.getSingleValueType().toTimestamp(((Object[])value)[0]);
    }

    public String toString(Object value) {
        return this.getSingleValueType().toString(PinotDataType.toObjectArray(value)[0]);
    }

    public String toJson(Object value) {
        if (value instanceof String) {
            try {
                return JsonUtils.stringToJsonNode((String)((String)value)).toString();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to convert String into JSON. Input value: " + value, e);
            }
        }
        try {
            return JsonUtils.objectToString((Object)value).toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to convert " + value.getClass().getCanonicalName() + " to JSON. Input value: " + value, e);
        }
    }

    public byte[] toBytes(Object value) {
        return this.getSingleValueType().toBytes(PinotDataType.toObjectArray(value)[0]);
    }

    public int[] toPrimitiveIntArray(Object value) {
        if (value instanceof int[]) {
            return (int[])value;
        }
        if (this.isSingleValue()) {
            return new int[]{this.toInt(value)};
        }
        Object[] valueArray = PinotDataType.toObjectArray(value);
        int length = valueArray.length;
        int[] intArray = new int[length];
        PinotDataType singleValueType = this.getSingleValueType();
        for (int i = 0; i < length; ++i) {
            intArray[i] = singleValueType.toInt(valueArray[i]);
        }
        return intArray;
    }

    public Integer[] toIntegerArray(Object value) {
        if (value instanceof Integer[]) {
            return (Integer[])value;
        }
        if (this.isSingleValue()) {
            return new Integer[]{this.toInt(value)};
        }
        Object[] valueArray = PinotDataType.toObjectArray(value);
        int length = valueArray.length;
        Integer[] integerArray = new Integer[length];
        PinotDataType singleValueType = this.getSingleValueType();
        for (int i = 0; i < length; ++i) {
            integerArray[i] = singleValueType.toInt(valueArray[i]);
        }
        return integerArray;
    }

    public long[] toPrimitiveLongArray(Object value) {
        if (value instanceof long[]) {
            return (long[])value;
        }
        if (this.isSingleValue()) {
            return new long[]{this.toLong(value)};
        }
        Object[] valueArray = PinotDataType.toObjectArray(value);
        int length = valueArray.length;
        long[] longArray = new long[length];
        PinotDataType singleValueType = this.getSingleValueType();
        for (int i = 0; i < length; ++i) {
            longArray[i] = singleValueType.toLong(valueArray[i]);
        }
        return longArray;
    }

    public Long[] toLongArray(Object value) {
        if (value instanceof Long[]) {
            return (Long[])value;
        }
        if (this.isSingleValue()) {
            return new Long[]{this.toLong(value)};
        }
        Object[] valueArray = PinotDataType.toObjectArray(value);
        int length = valueArray.length;
        Long[] longArray = new Long[length];
        PinotDataType singleValueType = this.getSingleValueType();
        for (int i = 0; i < length; ++i) {
            longArray[i] = singleValueType.toLong(valueArray[i]);
        }
        return longArray;
    }

    public float[] toPrimitiveFloatArray(Object value) {
        if (value instanceof float[]) {
            return (float[])value;
        }
        if (this.isSingleValue()) {
            return new float[]{this.toFloat(value)};
        }
        Object[] valueArray = PinotDataType.toObjectArray(value);
        int length = valueArray.length;
        float[] floatArray = new float[length];
        PinotDataType singleValueType = this.getSingleValueType();
        for (int i = 0; i < length; ++i) {
            floatArray[i] = singleValueType.toFloat(valueArray[i]);
        }
        return floatArray;
    }

    public Float[] toFloatArray(Object value) {
        if (value instanceof Float[]) {
            return (Float[])value;
        }
        if (this.isSingleValue()) {
            return new Float[]{Float.valueOf(this.toFloat(value))};
        }
        Object[] valueArray = PinotDataType.toObjectArray(value);
        int length = valueArray.length;
        Float[] floatArray = new Float[length];
        PinotDataType singleValueType = this.getSingleValueType();
        for (int i = 0; i < length; ++i) {
            floatArray[i] = Float.valueOf(singleValueType.toFloat(valueArray[i]));
        }
        return floatArray;
    }

    public double[] toPrimitiveDoubleArray(Object value) {
        if (value instanceof double[]) {
            return (double[])value;
        }
        if (this.isSingleValue()) {
            return new double[]{this.toDouble(value)};
        }
        Object[] valueArray = PinotDataType.toObjectArray(value);
        int length = valueArray.length;
        double[] doubleArray = new double[length];
        PinotDataType singleValueType = this.getSingleValueType();
        for (int i = 0; i < length; ++i) {
            doubleArray[i] = singleValueType.toDouble(valueArray[i]);
        }
        return doubleArray;
    }

    public Double[] toDoubleArray(Object value) {
        if (value instanceof Double[]) {
            return (Double[])value;
        }
        if (this.isSingleValue()) {
            return new Double[]{this.toDouble(value)};
        }
        Object[] valueArray = PinotDataType.toObjectArray(value);
        int length = valueArray.length;
        Double[] doubleArray = new Double[length];
        PinotDataType singleValueType = this.getSingleValueType();
        for (int i = 0; i < length; ++i) {
            doubleArray[i] = singleValueType.toDouble(valueArray[i]);
        }
        return doubleArray;
    }

    public String[] toStringArray(Object value) {
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (this.isSingleValue()) {
            return new String[]{this.toString(value)};
        }
        Object[] valueArray = PinotDataType.toObjectArray(value);
        int length = valueArray.length;
        String[] stringArray = new String[length];
        PinotDataType singleValueType = this.getSingleValueType();
        for (int i = 0; i < length; ++i) {
            stringArray[i] = singleValueType.toString(valueArray[i]);
        }
        return stringArray;
    }

    private static Object[] toObjectArray(Object array) {
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            if (componentType == Integer.TYPE) {
                return ArrayUtils.toObject((int[])((int[])array));
            }
            if (componentType == Long.TYPE) {
                return ArrayUtils.toObject((long[])((long[])array));
            }
            if (componentType == Float.TYPE) {
                return ArrayUtils.toObject((float[])((float[])array));
            }
            if (componentType == Double.TYPE) {
                return ArrayUtils.toObject((double[])((double[])array));
            }
            throw new UnsupportedOperationException("Unsupported primitive array type: " + componentType);
        }
        return (Object[])array;
    }

    public Object convert(Object value, PinotDataType sourceType) {
        throw new UnsupportedOperationException("Cannot convert value from " + sourceType + " to " + this);
    }

    public Object toInternal(Object value) {
        return value;
    }

    public boolean isSingleValue() {
        return this.ordinal() <= OBJECT.ordinal();
    }

    public PinotDataType getSingleValueType() {
        switch (this) {
            case BYTE_ARRAY: {
                return BYTE;
            }
            case CHARACTER_ARRAY: {
                return CHARACTER;
            }
            case SHORT_ARRAY: {
                return SHORT;
            }
            case PRIMITIVE_INT_ARRAY: 
            case INTEGER_ARRAY: {
                return INTEGER;
            }
            case PRIMITIVE_LONG_ARRAY: 
            case LONG_ARRAY: {
                return LONG;
            }
            case PRIMITIVE_FLOAT_ARRAY: 
            case FLOAT_ARRAY: {
                return FLOAT;
            }
            case PRIMITIVE_DOUBLE_ARRAY: 
            case DOUBLE_ARRAY: {
                return DOUBLE;
            }
            case STRING_ARRAY: {
                return STRING;
            }
            case OBJECT_ARRAY: {
                return OBJECT;
            }
        }
        throw new IllegalStateException("There is no single-value type for " + this);
    }

    public static PinotDataType getPinotDataTypeForIngestion(FieldSpec fieldSpec) {
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        switch (dataType) {
            case INT: {
                return fieldSpec.isSingleValueField() ? INTEGER : INTEGER_ARRAY;
            }
            case LONG: {
                return fieldSpec.isSingleValueField() ? LONG : LONG_ARRAY;
            }
            case FLOAT: {
                return fieldSpec.isSingleValueField() ? FLOAT : FLOAT_ARRAY;
            }
            case DOUBLE: {
                return fieldSpec.isSingleValueField() ? DOUBLE : DOUBLE_ARRAY;
            }
            case BOOLEAN: {
                if (fieldSpec.isSingleValueField()) {
                    return BOOLEAN;
                }
                throw new IllegalStateException("There is no multi-value type for BOOLEAN");
            }
            case TIMESTAMP: {
                if (fieldSpec.isSingleValueField()) {
                    return TIMESTAMP;
                }
                throw new IllegalStateException("There is no multi-value type for TIMESTAMP");
            }
            case JSON: {
                if (fieldSpec.isSingleValueField()) {
                    return JSON;
                }
                throw new IllegalStateException("There is no multi-value type for JSON");
            }
            case STRING: {
                return fieldSpec.isSingleValueField() ? STRING : STRING_ARRAY;
            }
            case BYTES: {
                if (fieldSpec.isSingleValueField()) {
                    return BYTES;
                }
                throw new IllegalStateException("There is no multi-value type for BYTES");
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + dataType + " in field: " + fieldSpec.getName());
    }

    public static PinotDataType getPinotDataTypeForExecution(DataSchema.ColumnDataType columnDataType) {
        switch (columnDataType) {
            case INT: {
                return INTEGER;
            }
            case LONG: {
                return LONG;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case TIMESTAMP: {
                return TIMESTAMP;
            }
            case STRING: {
                return STRING;
            }
            case JSON: {
                return JSON;
            }
            case BYTES: {
                return BYTES;
            }
            case INT_ARRAY: {
                return PRIMITIVE_INT_ARRAY;
            }
            case LONG_ARRAY: {
                return PRIMITIVE_LONG_ARRAY;
            }
            case FLOAT_ARRAY: {
                return PRIMITIVE_FLOAT_ARRAY;
            }
            case DOUBLE_ARRAY: {
                return PRIMITIVE_DOUBLE_ARRAY;
            }
            case STRING_ARRAY: {
                return STRING_ARRAY;
            }
        }
        throw new IllegalStateException("Cannot convert ColumnDataType: " + columnDataType + " to PinotDataType");
    }
}

