/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.StringUtils;

public class StringUtil {
    private static final char NULL_CHARACTER = '\u0000';
    private static final String charSet = "UTF-8";

    public static String join(String separator, String ... keys) {
        return StringUtils.join((Object[])keys, (String)separator);
    }

    public static String sanitizeStringValue(String value, int maxLength) {
        char[] chars = value.toCharArray();
        int length = chars.length;
        int limit = Math.min(length, maxLength);
        for (int i = 0; i < limit; ++i) {
            if (chars[i] != '\u0000') continue;
            return new String(chars, 0, i);
        }
        if (limit < length) {
            return new String(chars, 0, limit);
        }
        return value;
    }

    public static byte[] encodeUtf8(String s) {
        try {
            return s.getBytes(charSet);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodeUtf8(byte[] bytes) {
        return StringUtil.decodeUtf8(bytes, 0, bytes.length);
    }

    public static String decodeUtf8(byte[] bytes, int startIndex, int length) {
        try {
            return new String(bytes, startIndex, length, charSet);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

