/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.ZkClient;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.spi.utils.NetUtils;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.admin.AdminServer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkStarter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZkStarter.class);
    public static final int DEFAULT_ZK_TEST_PORT = 2191;
    private static final int DEFAULT_ZK_CLIENT_RETRIES = 10;

    public static ZookeeperInstance startLocalZkServer() {
        return ZkStarter.startLocalZkServer(NetUtils.findOpenPort((int)2191));
    }

    public static String getDefaultZkStr() {
        return "localhost:2191";
    }

    public static ZookeeperInstance startLocalZkServer(int port) {
        return ZkStarter.startLocalZkServer(port, FileUtils.getTempDirectoryPath() + File.separator + "test-" + System.currentTimeMillis());
    }

    public static synchronized ZookeeperInstance startLocalZkServer(int port, String dataDirPath) {
        try {
            final PublicZooKeeperServerMain zookeeperServerMain = new PublicZooKeeperServerMain();
            final String[] args = new String[]{Integer.toString(port), dataDirPath};
            new Thread(){

                @Override
                public void run() {
                    try {
                        zookeeperServerMain.initializeAndRun(args);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Caught exception while starting ZK", (Throwable)e);
                    }
                }
            }.start();
            for (int retry = 0; retry < 10; ++retry) {
                try {
                    Thread.sleep(1000L);
                    ZkClient client = new ZkClient("localhost:" + port, 1000 * (10 - retry));
                    client.waitUntilConnected((long)(10 - retry), TimeUnit.SECONDS);
                    client.close();
                    break;
                }
                catch (Exception e) {
                    if (retry >= 9) {
                        LOGGER.warn("Failed to connect to zk server.", (Throwable)e);
                        throw e;
                    }
                    LOGGER.warn("Failed to connect to zk server, retry: {}", (Object)retry, (Object)e);
                    continue;
                }
            }
            return new ZookeeperInstance(zookeeperServerMain, dataDirPath, port);
        }
        catch (Exception e) {
            LOGGER.warn("Caught exception while starting ZK", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void stopLocalZkServer(ZookeeperInstance instance) {
        ZkStarter.stopLocalZkServer(instance, true);
    }

    public static synchronized void stopLocalZkServer(ZookeeperInstance instance, boolean deleteDataDir) {
        if (instance._serverMain != null) {
            try {
                instance._serverMain.shutdown();
                instance._serverMain = null;
                if (deleteDataDir) {
                    FileUtils.deleteDirectory((File)new File(instance._dataDirPath));
                }
            }
            catch (Exception e) {
                LOGGER.warn("Caught exception while stopping ZK server", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    static class PublicZooKeeperServerMain
    extends ZooKeeperServerMain {
        PublicZooKeeperServerMain() {
        }

        public void initializeAndRun(String[] args) throws QuorumPeerConfig.ConfigException, IOException, AdminServer.AdminServerException {
            System.setProperty("zookeeper.jmx.log4j.disable", "true");
            System.setProperty("zookeeper.admin.enableServer", "false");
            super.initializeAndRun(args);
        }

        public void runFromConfig(final ServerConfig config) throws IOException, AdminServer.AdminServerException {
            ServerConfig newServerConfig = new ServerConfig(){

                public void parse(String[] args) {
                    config.parse(args);
                }

                public void parse(String path) throws QuorumPeerConfig.ConfigException {
                    config.parse(path);
                }

                public void readFrom(QuorumPeerConfig otherConfig) {
                    config.readFrom(otherConfig);
                }

                public InetSocketAddress getClientPortAddress() {
                    return config.getClientPortAddress();
                }

                public File getDataDir() {
                    return config.getDataDir();
                }

                public File getDataLogDir() {
                    return config.getDataLogDir();
                }

                public int getTickTime() {
                    return config.getTickTime();
                }

                public int getMaxClientCnxns() {
                    this.dataDir = this.getDataDir();
                    this.dataLogDir = this.getDataLogDir();
                    this.tickTime = this.getTickTime();
                    this.minSessionTimeout = this.getMinSessionTimeout();
                    this.maxSessionTimeout = this.getMaxSessionTimeout();
                    this.maxClientCnxns = 0;
                    return 0;
                }

                public int getMinSessionTimeout() {
                    return config.getMinSessionTimeout();
                }

                public int getMaxSessionTimeout() {
                    return config.getMaxSessionTimeout();
                }
            };
            newServerConfig.getMaxClientCnxns();
            super.runFromConfig(newServerConfig);
        }

        public void shutdown() {
            super.shutdown();
        }
    }

    public static class ZookeeperInstance {
        private PublicZooKeeperServerMain _serverMain;
        private String _dataDirPath;
        private int _port;

        private ZookeeperInstance(PublicZooKeeperServerMain serverMain, String dataDirPath, int port) {
            this._serverMain = serverMain;
            this._dataDirPath = dataDirPath;
            this._port = port;
        }

        public String getZkUrl() {
            return "localhost:" + this._port;
        }
    }
}

