/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.ZNRecord;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.QueryConfig;
import org.apache.pinot.spi.config.table.QuotaConfig;
import org.apache.pinot.spi.config.table.RoutingConfig;
import org.apache.pinot.spi.config.table.SegmentsValidationAndRetentionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableCustomConfig;
import org.apache.pinot.spi.config.table.TableTaskConfig;
import org.apache.pinot.spi.config.table.TenantConfig;
import org.apache.pinot.spi.config.table.TierConfig;
import org.apache.pinot.spi.config.table.TunerConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.config.table.assignment.InstanceAssignmentConfig;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;
import org.apache.pinot.spi.config.table.ingestion.BatchIngestionConfig;
import org.apache.pinot.spi.config.table.ingestion.IngestionConfig;
import org.apache.pinot.spi.config.table.ingestion.StreamIngestionConfig;
import org.apache.pinot.spi.utils.JsonUtils;

public class TableConfigUtils {
    private static final String FIELD_MISSING_MESSAGE_TEMPLATE = "Mandatory field '%s' is missing";

    private TableConfigUtils() {
    }

    public static TableConfig fromZNRecord(ZNRecord znRecord) throws IOException {
        Map simpleFields = znRecord.getSimpleFields();
        String tableName = znRecord.getId();
        String tableType = (String)simpleFields.get("tableType");
        boolean isDimTable = Boolean.parseBoolean((String)simpleFields.get("isDimTable"));
        Preconditions.checkState((tableType != null ? 1 : 0) != 0, (String)FIELD_MISSING_MESSAGE_TEMPLATE, (Object)"tableType");
        String validationConfigString = (String)simpleFields.get("segmentsConfig");
        Preconditions.checkState((validationConfigString != null ? 1 : 0) != 0, (String)FIELD_MISSING_MESSAGE_TEMPLATE, (Object)"segmentsConfig");
        SegmentsValidationAndRetentionConfig validationConfig = (SegmentsValidationAndRetentionConfig)JsonUtils.stringToObject((String)validationConfigString, SegmentsValidationAndRetentionConfig.class);
        String tenantConfigString = (String)simpleFields.get("tenants");
        Preconditions.checkState((tenantConfigString != null ? 1 : 0) != 0, (String)FIELD_MISSING_MESSAGE_TEMPLATE, (Object)"tenants");
        TenantConfig tenantConfig = (TenantConfig)JsonUtils.stringToObject((String)tenantConfigString, TenantConfig.class);
        String indexingConfigString = (String)simpleFields.get("tableIndexConfig");
        Preconditions.checkState((indexingConfigString != null ? 1 : 0) != 0, (String)FIELD_MISSING_MESSAGE_TEMPLATE, (Object)"tableIndexConfig");
        IndexingConfig indexingConfig = (IndexingConfig)JsonUtils.stringToObject((String)indexingConfigString, IndexingConfig.class);
        String customConfigString = (String)simpleFields.get("metadata");
        Preconditions.checkState((customConfigString != null ? 1 : 0) != 0, (String)FIELD_MISSING_MESSAGE_TEMPLATE, (Object)"metadata");
        TableCustomConfig customConfig = (TableCustomConfig)JsonUtils.stringToObject((String)customConfigString, TableCustomConfig.class);
        QuotaConfig quotaConfig = null;
        String quotaConfigString = (String)simpleFields.get("quota");
        if (quotaConfigString != null) {
            quotaConfig = (QuotaConfig)JsonUtils.stringToObject((String)quotaConfigString, QuotaConfig.class);
        }
        TableTaskConfig taskConfig = null;
        String taskConfigString = (String)simpleFields.get("task");
        if (taskConfigString != null) {
            taskConfig = (TableTaskConfig)JsonUtils.stringToObject((String)taskConfigString, TableTaskConfig.class);
        }
        RoutingConfig routingConfig = null;
        String routingConfigString = (String)simpleFields.get("routing");
        if (routingConfigString != null) {
            routingConfig = (RoutingConfig)JsonUtils.stringToObject((String)routingConfigString, RoutingConfig.class);
        }
        QueryConfig queryConfig = null;
        String queryConfigString = (String)simpleFields.get("query");
        if (queryConfigString != null) {
            queryConfig = (QueryConfig)JsonUtils.stringToObject((String)queryConfigString, QueryConfig.class);
        }
        Map instanceAssignmentConfigMap = null;
        String instanceAssignmentConfigMapString = (String)simpleFields.get("instanceAssignmentConfigMap");
        if (instanceAssignmentConfigMapString != null) {
            instanceAssignmentConfigMap = (Map)JsonUtils.stringToObject((String)instanceAssignmentConfigMapString, (TypeReference)new TypeReference<Map<InstancePartitionsType, InstanceAssignmentConfig>>(){});
        }
        List fieldConfigList = null;
        String fieldConfigListString = (String)simpleFields.get("fieldConfigList");
        if (fieldConfigListString != null) {
            fieldConfigList = (List)JsonUtils.stringToObject((String)fieldConfigListString, (TypeReference)new TypeReference<List<FieldConfig>>(){});
        }
        UpsertConfig upsertConfig = null;
        String upsertConfigString = (String)simpleFields.get("upsertConfig");
        if (upsertConfigString != null) {
            upsertConfig = (UpsertConfig)JsonUtils.stringToObject((String)upsertConfigString, UpsertConfig.class);
        }
        IngestionConfig ingestionConfig = null;
        String ingestionConfigString = (String)simpleFields.get("ingestionConfig");
        if (ingestionConfigString != null) {
            ingestionConfig = (IngestionConfig)JsonUtils.stringToObject((String)ingestionConfigString, IngestionConfig.class);
        }
        List tierConfigList = null;
        String tierConfigListString = (String)simpleFields.get("tierConfigs");
        if (tierConfigListString != null) {
            tierConfigList = (List)JsonUtils.stringToObject((String)tierConfigListString, (TypeReference)new TypeReference<List<TierConfig>>(){});
        }
        TunerConfig tunerConfig = null;
        String tunerConfigString = (String)simpleFields.get("tunerConfig");
        if (tunerConfigString != null) {
            tunerConfig = (TunerConfig)JsonUtils.stringToObject((String)tunerConfigString, TunerConfig.class);
        }
        return new TableConfig(tableName, tableType, validationConfig, tenantConfig, indexingConfig, customConfig, quotaConfig, taskConfig, routingConfig, queryConfig, instanceAssignmentConfigMap, fieldConfigList, upsertConfig, ingestionConfig, tierConfigList, isDimTable, tunerConfig);
    }

    public static ZNRecord toZNRecord(TableConfig tableConfig) throws JsonProcessingException {
        TunerConfig tunerConfig;
        List tierConfigList;
        IngestionConfig ingestionConfig;
        UpsertConfig upsertConfig;
        List fieldConfigList;
        Map instanceAssignmentConfigMap;
        QueryConfig queryConfig;
        RoutingConfig routingConfig;
        TableTaskConfig taskConfig;
        HashMap<String, String> simpleFields = new HashMap<String, String>();
        simpleFields.put("tableName", tableConfig.getTableName());
        simpleFields.put("tableType", tableConfig.getTableType().toString());
        simpleFields.put("segmentsConfig", tableConfig.getValidationConfig().toJsonString());
        simpleFields.put("tenants", tableConfig.getTenantConfig().toJsonString());
        simpleFields.put("tableIndexConfig", tableConfig.getIndexingConfig().toJsonString());
        simpleFields.put("metadata", tableConfig.getCustomConfig().toJsonString());
        simpleFields.put("isDimTable", Boolean.toString(tableConfig.isDimTable()));
        QuotaConfig quotaConfig = tableConfig.getQuotaConfig();
        if (quotaConfig != null) {
            simpleFields.put("quota", quotaConfig.toJsonString());
        }
        if ((taskConfig = tableConfig.getTaskConfig()) != null) {
            simpleFields.put("task", taskConfig.toJsonString());
        }
        if ((routingConfig = tableConfig.getRoutingConfig()) != null) {
            simpleFields.put("routing", routingConfig.toJsonString());
        }
        if ((queryConfig = tableConfig.getQueryConfig()) != null) {
            simpleFields.put("query", queryConfig.toJsonString());
        }
        if ((instanceAssignmentConfigMap = tableConfig.getInstanceAssignmentConfigMap()) != null) {
            simpleFields.put("instanceAssignmentConfigMap", JsonUtils.objectToString((Object)instanceAssignmentConfigMap));
        }
        if ((fieldConfigList = tableConfig.getFieldConfigList()) != null) {
            simpleFields.put("fieldConfigList", JsonUtils.objectToString((Object)fieldConfigList));
        }
        if ((upsertConfig = tableConfig.getUpsertConfig()) != null) {
            simpleFields.put("upsertConfig", JsonUtils.objectToString((Object)upsertConfig));
        }
        if ((ingestionConfig = tableConfig.getIngestionConfig()) != null) {
            simpleFields.put("ingestionConfig", JsonUtils.objectToString((Object)ingestionConfig));
        }
        if ((tierConfigList = tableConfig.getTierConfigsList()) != null) {
            simpleFields.put("tierConfigs", JsonUtils.objectToString((Object)tierConfigList));
        }
        if ((tunerConfig = tableConfig.getTunerConfig()) != null) {
            simpleFields.put("tunerConfig", JsonUtils.objectToString((Object)tunerConfig));
        }
        ZNRecord znRecord = new ZNRecord(tableConfig.getTableName());
        znRecord.setSimpleFields(simpleFields);
        return znRecord;
    }

    public static void convertFromLegacyTableConfig(TableConfig tableConfig) {
        Map streamConfigs;
        IngestionConfig ingestionConfig = tableConfig.getIngestionConfig();
        BatchIngestionConfig batchIngestionConfig = ingestionConfig != null ? ingestionConfig.getBatchIngestionConfig() : null;
        SegmentsValidationAndRetentionConfig validationConfig = tableConfig.getValidationConfig();
        String segmentPushType = validationConfig.getSegmentPushType();
        String segmentPushFrequency = validationConfig.getSegmentPushFrequency();
        if (batchIngestionConfig == null) {
            if (segmentPushType != null || segmentPushFrequency != null) {
                batchIngestionConfig = new BatchIngestionConfig(null, segmentPushType, segmentPushFrequency);
            }
        } else {
            if (batchIngestionConfig.getSegmentIngestionType() == null) {
                batchIngestionConfig.setSegmentIngestionType(segmentPushType);
            }
            if (batchIngestionConfig.getSegmentIngestionFrequency() == null) {
                batchIngestionConfig.setSegmentIngestionFrequency(segmentPushFrequency);
            }
        }
        StreamIngestionConfig streamIngestionConfig = ingestionConfig != null ? ingestionConfig.getStreamIngestionConfig() : null;
        IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
        if (streamIngestionConfig == null && (streamConfigs = indexingConfig.getStreamConfigs()) != null && !streamConfigs.isEmpty()) {
            streamIngestionConfig = new StreamIngestionConfig(Collections.singletonList(streamConfigs));
        }
        if (ingestionConfig == null) {
            if (batchIngestionConfig != null || streamIngestionConfig != null) {
                ingestionConfig = new IngestionConfig(batchIngestionConfig, streamIngestionConfig, null, null, null);
            }
        } else {
            if (batchIngestionConfig != null) {
                ingestionConfig.setBatchIngestionConfig(batchIngestionConfig);
            }
            if (streamIngestionConfig != null) {
                ingestionConfig.setStreamIngestionConfig(streamIngestionConfig);
            }
        }
        if (ingestionConfig != null) {
            tableConfig.setIngestionConfig(ingestionConfig);
        }
        indexingConfig.setStreamConfigs(null);
        validationConfig.setSegmentPushFrequency(null);
        validationConfig.setSegmentPushType(null);
    }
}

