/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.config;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.tier.Tier;
import org.apache.pinot.common.tier.TierFactory;
import org.apache.pinot.common.tier.TierSegmentSelector;
import org.apache.pinot.common.tier.TimeBasedTierSegmentSelector;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TierConfig;

public final class TierConfigUtils {
    private TierConfigUtils() {
    }

    public static boolean shouldRelocateToTiers(TableConfig tableConfig) {
        return CollectionUtils.isNotEmpty((Collection)tableConfig.getTierConfigsList());
    }

    public static List<Tier> getSortedTiersForStorageType(List<TierConfig> tierConfigList, String storageType, HelixManager helixManager) {
        ArrayList<Tier> sortedTiers = new ArrayList<Tier>();
        for (TierConfig tierConfig : tierConfigList) {
            if (!storageType.equalsIgnoreCase(tierConfig.getStorageType())) continue;
            sortedTiers.add(TierFactory.getTier(tierConfig, helixManager));
        }
        sortedTiers.sort(TierConfigUtils.getTierComparator());
        return sortedTiers;
    }

    public static Comparator<Tier> getTierComparator() {
        return (o1, o2) -> {
            TierSegmentSelector s1 = o1.getSegmentSelector();
            TierSegmentSelector s2 = o2.getSegmentSelector();
            Preconditions.checkState((boolean)"time".equalsIgnoreCase(s1.getType()), (String)"Unsupported segmentSelectorType class %s", s1.getClass());
            Preconditions.checkState((boolean)"time".equalsIgnoreCase(s2.getType()), (String)"Unsupported segmentSelectorType class %s", s2.getClass());
            Long period1 = ((TimeBasedTierSegmentSelector)s1).getSegmentAgeMillis();
            Long period2 = ((TimeBasedTierSegmentSelector)s2).getSegmentAgeMillis();
            return period2.compareTo(period1);
        };
    }
}

