/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.fetcher;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.utils.fetcher.HttpSegmentFetcher;
import org.apache.pinot.common.utils.fetcher.HttpsSegmentFetcher;
import org.apache.pinot.common.utils.fetcher.PinotFSSegmentFetcher;
import org.apache.pinot.common.utils.fetcher.SegmentFetcher;
import org.apache.pinot.spi.crypt.PinotCrypter;
import org.apache.pinot.spi.crypt.PinotCrypterFactory;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentFetcherFactory {
    private static final SegmentFetcherFactory INSTANCE = new SegmentFetcherFactory();
    static final String SEGMENT_FETCHER_CLASS_KEY_SUFFIX = ".class";
    private static final String PROTOCOLS_KEY = "protocols";
    private static final String AUTH_TOKEN_KEY = "auth.token";
    private static final String ENCODED_SUFFIX = ".enc";
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentFetcherFactory.class);
    private final Map<String, SegmentFetcher> _segmentFetcherMap = new HashMap<String, SegmentFetcher>();
    private final SegmentFetcher _httpSegmentFetcher = new HttpSegmentFetcher();
    private final SegmentFetcher _pinotFSSegmentFetcher = new PinotFSSegmentFetcher();

    private SegmentFetcherFactory() {
    }

    public static SegmentFetcherFactory getInstance() {
        return INSTANCE;
    }

    public static void init(PinotConfiguration config) throws Exception {
        SegmentFetcherFactory.getInstance().initInternal(config);
    }

    private void initInternal(PinotConfiguration config) throws Exception {
        this._httpSegmentFetcher.init(config);
        this._pinotFSSegmentFetcher.init(config);
        List protocols = config.getProperty(PROTOCOLS_KEY, Collections.emptyList());
        for (String protocol : protocols) {
            SegmentFetcher segmentFetcher;
            String segmentFetcherClassName = config.getProperty(protocol + SEGMENT_FETCHER_CLASS_KEY_SUFFIX);
            if (segmentFetcherClassName == null) {
                LOGGER.info("Segment fetcher class is not configured for protocol: {}, using default", (Object)protocol);
                switch (protocol) {
                    case "http": {
                        segmentFetcher = new HttpSegmentFetcher();
                        break;
                    }
                    case "https": {
                        segmentFetcher = new HttpsSegmentFetcher();
                        break;
                    }
                    default: {
                        segmentFetcher = new PinotFSSegmentFetcher();
                        break;
                    }
                }
            } else {
                LOGGER.info("Creating segment fetcher for protocol: {} with class: {}", (Object)protocol, (Object)segmentFetcherClassName);
                segmentFetcher = (SegmentFetcher)Class.forName(segmentFetcherClassName).newInstance();
            }
            String authToken = config.getProperty(AUTH_TOKEN_KEY);
            Map subConfigMap = config.subset(protocol).toMap();
            if (!subConfigMap.containsKey(AUTH_TOKEN_KEY) && StringUtils.isNotBlank((CharSequence)authToken)) {
                subConfigMap.put(AUTH_TOKEN_KEY, authToken);
            }
            segmentFetcher.init(new PinotConfiguration(subConfigMap));
            this._segmentFetcherMap.put(protocol, segmentFetcher);
        }
    }

    public static SegmentFetcher getSegmentFetcher(String protocol) {
        return SegmentFetcherFactory.getInstance().getSegmentFetcherInternal(protocol);
    }

    private SegmentFetcher getSegmentFetcherInternal(String protocol) {
        SegmentFetcher segmentFetcher = this._segmentFetcherMap.get(protocol);
        if (segmentFetcher != null) {
            return segmentFetcher;
        }
        LOGGER.info("Segment fetcher is not configured for protocol: {}, using default", (Object)protocol);
        switch (protocol) {
            case "http": 
            case "https": {
                return this._httpSegmentFetcher;
            }
        }
        return this._pinotFSSegmentFetcher;
    }

    public static void fetchSegmentToLocal(URI uri, File dest) throws Exception {
        SegmentFetcherFactory.getInstance().fetchSegmentToLocalInternal(uri, dest);
    }

    public static void fetchSegmentToLocal(String uri, File dest) throws Exception {
        SegmentFetcherFactory.getInstance().fetchSegmentToLocalInternal(new URI(uri), dest);
    }

    private void fetchSegmentToLocalInternal(URI uri, File dest) throws Exception {
        SegmentFetcherFactory.getSegmentFetcher(uri.getScheme()).fetchSegmentToLocal(uri, dest);
    }

    public static void fetchAndDecryptSegmentToLocal(String uri, File dest, String crypterName) throws Exception {
        SegmentFetcherFactory.getInstance().fetchAndDecryptSegmentToLocalInternal(uri, dest, crypterName);
    }

    private void fetchAndDecryptSegmentToLocalInternal(String uri, File dest, String crypterName) throws Exception {
        if (crypterName == null) {
            SegmentFetcherFactory.fetchSegmentToLocal(uri, dest);
        } else {
            File tempDownloadedFile = new File(dest.getPath() + ENCODED_SUFFIX);
            SegmentFetcherFactory.fetchSegmentToLocal(uri, tempDownloadedFile);
            PinotCrypter crypter = PinotCrypterFactory.create((String)crypterName);
            crypter.decrypt(tempDownloadedFile, dest);
        }
    }
}

