/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.helix;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.apache.commons.collections.CollectionUtils;
import org.apache.helix.AccessOption;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.utils.SchemaUtils;
import org.apache.pinot.common.utils.config.TableConfigUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableCache.class);
    private static final String TABLE_CONFIG_PARENT_PATH = "/CONFIGS/TABLE";
    private static final String TABLE_CONFIG_PATH_PREFIX = "/CONFIGS/TABLE/";
    private static final String SCHEMA_PARENT_PATH = "/SCHEMAS";
    private static final String SCHEMA_PATH_PREFIX = "/SCHEMAS/";
    private static final String LOWER_CASE_OFFLINE_TABLE_SUFFIX = "_offline";
    private static final String LOWER_CASE_REALTIME_TABLE_SUFFIX = "_realtime";
    private final ZkHelixPropertyStore<ZNRecord> _propertyStore;
    private final boolean _caseInsensitive;
    private final Map<String, String> _tableNameMap;
    private final TableConfigChangeListener _tableConfigChangeListener = new TableConfigChangeListener();
    private final Map<String, TableConfig> _tableConfigMap = new ConcurrentHashMap<String, TableConfig>();
    private final SchemaChangeListener _schemaChangeListener = new SchemaChangeListener();
    private final Map<String, SchemaInfo> _schemaInfoMap = new ConcurrentHashMap<String, SchemaInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableCache(ZkHelixPropertyStore<ZNRecord> propertyStore, boolean caseInsensitive) {
        ArrayList<String> pathsToAdd;
        List tables;
        this._propertyStore = propertyStore;
        this._caseInsensitive = caseInsensitive;
        this._tableNameMap = caseInsensitive ? new ConcurrentHashMap() : null;
        Object object = this._tableConfigChangeListener;
        synchronized (object) {
            this._propertyStore.subscribeChildChanges(TABLE_CONFIG_PARENT_PATH, (IZkChildListener)this._tableConfigChangeListener);
            tables = this._propertyStore.getChildNames(TABLE_CONFIG_PARENT_PATH, AccessOption.PERSISTENT);
            if (CollectionUtils.isNotEmpty((Collection)tables)) {
                pathsToAdd = new ArrayList<String>(tables.size());
                for (String tableNameWithType : tables) {
                    pathsToAdd.add(TABLE_CONFIG_PATH_PREFIX + tableNameWithType);
                }
                this.addTableConfigs(pathsToAdd);
            }
        }
        object = this._schemaChangeListener;
        synchronized (object) {
            this._propertyStore.subscribeChildChanges(SCHEMA_PARENT_PATH, (IZkChildListener)this._schemaChangeListener);
            tables = this._propertyStore.getChildNames(SCHEMA_PARENT_PATH, AccessOption.PERSISTENT);
            if (CollectionUtils.isNotEmpty((Collection)tables)) {
                pathsToAdd = new ArrayList(tables.size());
                for (String rawTableName : tables) {
                    pathsToAdd.add(SCHEMA_PATH_PREFIX + rawTableName);
                }
                this.addSchemas(pathsToAdd);
            }
        }
        LOGGER.info("Initialized TableCache with caseInsensitive: {}", (Object)caseInsensitive);
    }

    public boolean isCaseInsensitive() {
        return this._caseInsensitive;
    }

    @Nullable
    public String getActualTableName(String caseInsensitiveTableName) {
        Preconditions.checkState((boolean)this._caseInsensitive, (Object)"TableCache is not case-insensitive");
        return this._tableNameMap.get(caseInsensitiveTableName.toLowerCase());
    }

    @Nullable
    public Map<String, String> getColumnNameMap(String rawTableName) {
        Preconditions.checkState((boolean)this._caseInsensitive, (Object)"TableCache is not case-insensitive");
        SchemaInfo schemaInfo = this._schemaInfoMap.get(rawTableName);
        return schemaInfo != null ? schemaInfo._columnNameMap : null;
    }

    @Nullable
    public TableConfig getTableConfig(String tableNameWithType) {
        return this._tableConfigMap.get(tableNameWithType);
    }

    @Nullable
    public Schema getSchema(String rawTableName) {
        SchemaInfo schemaInfo = this._schemaInfoMap.get(rawTableName);
        return schemaInfo != null ? schemaInfo._schema : null;
    }

    private void addTableConfigs(List<String> paths) {
        for (String path : paths) {
            this._propertyStore.subscribeDataChanges(path, (IZkDataListener)this._tableConfigChangeListener);
        }
        List znRecords = this._propertyStore.get(paths, null, AccessOption.PERSISTENT);
        for (ZNRecord znRecord : znRecords) {
            if (znRecord == null) continue;
            try {
                this.putTableConfig(znRecord);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while adding table config for ZNRecord: {}", (Object)znRecord.getId(), (Object)e);
            }
        }
    }

    private void putTableConfig(ZNRecord znRecord) throws IOException {
        TableConfig tableConfig = TableConfigUtils.fromZNRecord(znRecord);
        String tableNameWithType = tableConfig.getTableName();
        this._tableConfigMap.put(tableNameWithType, tableConfig);
        if (this._caseInsensitive) {
            this._tableNameMap.put(tableNameWithType.toLowerCase(), tableNameWithType);
            String rawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType);
            this._tableNameMap.put(rawTableName.toLowerCase(), rawTableName);
        }
    }

    private void removeTableConfig(String path) {
        this._propertyStore.unsubscribeDataChanges(path, (IZkDataListener)this._tableConfigChangeListener);
        String tableNameWithType = path.substring(TABLE_CONFIG_PATH_PREFIX.length());
        this._tableConfigMap.remove(tableNameWithType);
        if (this._caseInsensitive) {
            this._tableNameMap.remove(tableNameWithType.toLowerCase());
            String lowerCaseRawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType).toLowerCase();
            if (TableNameBuilder.isOfflineTableResource((String)tableNameWithType)) {
                if (!this._tableNameMap.containsKey(lowerCaseRawTableName + LOWER_CASE_REALTIME_TABLE_SUFFIX)) {
                    this._tableNameMap.remove(lowerCaseRawTableName);
                }
            } else if (!this._tableNameMap.containsKey(lowerCaseRawTableName + LOWER_CASE_OFFLINE_TABLE_SUFFIX)) {
                this._tableNameMap.remove(lowerCaseRawTableName);
            }
        }
    }

    private void addSchemas(List<String> paths) {
        for (String path : paths) {
            this._propertyStore.subscribeDataChanges(path, (IZkDataListener)this._schemaChangeListener);
        }
        List znRecords = this._propertyStore.get(paths, null, AccessOption.PERSISTENT);
        for (ZNRecord znRecord : znRecords) {
            if (znRecord == null) continue;
            try {
                this.putSchema(znRecord);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while adding schema for ZNRecord: {}", (Object)znRecord.getId(), (Object)e);
            }
        }
    }

    private void putSchema(ZNRecord znRecord) throws IOException {
        Schema schema = SchemaUtils.fromZNRecord(znRecord);
        String rawTableName = schema.getSchemaName();
        if (this._caseInsensitive) {
            HashMap<String, String> columnNameMap = new HashMap<String, String>();
            for (String columnName : schema.getColumnNames()) {
                columnNameMap.put(columnName.toLowerCase(), columnName);
            }
            this._schemaInfoMap.put(rawTableName, new SchemaInfo(schema, columnNameMap));
        } else {
            this._schemaInfoMap.put(rawTableName, new SchemaInfo(schema, null));
        }
    }

    private void removeSchema(String path) {
        this._propertyStore.unsubscribeDataChanges(path, (IZkDataListener)this._schemaChangeListener);
        String rawTableName = path.substring(SCHEMA_PATH_PREFIX.length());
        this._schemaInfoMap.remove(rawTableName);
    }

    private static class SchemaInfo {
        final Schema _schema;
        final Map<String, String> _columnNameMap;

        private SchemaInfo(Schema schema, Map<String, String> columnNameMap) {
            this._schema = schema;
            this._columnNameMap = columnNameMap;
        }
    }

    private class SchemaChangeListener
    implements IZkChildListener,
    IZkDataListener {
        private SchemaChangeListener() {
        }

        public synchronized void handleChildChange(String path, List<String> tables) {
            if (CollectionUtils.isEmpty(tables)) {
                return;
            }
            ArrayList<String> pathsToAdd = new ArrayList<String>();
            for (String rawTableName : tables) {
                if (TableCache.this._schemaInfoMap.containsKey(rawTableName)) continue;
                pathsToAdd.add(TableCache.SCHEMA_PATH_PREFIX + rawTableName);
            }
            if (!pathsToAdd.isEmpty()) {
                TableCache.this.addSchemas(pathsToAdd);
            }
        }

        public synchronized void handleDataChange(String path, Object data) {
            if (data != null) {
                ZNRecord znRecord = (ZNRecord)data;
                try {
                    TableCache.this.putSchema(znRecord);
                }
                catch (Exception e) {
                    LOGGER.error("Caught exception while refreshing schema for ZNRecord: {}", (Object)znRecord.getId(), (Object)e);
                }
            }
        }

        public synchronized void handleDataDeleted(String path) {
            String rawTableName = path.substring(path.lastIndexOf(47) + 1);
            TableCache.this.removeSchema(TableCache.SCHEMA_PATH_PREFIX + rawTableName);
        }
    }

    private class TableConfigChangeListener
    implements IZkChildListener,
    IZkDataListener {
        private TableConfigChangeListener() {
        }

        public synchronized void handleChildChange(String path, List<String> tables) {
            if (CollectionUtils.isEmpty(tables)) {
                return;
            }
            ArrayList<String> pathsToAdd = new ArrayList<String>();
            for (String tableNameWithType : tables) {
                if (TableCache.this._tableConfigMap.containsKey(tableNameWithType)) continue;
                pathsToAdd.add(TableCache.TABLE_CONFIG_PATH_PREFIX + tableNameWithType);
            }
            if (!pathsToAdd.isEmpty()) {
                TableCache.this.addTableConfigs(pathsToAdd);
            }
        }

        public synchronized void handleDataChange(String path, Object data) {
            if (data != null) {
                ZNRecord znRecord = (ZNRecord)data;
                try {
                    TableCache.this.putTableConfig(znRecord);
                }
                catch (Exception e) {
                    LOGGER.error("Caught exception while refreshing table config for ZNRecord: {}", (Object)znRecord.getId(), (Object)e);
                }
            }
        }

        public synchronized void handleDataDeleted(String path) {
            String tableNameWithType = path.substring(path.lastIndexOf(47) + 1);
            TableCache.this.removeTableConfig(TableCache.TABLE_CONFIG_PATH_PREFIX + tableNameWithType);
        }
    }
}

