/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.pql.parsers.pql2.ast;

import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.DataSource;
import org.apache.pinot.common.request.GroupBy;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.request.QuerySource;
import org.apache.pinot.common.request.Selection;
import org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.pql.parsers.pql2.ast.BaseAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.GroupByAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.LimitAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.OrderByAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.TableNameAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.TopAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.WhereAstNode;

public class SelectAstNode
extends BaseAstNode {
    public static final int DEFAULT_RECORD_LIMIT = 10;
    private String _tableName;
    private String _resourceName;
    private int _recordLimit = -1;
    private int _offset = -1;
    private int _topN = -1;
    private boolean _hasWhereClause = false;
    private boolean _hasGroupByClause = false;
    private boolean _hasOrderByClause = false;
    private boolean _hasTopClause = false;
    private boolean _hasLimitClause = false;

    @Override
    public void addChild(AstNode childNode) {
        if (childNode instanceof LimitAstNode) {
            if (this._hasLimitClause) {
                throw new Pql2CompilationException("More than one LIMIT clause specified!");
            }
            LimitAstNode node = (LimitAstNode)childNode;
            this._recordLimit = node.getCount();
            this._offset = node.getOffset();
            this._hasLimitClause = true;
        } else if (childNode instanceof TableNameAstNode) {
            TableNameAstNode node = (TableNameAstNode)childNode;
            this._tableName = node.getTableName();
            this._resourceName = node.getResourceName();
        } else if (childNode instanceof TopAstNode) {
            if (this._hasTopClause) {
                throw new Pql2CompilationException("More than one TOP clause specified!");
            }
            TopAstNode node = (TopAstNode)childNode;
            this._topN = node.getCount();
            this._hasTopClause = true;
        } else if (childNode instanceof WhereAstNode) {
            if (this._hasWhereClause) {
                throw new Pql2CompilationException("More than one WHERE clause specified!");
            }
            super.addChild(childNode);
            this._hasWhereClause = true;
        } else if (childNode instanceof GroupByAstNode) {
            if (this._hasGroupByClause) {
                throw new Pql2CompilationException("More than one GROUP BY clause specified!");
            }
            super.addChild(childNode);
            this._hasGroupByClause = true;
        } else if (childNode instanceof OrderByAstNode) {
            if (this._hasOrderByClause) {
                throw new Pql2CompilationException("More than one ORDER BY clause specified!");
            }
            super.addChild(childNode);
            this._hasOrderByClause = true;
        } else {
            super.addChild(childNode);
        }
    }

    @Override
    public String toString() {
        return "SelectAstNode{_tableName='" + this._tableName + "', _resourceName='" + this._resourceName + "', _recordLimit=" + this._recordLimit + ", _offset=" + this._offset + "}";
    }

    @Override
    public void updateBrokerRequest(BrokerRequest brokerRequest) {
        GroupBy groupBy;
        QuerySource querySource = new QuerySource();
        querySource.setTableName(this._tableName);
        brokerRequest.setQuerySource(querySource);
        this.sendBrokerRequestUpdateToChildren(brokerRequest);
        Selection selections = brokerRequest.getSelections();
        if (selections != null) {
            if (this._recordLimit != -1) {
                selections.setSize(this._recordLimit);
            } else {
                selections.setSize(10);
            }
            if (this._offset != -1) {
                selections.setOffset(this._offset);
            }
        }
        if ((groupBy = brokerRequest.getGroupBy()) != null) {
            if (this._topN != -1) {
                groupBy.setTopN(this._topN);
            } else if (this._recordLimit > 0) {
                groupBy.setTopN(this._recordLimit);
            } else {
                groupBy.setTopN(10L);
            }
        }
        if (this._recordLimit != -1) {
            brokerRequest.setLimit(this._recordLimit);
        } else {
            brokerRequest.setLimit(10);
        }
        if (brokerRequest.getAggregationsInfoSize() != 0 && brokerRequest.isSetSelections()) {
            brokerRequest.setSelections(null);
        }
    }

    @Override
    public void updatePinotQuery(PinotQuery pinotQuery) {
        DataSource dataSource = new DataSource();
        dataSource.setTableName(this._tableName);
        pinotQuery.setDataSource(dataSource);
        this.sendPinotQueryUpdateToChildren(pinotQuery);
        if (this._offset != -1) {
            pinotQuery.setOffset(this._offset);
        }
        if (pinotQuery.getGroupByListSize() > 0) {
            if (this._topN != -1) {
                pinotQuery.setLimit(this._topN);
            } else if (this._recordLimit > 0) {
                pinotQuery.setLimit(this._recordLimit);
            } else {
                pinotQuery.setLimit(10);
            }
        } else if (this._recordLimit != -1) {
            pinotQuery.setLimit(this._recordLimit);
        } else {
            pinotQuery.setLimit(10);
        }
    }

    public boolean isHasTopClause() {
        return this._hasTopClause;
    }

    public int getTopN() {
        return this._topN;
    }

    public boolean isHasLimitClause() {
        return this._hasLimitClause;
    }

    public int getRecordLimit() {
        return this._recordLimit;
    }
}

