/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.calcite.config.Lex;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.babel.SqlBabelParserImpl;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.function.FunctionDefinitionRegistry;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.FunctionInvoker;
import org.apache.pinot.common.function.FunctionRegistry;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.common.request.DataSource;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Identifier;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.pql.parsers.pql2.ast.FilterKind;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.sql.parsers.SqlCompilationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteSqlParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalciteSqlParser.class);
    private static final Lex PINOT_LEX = Lex.MYSQL_ANSI;
    private static final SqlParser.Config PARSER_CONFIG = SqlParser.configBuilder().setLex(PINOT_LEX).setConformance((SqlConformance)SqlConformanceEnum.BABEL).setParserFactory(SqlBabelParserImpl.FACTORY).build();
    private static final Pattern OPTIONS_REGEX_PATTEN = Pattern.compile("option\\s*\\(([^\\)]+)\\)", 2);

    public static PinotQuery compileToPinotQuery(String sql) throws SqlCompilationException {
        List<String> options = CalciteSqlParser.extractOptionsFromSql(sql);
        if (!options.isEmpty()) {
            sql = CalciteSqlParser.removeOptionsFromSql(sql);
        }
        PinotQuery pinotQuery = CalciteSqlParser.compileCalciteSqlToPinotQuery(sql);
        CalciteSqlParser.setOptions(pinotQuery, options);
        return pinotQuery;
    }

    static void validate(Map<Identifier, Expression> aliasMap, PinotQuery pinotQuery) throws SqlCompilationException {
        CalciteSqlParser.validateSelectionClause(aliasMap, pinotQuery);
        CalciteSqlParser.validateGroupByClause(pinotQuery);
        CalciteSqlParser.validateDistinctQuery(pinotQuery);
    }

    private static void validateSelectionClause(Map<Identifier, Expression> aliasMap, PinotQuery pinotQuery) throws SqlCompilationException {
        HashSet<String> aliasKeys = new HashSet<String>();
        for (Identifier identifier : aliasMap.keySet()) {
            String aliasName = identifier.getName().toLowerCase();
            if (aliasKeys.add(aliasName)) continue;
            throw new SqlCompilationException("Duplicated alias name found.");
        }
        for (Expression selectExpr : pinotQuery.getSelectList()) {
            CalciteSqlParser.matchIdentifierInAliasMap(selectExpr, aliasKeys);
        }
    }

    private static void matchIdentifierInAliasMap(Expression selectExpr, Set<String> aliasKeys) throws SqlCompilationException {
        Function functionCall = selectExpr.getFunctionCall();
        if (functionCall != null) {
            if (functionCall.getOperator().equalsIgnoreCase(SqlKind.AS.toString())) {
                CalciteSqlParser.matchIdentifierInAliasMap(functionCall.getOperands().get(0), aliasKeys);
            } else if (functionCall.getOperandsSize() > 0) {
                for (Expression operand : functionCall.getOperands()) {
                    CalciteSqlParser.matchIdentifierInAliasMap(operand, aliasKeys);
                }
            }
        }
        if (selectExpr.getIdentifier() != null && aliasKeys.contains(selectExpr.getIdentifier().getName().toLowerCase())) {
            throw new SqlCompilationException("Alias " + selectExpr.getIdentifier().getName() + " cannot be referred in SELECT Clause");
        }
    }

    private static void validateGroupByClause(PinotQuery pinotQuery) throws SqlCompilationException {
        if (pinotQuery.getGroupByList() == null) {
            return;
        }
        HashSet<Expression> groupByExprs = new HashSet<Expression>(pinotQuery.getGroupByList());
        for (Expression selectExpression : pinotQuery.getSelectList()) {
            if (CalciteSqlParser.isAggregateExpression(selectExpression) || !CalciteSqlParser.expressionOutsideGroupByList(selectExpression, groupByExprs)) continue;
            throw new SqlCompilationException("'" + RequestUtils.prettyPrint(selectExpression) + "' should appear in GROUP BY clause.");
        }
        for (Expression groupByExpression : pinotQuery.getGroupByList()) {
            if (!CalciteSqlParser.isAggregateExpression(groupByExpression)) continue;
            throw new SqlCompilationException("Aggregate expression '" + RequestUtils.prettyPrint(groupByExpression) + "' is not allowed in GROUP BY clause.");
        }
    }

    private static void validateDistinctQuery(PinotQuery pinotQuery) throws SqlCompilationException {
        Function function;
        List<Expression> selectList = pinotQuery.getSelectList();
        if (selectList.size() == 1 && (function = selectList.get(0).getFunctionCall()) != null && function.getOperator().equalsIgnoreCase(AggregationFunctionType.DISTINCT.getName())) {
            if (CollectionUtils.isNotEmpty(pinotQuery.getGroupByList())) {
                throw new IllegalStateException("DISTINCT with GROUP BY is currently not supported");
            }
            if (pinotQuery.getLimit() <= 0) {
                throw new IllegalStateException("DISTINCT must have positive LIMIT");
            }
            List<Expression> orderByList = pinotQuery.getOrderByList();
            if (orderByList != null) {
                List<Expression> distinctExpressions = function.getOperands();
                for (Expression orderByExpression : orderByList) {
                    if (distinctExpressions.contains(orderByExpression.getFunctionCall().getOperands().get(0))) continue;
                    throw new IllegalStateException("ORDER-BY columns should be included in the DISTINCT columns");
                }
            }
        }
    }

    private static boolean expressionOutsideGroupByList(Expression expr, Set<Expression> groupByExprs) {
        if (expr.getType() == ExpressionType.LITERAL || CalciteSqlParser.isAggregateExpression(expr) || groupByExprs.contains(expr)) {
            return false;
        }
        Function funcExpr = expr.getFunctionCall();
        if (funcExpr != null) {
            if (funcExpr.getOperator().equalsIgnoreCase(SqlKind.AS.toString())) {
                return CalciteSqlParser.expressionOutsideGroupByList(funcExpr.getOperands().get(0), groupByExprs);
            }
            return funcExpr.getOperands().stream().anyMatch(e -> CalciteSqlParser.expressionOutsideGroupByList(e, groupByExprs));
        }
        return true;
    }

    private static boolean isAggregateExpression(Expression expression) {
        block4: {
            Function functionCall = expression.getFunctionCall();
            if (functionCall != null) {
                String operator = functionCall.getOperator();
                try {
                    AggregationFunctionType.getAggregationFunctionType((String)operator);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (functionCall.getOperandsSize() <= 0) break block4;
                    for (Expression operand : functionCall.getOperands()) {
                        if (!CalciteSqlParser.isAggregateExpression(operand)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static Set<String> extractIdentifiers(List<Expression> expressions, boolean excludeAs) {
        HashSet<String> identifiers = new HashSet<String>();
        for (Expression expression : expressions) {
            if (expression.getIdentifier() != null) {
                identifiers.add(expression.getIdentifier().getName());
                continue;
            }
            if (expression.getFunctionCall() == null) continue;
            if (excludeAs && expression.getFunctionCall().getOperator().equalsIgnoreCase("AS")) {
                identifiers.addAll(CalciteSqlParser.extractIdentifiers(Arrays.asList(expression.getFunctionCall().getOperands().get(0)), true));
                continue;
            }
            identifiers.addAll(CalciteSqlParser.extractIdentifiers(expression.getFunctionCall().getOperands(), excludeAs));
        }
        return identifiers;
    }

    public static Expression compileToExpression(String expression) {
        SqlNode sqlNode;
        SqlParser sqlParser = SqlParser.create((String)expression, (SqlParser.Config)PARSER_CONFIG);
        try {
            sqlNode = sqlParser.parseExpression();
        }
        catch (SqlParseException e) {
            throw new SqlCompilationException("Caught exception while parsing expression: " + expression, e);
        }
        return CalciteSqlParser.toExpression(sqlNode);
    }

    private static void setOptions(PinotQuery pinotQuery, List<String> optionsStatements) {
        if (optionsStatements.isEmpty()) {
            return;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        for (String optionsStatement : optionsStatements) {
            for (String option : optionsStatement.split(",")) {
                String[] splits = option.split("=");
                if (splits.length != 2) {
                    throw new SqlCompilationException("OPTION statement requires two parts separated by '='");
                }
                options.put(splits[0].trim(), splits[1].trim());
            }
        }
        pinotQuery.setQueryOptions(options);
    }

    private static PinotQuery compileCalciteSqlToPinotQuery(String sql) {
        SqlNode offsetNode;
        SqlNode limitNode;
        SqlNodeList orderByNodeList;
        SqlNode havingNode;
        SqlNodeList groupByNodeList;
        SqlNode whereNode;
        SqlSelect selectNode;
        SqlNode sqlNode;
        SqlParser sqlParser = SqlParser.create((String)sql, (SqlParser.Config)PARSER_CONFIG);
        try {
            sqlNode = sqlParser.parseQuery();
        }
        catch (SqlParseException e) {
            throw new SqlCompilationException("Caught exception while parsing query: " + sql, e);
        }
        if (sqlNode instanceof SqlOrderBy) {
            SqlOrderBy orderByNode = (SqlOrderBy)sqlNode;
            selectNode = (SqlSelect)orderByNode.query;
            selectNode.setOrderBy(orderByNode.orderList);
            selectNode.setFetch(orderByNode.fetch);
            selectNode.setOffset(orderByNode.offset);
        } else {
            selectNode = (SqlSelect)sqlNode;
        }
        PinotQuery pinotQuery = new PinotQuery();
        if (selectNode.getModifierNode(SqlSelectKeyword.DISTINCT) != null) {
            if (selectNode.getGroup() != null) {
                throw new SqlCompilationException("DISTINCT with GROUP BY is not supported");
            }
            pinotQuery.setSelectList(CalciteSqlParser.convertDistinctSelectList(selectNode.getSelectList()));
        } else {
            pinotQuery.setSelectList(CalciteSqlParser.convertSelectList(selectNode.getSelectList()));
        }
        SqlNode fromNode = selectNode.getFrom();
        if (fromNode != null) {
            DataSource dataSource = new DataSource();
            dataSource.setTableName(fromNode.toString());
            pinotQuery.setDataSource(dataSource);
        }
        if ((whereNode = selectNode.getWhere()) != null) {
            pinotQuery.setFilterExpression(CalciteSqlParser.toExpression(whereNode));
        }
        if ((groupByNodeList = selectNode.getGroup()) != null) {
            pinotQuery.setGroupByList(CalciteSqlParser.convertSelectList(groupByNodeList));
        }
        if ((havingNode = selectNode.getHaving()) != null) {
            pinotQuery.setHavingExpression(CalciteSqlParser.toExpression(havingNode));
        }
        if ((orderByNodeList = selectNode.getOrderList()) != null) {
            pinotQuery.setOrderByList(CalciteSqlParser.convertOrderByList(orderByNodeList));
        }
        if ((limitNode = selectNode.getFetch()) != null) {
            pinotQuery.setLimit(((SqlNumericLiteral)limitNode).intValue(false));
        }
        if ((offsetNode = selectNode.getOffset()) != null) {
            pinotQuery.setOffset(((SqlNumericLiteral)offsetNode).intValue(false));
        }
        CalciteSqlParser.queryRewrite(pinotQuery);
        return pinotQuery;
    }

    private static void queryRewrite(PinotQuery pinotQuery) {
        Expression havingExpression;
        CalciteSqlParser.invokeCompileTimeFunctions(pinotQuery);
        CalciteSqlParser.rewriteSelections(pinotQuery.getSelectList());
        Expression filterExpression = pinotQuery.getFilterExpression();
        if (filterExpression != null) {
            pinotQuery.setFilterExpression(CalciteSqlParser.updateComparisonPredicate(filterExpression));
        }
        if ((havingExpression = pinotQuery.getHavingExpression()) != null) {
            pinotQuery.setHavingExpression(CalciteSqlParser.updateComparisonPredicate(havingExpression));
        }
        CalciteSqlParser.applyOrdinals(pinotQuery);
        CalciteSqlParser.rewriteNonAggregationGroupByToDistinct(pinotQuery);
        Map<Identifier, Expression> aliasMap = CalciteSqlParser.extractAlias(pinotQuery.getSelectList());
        CalciteSqlParser.applyAlias(aliasMap, pinotQuery);
        CalciteSqlParser.validate(aliasMap, pinotQuery);
    }

    private static void applyOrdinals(PinotQuery pinotQuery) {
        int ordinal;
        int i;
        for (i = 0; i < pinotQuery.getGroupByListSize(); ++i) {
            Expression groupByExpr = pinotQuery.getGroupByList().get(i);
            if (!groupByExpr.isSetLiteral() || !groupByExpr.getLiteral().isSetLongValue()) continue;
            ordinal = (int)groupByExpr.getLiteral().getLongValue();
            pinotQuery.getGroupByList().set(i, CalciteSqlParser.getExpressionFromOrdinal(pinotQuery.getSelectList(), ordinal));
        }
        for (i = 0; i < pinotQuery.getOrderByListSize(); ++i) {
            Expression orderByExpr = pinotQuery.getOrderByList().get(i).getFunctionCall().getOperands().get(0);
            if (!orderByExpr.isSetLiteral() || !orderByExpr.getLiteral().isSetLongValue()) continue;
            ordinal = (int)orderByExpr.getLiteral().getLongValue();
            pinotQuery.getOrderByList().get(i).getFunctionCall().setOperands(Arrays.asList(CalciteSqlParser.getExpressionFromOrdinal(pinotQuery.getSelectList(), ordinal)));
        }
    }

    private static Expression getExpressionFromOrdinal(List<Expression> selectList, int ordinal) {
        if (ordinal > 0 && ordinal <= selectList.size()) {
            Expression expression = selectList.get(ordinal - 1);
            if (expression.isSetFunctionCall() && expression.getFunctionCall().getOperator().equals(SqlKind.AS.name())) {
                return expression.getFunctionCall().getOperands().get(0);
            }
            return expression;
        }
        throw new SqlCompilationException(String.format("Expected Ordinal value to be between 1 and %d.", selectList.size()));
    }

    private static void rewriteSelections(List<Expression> selectList) {
        for (Expression expression : selectList) {
            CalciteSqlParser.tryToRewriteArrayFunction(expression);
        }
    }

    private static void tryToRewriteArrayFunction(Expression expression) {
        if (!expression.isSetFunctionCall()) {
            return;
        }
        Function functionCall = expression.getFunctionCall();
        switch (CalciteSqlParser.canonicalize(functionCall.getOperator())) {
            case "sum": {
                Function innerFunction;
                if (functionCall.getOperands().size() != 1) {
                    return;
                }
                if (functionCall.getOperands().get(0).isSetFunctionCall() && CalciteSqlParser.isSameFunction((innerFunction = functionCall.getOperands().get(0).getFunctionCall()).getOperator(), TransformFunctionType.ARRAYSUM.getName())) {
                    Function sumMvFunc = new Function(AggregationFunctionType.SUMMV.getName());
                    sumMvFunc.setOperands(innerFunction.getOperands());
                    expression.setFunctionCall(sumMvFunc);
                }
                return;
            }
            case "min": {
                Function innerFunction;
                if (functionCall.getOperands().size() != 1) {
                    return;
                }
                if (functionCall.getOperands().get(0).isSetFunctionCall() && CalciteSqlParser.isSameFunction((innerFunction = functionCall.getOperands().get(0).getFunctionCall()).getOperator(), TransformFunctionType.ARRAYMIN.getName())) {
                    Function sumMvFunc = new Function(AggregationFunctionType.MINMV.getName());
                    sumMvFunc.setOperands(innerFunction.getOperands());
                    expression.setFunctionCall(sumMvFunc);
                }
                return;
            }
            case "max": {
                Function innerFunction;
                if (functionCall.getOperands().size() != 1) {
                    return;
                }
                if (functionCall.getOperands().get(0).isSetFunctionCall() && CalciteSqlParser.isSameFunction((innerFunction = functionCall.getOperands().get(0).getFunctionCall()).getOperator(), TransformFunctionType.ARRAYMAX.getName())) {
                    Function sumMvFunc = new Function(AggregationFunctionType.MAXMV.getName());
                    sumMvFunc.setOperands(innerFunction.getOperands());
                    expression.setFunctionCall(sumMvFunc);
                }
                return;
            }
        }
        for (Expression operand : functionCall.getOperands()) {
            CalciteSqlParser.tryToRewriteArrayFunction(operand);
        }
    }

    private static String canonicalize(String functionName) {
        return StringUtils.remove((String)functionName, (char)'_').toLowerCase();
    }

    private static boolean isSameFunction(String function1, String function2) {
        return CalciteSqlParser.canonicalize(function1).equals(CalciteSqlParser.canonicalize(function2));
    }

    private static void rewriteNonAggregationGroupByToDistinct(PinotQuery pinotQuery) {
        boolean hasAggregation = false;
        for (Expression select : pinotQuery.getSelectList()) {
            if (!CalciteSqlParser.isAggregateExpression(select)) continue;
            hasAggregation = true;
        }
        if (pinotQuery.getOrderByList() != null) {
            for (Expression orderBy : pinotQuery.getOrderByList()) {
                if (!CalciteSqlParser.isAggregateExpression(orderBy)) continue;
                hasAggregation = true;
            }
        }
        if (!hasAggregation && pinotQuery.getGroupByListSize() > 0) {
            Set<String> selectIdentifiers = CalciteSqlParser.extractIdentifiers(pinotQuery.getSelectList(), true);
            Set<String> groupByIdentifiers = CalciteSqlParser.extractIdentifiers(pinotQuery.getGroupByList(), true);
            if (groupByIdentifiers.containsAll(selectIdentifiers)) {
                Expression distinctExpression = RequestUtils.getFunctionExpression("DISTINCT");
                for (Expression select : pinotQuery.getSelectList()) {
                    if (CalciteSqlParser.isAsFunction(select)) {
                        Function asFunc = select.getFunctionCall();
                        distinctExpression.getFunctionCall().addToOperands(asFunc.getOperands().get(0));
                        continue;
                    }
                    distinctExpression.getFunctionCall().addToOperands(select);
                }
                pinotQuery.setSelectList(Arrays.asList(distinctExpression));
                pinotQuery.setGroupByList(Collections.emptyList());
            } else {
                selectIdentifiers.removeAll(groupByIdentifiers);
                throw new SqlCompilationException(String.format("For non-aggregation group by query, all the identifiers in select clause should be in groupBys. Found identifier: %s", Arrays.toString(selectIdentifiers.toArray(new String[0]))));
            }
        }
    }

    private static boolean isAsFunction(Expression expression) {
        return expression.getFunctionCall() != null && expression.getFunctionCall().getOperator().equalsIgnoreCase("AS");
    }

    private static void invokeCompileTimeFunctions(PinotQuery pinotQuery) {
        Expression expression;
        int i;
        for (i = 0; i < pinotQuery.getSelectListSize(); ++i) {
            expression = CalciteSqlParser.invokeCompileTimeFunctionExpression(pinotQuery.getSelectList().get(i));
            pinotQuery.getSelectList().set(i, expression);
        }
        for (i = 0; i < pinotQuery.getGroupByListSize(); ++i) {
            expression = CalciteSqlParser.invokeCompileTimeFunctionExpression(pinotQuery.getGroupByList().get(i));
            pinotQuery.getGroupByList().set(i, expression);
        }
        for (i = 0; i < pinotQuery.getOrderByListSize(); ++i) {
            expression = CalciteSqlParser.invokeCompileTimeFunctionExpression(pinotQuery.getOrderByList().get(i));
            pinotQuery.getOrderByList().set(i, expression);
        }
        Expression filterExpression = CalciteSqlParser.invokeCompileTimeFunctionExpression(pinotQuery.getFilterExpression());
        pinotQuery.setFilterExpression(filterExpression);
        Expression havingExpression = CalciteSqlParser.invokeCompileTimeFunctionExpression(pinotQuery.getHavingExpression());
        pinotQuery.setHavingExpression(havingExpression);
    }

    private static Expression updateComparisonPredicate(Expression expression) {
        Function function = expression.getFunctionCall();
        if (function != null) {
            FilterKind filterKind;
            String operator = function.getOperator().toUpperCase();
            try {
                filterKind = FilterKind.valueOf(operator);
            }
            catch (Exception e) {
                throw new SqlCompilationException("Unsupported filter kind: " + operator);
            }
            List<Expression> operands = function.getOperands();
            switch (filterKind) {
                case AND: 
                case OR: {
                    operands.replaceAll(CalciteSqlParser::updateComparisonPredicate);
                    break;
                }
                case EQUALS: 
                case NOT_EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    Expression firstOperand = operands.get(0);
                    Expression secondOperand = operands.get(1);
                    if (firstOperand.isSetLiteral()) {
                        if (secondOperand.isSetLiteral()) break;
                        function.setOperator(CalciteSqlParser.getOppositeOperator(filterKind).name());
                        operands.set(0, secondOperand);
                        operands.set(1, firstOperand);
                        break;
                    }
                    if (secondOperand.isSetLiteral()) break;
                    Expression minusExpression = RequestUtils.getFunctionExpression(SqlKind.MINUS.name());
                    minusExpression.getFunctionCall().setOperands(Arrays.asList(firstOperand, secondOperand));
                    operands.set(0, minusExpression);
                    operands.set(1, RequestUtils.getLiteralExpression(0L));
                    break;
                }
                default: {
                    int numOperands = operands.size();
                    for (int i = 1; i < numOperands; ++i) {
                        if (operands.get(i).isSetLiteral()) continue;
                        throw new SqlCompilationException(String.format("For %s predicate, the operands except for the first one must be literal, got: %s", new Object[]{filterKind, expression}));
                    }
                }
            }
        }
        return expression;
    }

    private static FilterKind getOppositeOperator(FilterKind filterKind) {
        switch (filterKind) {
            case GREATER_THAN: {
                return FilterKind.LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return FilterKind.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return FilterKind.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return FilterKind.GREATER_THAN_OR_EQUAL;
            }
        }
        return filterKind;
    }

    private static void applyAlias(Map<Identifier, Expression> aliasMap, PinotQuery pinotQuery) {
        List<Expression> orderByList;
        Expression havingExpression;
        List<Expression> groupByList;
        Expression filterExpression = pinotQuery.getFilterExpression();
        if (filterExpression != null) {
            CalciteSqlParser.applyAlias(aliasMap, filterExpression);
        }
        if ((groupByList = pinotQuery.getGroupByList()) != null) {
            for (Expression expression : groupByList) {
                CalciteSqlParser.applyAlias(aliasMap, expression);
            }
        }
        if ((havingExpression = pinotQuery.getHavingExpression()) != null) {
            CalciteSqlParser.applyAlias(aliasMap, havingExpression);
        }
        if ((orderByList = pinotQuery.getOrderByList()) != null) {
            for (Expression expression : orderByList) {
                CalciteSqlParser.applyAlias(aliasMap, expression);
            }
        }
    }

    private static void applyAlias(Map<Identifier, Expression> aliasMap, Expression expression) {
        Identifier identifierKey = expression.getIdentifier();
        if (identifierKey != null) {
            Expression aliasExpression = aliasMap.get(identifierKey);
            if (aliasExpression != null) {
                expression.setType(aliasExpression.getType());
                expression.setIdentifier(aliasExpression.getIdentifier());
                expression.setFunctionCall(aliasExpression.getFunctionCall());
                expression.setLiteral(aliasExpression.getLiteral());
            }
            return;
        }
        Function function = expression.getFunctionCall();
        if (function != null) {
            for (Expression operand : function.getOperands()) {
                CalciteSqlParser.applyAlias(aliasMap, operand);
            }
        }
    }

    private static Map<Identifier, Expression> extractAlias(List<Expression> expressions) {
        HashMap<Identifier, Expression> aliasMap = new HashMap<Identifier, Expression>();
        for (Expression expression : expressions) {
            Function functionCall = expression.getFunctionCall();
            if (functionCall == null || !functionCall.getOperator().equalsIgnoreCase(SqlKind.AS.toString())) continue;
            Expression identifierExpr = functionCall.getOperands().get(1);
            aliasMap.put(identifierExpr.getIdentifier(), functionCall.getOperands().get(0));
        }
        return aliasMap;
    }

    private static List<String> extractOptionsFromSql(String sql) {
        ArrayList<String> results = new ArrayList<String>();
        Matcher matcher = OPTIONS_REGEX_PATTEN.matcher(sql);
        while (matcher.find()) {
            results.add(matcher.group(1));
        }
        return results;
    }

    private static String removeOptionsFromSql(String sql) {
        Matcher matcher = OPTIONS_REGEX_PATTEN.matcher(sql);
        return matcher.replaceAll("");
    }

    private static List<Expression> convertDistinctSelectList(SqlNodeList selectList) {
        ArrayList<Expression> selectExpr = new ArrayList<Expression>();
        selectExpr.add(CalciteSqlParser.convertDistinctAndSelectListToFunctionExpression(selectList));
        return selectExpr;
    }

    private static List<Expression> convertSelectList(SqlNodeList selectList) {
        ArrayList<Expression> selectExpr = new ArrayList<Expression>();
        for (SqlNode next : selectList) {
            selectExpr.add(CalciteSqlParser.toExpression(next));
        }
        return selectExpr;
    }

    private static List<Expression> convertOrderByList(SqlNodeList orderList) {
        ArrayList<Expression> orderByExpr = new ArrayList<Expression>();
        for (SqlNode next : orderList) {
            orderByExpr.add(CalciteSqlParser.convertOrderBy(next));
        }
        return orderByExpr;
    }

    private static Expression convertOrderBy(SqlNode node) {
        Expression expression;
        SqlKind kind = node.getKind();
        switch (kind) {
            case DESCENDING: {
                SqlBasicCall basicCall = (SqlBasicCall)node;
                expression = RequestUtils.getFunctionExpression("DESC");
                expression.getFunctionCall().addToOperands(CalciteSqlParser.toExpression(basicCall.getOperands()[0]));
                break;
            }
            default: {
                expression = RequestUtils.getFunctionExpression("ASC");
                expression.getFunctionCall().addToOperands(CalciteSqlParser.toExpression(node));
            }
        }
        return expression;
    }

    private static Expression convertDistinctAndSelectListToFunctionExpression(SqlNodeList selectList) {
        String functionName = AggregationFunctionType.DISTINCT.getName();
        Expression functionExpression = RequestUtils.getFunctionExpression(functionName);
        for (SqlNode node : selectList) {
            Function functionCall;
            String function;
            Expression columnExpression = CalciteSqlParser.toExpression(node);
            if (columnExpression.getType() == ExpressionType.IDENTIFIER && columnExpression.getIdentifier().getName().equals("*")) {
                throw new SqlCompilationException("Syntax error: Pinot currently does not support DISTINCT with *. Please specify each column name after DISTINCT keyword");
            }
            if (columnExpression.getType() == ExpressionType.FUNCTION && FunctionDefinitionRegistry.isAggFunc(function = (functionCall = columnExpression.getFunctionCall()).getOperator())) {
                throw new SqlCompilationException("Syntax error: Use of DISTINCT with aggregation functions is not supported");
            }
            functionExpression.getFunctionCall().addToOperands(columnExpression);
        }
        return functionExpression;
    }

    private static Expression toExpression(SqlNode node) {
        LOGGER.debug("Current processing SqlNode: {}, node.getKind(): {}", (Object)node, (Object)node.getKind());
        switch (node.getKind()) {
            case IDENTIFIER: {
                if (((SqlIdentifier)node).isStar()) {
                    return RequestUtils.getIdentifierExpression("*");
                }
                if (((SqlIdentifier)node).isSimple()) {
                    return RequestUtils.getIdentifierExpression(((SqlIdentifier)node).getSimple());
                }
                return RequestUtils.getIdentifierExpression(node.toString());
            }
            case LITERAL: {
                return RequestUtils.getLiteralExpression((SqlLiteral)node);
            }
            case AS: {
                String aliasName;
                SqlBasicCall asFuncSqlNode = (SqlBasicCall)node;
                Expression leftExpr = CalciteSqlParser.toExpression(asFuncSqlNode.getOperands()[0]);
                SqlNode aliasSqlNode = asFuncSqlNode.getOperands()[1];
                switch (aliasSqlNode.getKind()) {
                    case IDENTIFIER: {
                        aliasName = ((SqlIdentifier)aliasSqlNode).getSimple();
                        break;
                    }
                    case LITERAL: {
                        aliasName = ((SqlLiteral)aliasSqlNode).toValue();
                        break;
                    }
                    default: {
                        throw new SqlCompilationException("Unsupported Alias sql node - " + aliasSqlNode);
                    }
                }
                Expression rightExpr = RequestUtils.getIdentifierExpression(aliasName);
                if (leftExpr.isSetIdentifier() && rightExpr.isSetIdentifier() && leftExpr.getIdentifier().getName().equals(rightExpr.getIdentifier().getName())) {
                    return leftExpr;
                }
                Expression asFuncExpr = RequestUtils.getFunctionExpression(SqlKind.AS.toString());
                asFuncExpr.getFunctionCall().addToOperands(leftExpr);
                asFuncExpr.getFunctionCall().addToOperands(rightExpr);
                return asFuncExpr;
            }
            case CASE: {
                SqlCase caseSqlNode = (SqlCase)node;
                SqlNodeList whenOperands = caseSqlNode.getWhenOperands();
                SqlNodeList thenOperands = caseSqlNode.getThenOperands();
                SqlNode elseOperand = caseSqlNode.getElseOperand();
                Expression caseFuncExpr = RequestUtils.getFunctionExpression(SqlKind.CASE.name());
                for (SqlNode whenSqlNode : whenOperands.getList()) {
                    Expression whenExpression = CalciteSqlParser.toExpression(whenSqlNode);
                    if (CalciteSqlParser.isAggregateExpression(whenExpression)) {
                        throw new SqlCompilationException("Aggregation functions inside WHEN Clause is not supported - " + whenSqlNode);
                    }
                    caseFuncExpr.getFunctionCall().addToOperands(whenExpression);
                }
                for (SqlNode thenSqlNode : thenOperands.getList()) {
                    Expression thenExpression = CalciteSqlParser.toExpression(thenSqlNode);
                    if (CalciteSqlParser.isAggregateExpression(thenExpression)) {
                        throw new SqlCompilationException("Aggregation functions inside THEN Clause is not supported - " + thenSqlNode);
                    }
                    caseFuncExpr.getFunctionCall().addToOperands(thenExpression);
                }
                Expression elseExpression = CalciteSqlParser.toExpression(elseOperand);
                if (CalciteSqlParser.isAggregateExpression(elseExpression)) {
                    throw new SqlCompilationException("Aggregation functions inside ELSE Clause is not supported - " + elseExpression);
                }
                caseFuncExpr.getFunctionCall().addToOperands(elseExpression);
                return caseFuncExpr;
            }
        }
        if (node instanceof SqlDataTypeSpec) {
            return RequestUtils.getLiteralExpression(((SqlDataTypeSpec)node).getTypeName().getSimple());
        }
        return CalciteSqlParser.compileFunctionExpression((SqlBasicCall)node);
    }

    private static Expression compileFunctionExpression(SqlBasicCall functionNode) {
        String functionName;
        SqlKind functionKind = functionNode.getKind();
        switch (functionKind) {
            case AND: {
                return CalciteSqlParser.compileAndExpression(functionNode);
            }
            case OR: {
                return CalciteSqlParser.compileOrExpression(functionNode);
            }
            case COUNT: {
                SqlLiteral functionQuantifier = functionNode.getFunctionQuantifier();
                if (functionQuantifier != null && functionQuantifier.toValue().equalsIgnoreCase("DISTINCT")) {
                    functionName = AggregationFunctionType.DISTINCTCOUNT.name();
                    break;
                }
                functionName = AggregationFunctionType.COUNT.name();
                break;
            }
            case OTHER: 
            case OTHER_FUNCTION: 
            case DOT: {
                functionName = functionNode.getOperator().getName().toUpperCase();
                if (!functionName.equals("ITEM") && !functionName.equals("DOT")) break;
                StringBuffer path = new StringBuffer();
                CalciteSqlParser.compilePathExpression(functionName, functionNode, path);
                return RequestUtils.getIdentifierExpression(path.toString());
            }
            default: {
                functionName = functionKind.name();
            }
        }
        SqlNode[] childNodes = functionNode.getOperands();
        ArrayList<Expression> operands = new ArrayList<Expression>(childNodes.length);
        for (SqlNode childNode : childNodes) {
            if (childNode instanceof SqlNodeList) {
                for (SqlNode node : (SqlNodeList)childNode) {
                    operands.add(CalciteSqlParser.toExpression(node));
                }
                continue;
            }
            operands.add(CalciteSqlParser.toExpression(childNode));
        }
        CalciteSqlParser.validateFunction(functionName, operands);
        Expression functionExpression = RequestUtils.getFunctionExpression(functionName);
        functionExpression.getFunctionCall().setOperands(operands);
        return functionExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void compilePathExpression(String functionName, SqlBasicCall functionNode, StringBuffer path) {
        SqlNode[] operands = functionNode.getOperands();
        SqlKind kind0 = operands[0].getKind();
        if (kind0 == SqlKind.IDENTIFIER) {
            path.append(((SqlIdentifier)operands[0]).toString());
        } else {
            if (kind0 != SqlKind.DOT && kind0 != SqlKind.OTHER_FUNCTION) throw new SqlCompilationException("SELECT list item has bad path expression.");
            SqlBasicCall function0 = (SqlBasicCall)operands[0];
            String name0 = function0.getOperator().getName();
            if (!name0.equals("ITEM") && !name0.equals("DOT")) throw new SqlCompilationException("SELECT list item has bad path expression.");
            CalciteSqlParser.compilePathExpression(name0, function0, path);
        }
        SqlKind kind1 = operands[1].getKind();
        if (kind1 == SqlKind.IDENTIFIER) {
            path.append(".").append(((SqlIdentifier)operands[1]).getSimple());
            return;
        } else {
            if (kind1 != SqlKind.LITERAL) throw new SqlCompilationException("SELECT list item has bad path expression.");
            path.append("[").append(((SqlLiteral)operands[1]).toValue()).append("]");
        }
    }

    private static void validateFunction(String functionName, List<Expression> operands) {
        switch (CalciteSqlParser.canonicalize(functionName)) {
            case "jsonextractscalar": {
                CalciteSqlParser.validateJsonExtractScalarFunction(operands);
                break;
            }
            case "jsonextractkey": {
                CalciteSqlParser.validateJsonExtractKeyFunction(operands);
            }
        }
    }

    private static void validateJsonExtractScalarFunction(List<Expression> operands) {
        int numOperands = operands.size();
        if (numOperands != 3 && numOperands != 4) {
            throw new SqlCompilationException("Expect 3 or 4 arguments for transform function: jsonExtractScalar(jsonFieldName, 'jsonPath', 'resultsType', ['defaultValue'])");
        }
        if (!operands.get(1).isSetLiteral() || !operands.get(2).isSetLiteral() || numOperands == 4 && !operands.get(3).isSetLiteral()) {
            throw new SqlCompilationException("Expect the 2nd/3rd/4th argument of transform function: jsonExtractScalar(jsonFieldName, 'jsonPath', 'resultsType', ['defaultValue']) to be a single-quoted literal value.");
        }
    }

    private static void validateJsonExtractKeyFunction(List<Expression> operands) {
        if (operands.size() != 2) {
            throw new SqlCompilationException("Expect 2 arguments are required for transform function: jsonExtractKey(jsonFieldName, 'jsonPath')");
        }
        if (!operands.get(1).isSetLiteral()) {
            throw new SqlCompilationException("Expect the 2nd argument for transform function: jsonExtractKey(jsonFieldName, 'jsonPath') to be a single-quoted literal value.");
        }
    }

    private static Expression compileAndExpression(SqlBasicCall andNode) {
        ArrayList<Expression> operands = new ArrayList<Expression>();
        for (SqlNode childNode : andNode.getOperands()) {
            if (childNode.getKind() == SqlKind.AND) {
                Expression childAndExpression = CalciteSqlParser.compileAndExpression((SqlBasicCall)childNode);
                operands.addAll(childAndExpression.getFunctionCall().getOperands());
                continue;
            }
            operands.add(CalciteSqlParser.compileFunctionExpression((SqlBasicCall)childNode));
        }
        Expression andExpression = RequestUtils.getFunctionExpression(SqlKind.AND.name());
        andExpression.getFunctionCall().setOperands(operands);
        return andExpression;
    }

    private static Expression compileOrExpression(SqlBasicCall orNode) {
        ArrayList<Expression> operands = new ArrayList<Expression>();
        for (SqlNode childNode : orNode.getOperands()) {
            if (childNode.getKind() == SqlKind.OR) {
                Expression childAndExpression = CalciteSqlParser.compileOrExpression((SqlBasicCall)childNode);
                operands.addAll(childAndExpression.getFunctionCall().getOperands());
                continue;
            }
            operands.add(CalciteSqlParser.compileFunctionExpression((SqlBasicCall)childNode));
        }
        Expression andExpression = RequestUtils.getFunctionExpression(SqlKind.OR.name());
        andExpression.getFunctionCall().setOperands(operands);
        return andExpression;
    }

    protected static Expression invokeCompileTimeFunctionExpression(@Nullable Expression expression) {
        FunctionInfo functionInfo;
        if (expression == null || expression.getFunctionCall() == null) {
            return expression;
        }
        Function function = expression.getFunctionCall();
        List<Expression> operands = function.getOperands();
        int numOperands = operands.size();
        boolean compilable = true;
        for (int i = 0; i < numOperands; ++i) {
            Expression operand = CalciteSqlParser.invokeCompileTimeFunctionExpression(operands.get(i));
            if (operand.getLiteral() == null) {
                compilable = false;
            }
            operands.set(i, operand);
        }
        String functionName = function.getOperator();
        if (compilable && (functionInfo = FunctionRegistry.getFunctionInfo(functionName, numOperands)) != null) {
            Object[] arguments = new Object[numOperands];
            for (int i = 0; i < numOperands; ++i) {
                arguments[i] = function.getOperands().get(i).getLiteral().getFieldValue();
            }
            try {
                FunctionInvoker invoker = new FunctionInvoker(functionInfo);
                invoker.convertTypes(arguments);
                Object result = invoker.invoke(arguments);
                return RequestUtils.getLiteralExpression(result);
            }
            catch (Exception e) {
                throw new SqlCompilationException("Caught exception while invoking method: " + functionInfo.getMethod() + " with arguments: " + Arrays.toString(arguments), e);
            }
        }
        return expression;
    }

    public static boolean isLiteralOnlyExpression(Expression e) {
        if (e.getType() == ExpressionType.LITERAL) {
            return true;
        }
        if (e.getType() == ExpressionType.FUNCTION) {
            Function functionCall = e.getFunctionCall();
            if (functionCall.getOperator().equalsIgnoreCase(SqlKind.AS.toString())) {
                return CalciteSqlParser.isLiteralOnlyExpression(functionCall.getOperands().get(0));
            }
            return false;
        }
        return false;
    }
}

