/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.linkedin.coral.common.functions.Function;
import com.linkedin.coral.hive.hive2rel.functions.HiveInOperator;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.Util;

public class HiveFunction {
    public static final Function CAST = new Function("cast", (SqlOperator)SqlStdOperatorTable.CAST){

        public SqlCall createCall(SqlNode function, List<SqlNode> operands, SqlLiteral qualifier) {
            Preconditions.checkNotNull(operands);
            Preconditions.checkArgument((operands.size() == 1 ? 1 : 0) != 0);
            return super.createCall(null, (List)ImmutableList.of((Object)operands.get(0), (Object)function), null);
        }
    };
    public static final Function CASE = new Function("case", (SqlOperator)SqlStdOperatorTable.CASE){

        public SqlCall createCall(SqlNode function, List<SqlNode> operands, SqlLiteral qualifier) {
            Preconditions.checkNotNull(operands);
            ArrayList<SqlNode> whenNodes = new ArrayList<SqlNode>();
            ArrayList<SqlNode> thenNodes = new ArrayList<SqlNode>();
            for (int i = 1; i < operands.size() - 1; i += 2) {
                whenNodes.add(operands.get(i));
                thenNodes.add(operands.get(i + 1));
            }
            SqlLiteral elseNode = operands.size() % 2 == 1 ? SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO) : (SqlNode)Util.last(operands);
            return SqlCase.createSwitched((SqlParserPos)SqlParserPos.ZERO, (SqlNode)operands.get(0), (SqlNodeList)new SqlNodeList(whenNodes, SqlParserPos.ZERO), (SqlNodeList)new SqlNodeList(thenNodes, SqlParserPos.ZERO), (SqlNode)elseNode);
        }
    };
    public static final Function WHEN = new Function("when", (SqlOperator)SqlStdOperatorTable.CASE){

        public SqlCall createCall(SqlNode function, List<SqlNode> operands, SqlLiteral qualifier) {
            Preconditions.checkNotNull(operands);
            ArrayList<SqlNode> whenNodes = new ArrayList<SqlNode>();
            ArrayList<SqlNode> thenNodes = new ArrayList<SqlNode>();
            for (int i = 0; i < operands.size() - 1; i += 2) {
                whenNodes.add(operands.get(i));
                thenNodes.add(operands.get(i + 1));
            }
            SqlLiteral elseNode = operands.size() % 2 == 0 ? SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO) : (SqlNode)Util.last(operands);
            return new SqlCase(SqlParserPos.ZERO, null, new SqlNodeList(whenNodes, SqlParserPos.ZERO), new SqlNodeList(thenNodes, SqlParserPos.ZERO), (SqlNode)elseNode);
        }
    };
    public static final Function BETWEEN = new Function("between", (SqlOperator)SqlStdOperatorTable.BETWEEN){

        public SqlCall createCall(SqlNode function, List<SqlNode> operands, SqlLiteral qualifier) {
            Preconditions.checkNotNull(operands);
            Preconditions.checkArgument((operands.size() >= 3 && operands.get(0) instanceof SqlLiteral ? 1 : 0) != 0);
            SqlLiteral opType = (SqlLiteral)operands.get(0);
            List<SqlNode> callParams = operands.subList(1, operands.size());
            if (opType.booleanValue()) {
                return SqlStdOperatorTable.NOT_BETWEEN.createCall(SqlParserPos.ZERO, callParams);
            }
            return SqlStdOperatorTable.BETWEEN.createCall(SqlParserPos.ZERO, callParams);
        }
    };
    public static final Function IN = new Function("in", (SqlOperator)HiveInOperator.IN){

        public SqlCall createCall(SqlNode function, List<SqlNode> operands, SqlLiteral qualifier) {
            Preconditions.checkState((operands.size() >= 2 ? 1 : 0) != 0);
            SqlNode lhs = operands.get(0);
            SqlNode firstRhs = operands.get(1);
            if (firstRhs instanceof SqlSelect) {
                return SqlStdOperatorTable.IN.createCall(SqlParserPos.ZERO, operands);
            }
            List<SqlNode> rhsList = operands.subList(1, operands.size());
            SqlNodeList rhs = new SqlNodeList(rhsList, SqlParserPos.ZERO);
            return this.getSqlOperator().createCall(SqlParserPos.ZERO, new SqlNode[]{lhs, rhs});
        }
    };
}

