/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.plugin.bigquery.BigQueryConfig;
import io.trino.plugin.bigquery.BigQueryErrorCode;
import io.trino.plugin.bigquery.BigQueryTableHandle;
import io.trino.plugin.bigquery.Conversions;
import io.trino.plugin.bigquery.ViewMaterializationCache;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.TableNotFoundException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class BigQueryClient {
    private static final Logger log = Logger.get(BigQueryClient.class);
    private final BigQuery bigQuery;
    private final ViewMaterializationCache materializationCache;
    private final boolean caseInsensitiveNameMatching;

    public BigQueryClient(BigQuery bigQuery, BigQueryConfig config, ViewMaterializationCache materializationCache) {
        this.bigQuery = Objects.requireNonNull(bigQuery, "bigQuery is null");
        this.materializationCache = Objects.requireNonNull(materializationCache, "materializationCache is null");
        this.caseInsensitiveNameMatching = config.isCaseInsensitiveNameMatching();
    }

    public Optional<RemoteDatabaseObject> toRemoteDataset(String projectId, String datasetName) {
        Objects.requireNonNull(projectId, "projectId is null");
        Objects.requireNonNull(datasetName, "datasetName is null");
        Verify.verify((boolean)datasetName.codePoints().noneMatch(Character::isUpperCase), (String)"Expected schema name from internal metadata to be lowercase: %s", (Object)datasetName);
        if (!this.caseInsensitiveNameMatching) {
            return Optional.of(RemoteDatabaseObject.of(datasetName));
        }
        HashMap mapping = new HashMap();
        for (Dataset dataset : this.listDatasets(projectId)) {
            mapping.merge(dataset.getDatasetId().getDataset().toLowerCase(Locale.ENGLISH), Optional.of(RemoteDatabaseObject.of(dataset.getDatasetId().getDataset())), (currentValue, collision) -> currentValue.map(current -> current.registerCollision(((RemoteDatabaseObject)collision.get()).getOnlyRemoteName())));
        }
        if (!mapping.containsKey(datasetName)) {
            mapping.put(datasetName, Optional.empty());
        }
        Verify.verify((boolean)mapping.containsKey(datasetName));
        return (Optional)mapping.get(datasetName);
    }

    public Optional<RemoteDatabaseObject> toRemoteTable(String projectId, String remoteDatasetName, String tableName) {
        return this.toRemoteTable(projectId, remoteDatasetName, tableName, () -> this.listTables(DatasetId.of((String)projectId, (String)remoteDatasetName), TableDefinition.Type.TABLE, TableDefinition.Type.VIEW));
    }

    public Optional<RemoteDatabaseObject> toRemoteTable(String projectId, String remoteDatasetName, String tableName, Iterable<Table> tables) {
        return this.toRemoteTable(projectId, remoteDatasetName, tableName, () -> tables);
    }

    private Optional<RemoteDatabaseObject> toRemoteTable(String projectId, String remoteDatasetName, String tableName, Supplier<Iterable<Table>> tables) {
        Objects.requireNonNull(projectId, "projectId is null");
        Objects.requireNonNull(remoteDatasetName, "remoteDatasetName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Verify.verify((boolean)tableName.codePoints().noneMatch(Character::isUpperCase), (String)"Expected table name from internal metadata to be lowercase: %s", (Object)tableName);
        if (!this.caseInsensitiveNameMatching) {
            return Optional.of(RemoteDatabaseObject.of(tableName));
        }
        TableId cacheKey = TableId.of((String)projectId, (String)remoteDatasetName, (String)tableName);
        HashMap mapping = new HashMap();
        for (Table table : tables.get()) {
            mapping.merge(BigQueryClient.tableIdToLowerCase(table.getTableId()), Optional.of(RemoteDatabaseObject.of(table.getTableId().getTable())), (currentValue, collision) -> currentValue.map(current -> current.registerCollision(((RemoteDatabaseObject)collision.get()).getOnlyRemoteName())));
        }
        if (!mapping.containsKey(cacheKey)) {
            mapping.put(cacheKey, Optional.empty());
        }
        Verify.verify((boolean)mapping.containsKey(cacheKey));
        return (Optional)mapping.get(cacheKey);
    }

    private static TableId tableIdToLowerCase(TableId tableId) {
        return TableId.of((String)tableId.getProject(), (String)tableId.getDataset(), (String)tableId.getTable().toLowerCase(Locale.ENGLISH));
    }

    public DatasetInfo getDataset(DatasetId datasetId) {
        return this.bigQuery.getDataset(datasetId, new BigQuery.DatasetOption[0]);
    }

    public Optional<TableInfo> getTable(TableId remoteTableId) {
        return Optional.ofNullable(this.bigQuery.getTable(remoteTableId, new BigQuery.TableOption[0]));
    }

    public TableInfo getCachedTable(Duration viewExpiration, TableInfo remoteTableId, List<String> requiredColumns) {
        String query = this.selectSql(remoteTableId, requiredColumns);
        log.debug("query is %s", new Object[]{query});
        return this.materializationCache.getCachedTable(this, query, viewExpiration, remoteTableId);
    }

    public String getProjectId() {
        return ((BigQueryOptions)this.bigQuery.getOptions()).getProjectId();
    }

    public Iterable<Dataset> listDatasets(String projectId) {
        return this.bigQuery.listDatasets(projectId, new BigQuery.DatasetListOption[0]).iterateAll();
    }

    public Iterable<Table> listTables(DatasetId remoteDatasetId, TableDefinition.Type ... types) {
        ImmutableSet allowedTypes = ImmutableSet.copyOf((Object[])types);
        Iterable allTables = this.bigQuery.listTables(remoteDatasetId, new BigQuery.TableListOption[0]).iterateAll();
        return (Iterable)Streams.stream((Iterable)allTables).filter(arg_0 -> BigQueryClient.lambda$listTables$6((Set)allowedTypes, arg_0)).collect(ImmutableList.toImmutableList());
    }

    Table update(TableInfo table) {
        return this.bigQuery.update(table, new BigQuery.TableOption[0]);
    }

    public void createSchema(DatasetInfo datasetInfo) {
        this.bigQuery.create(datasetInfo, new BigQuery.DatasetOption[0]);
    }

    public void dropSchema(DatasetId datasetId) {
        this.bigQuery.delete(datasetId, new BigQuery.DatasetDeleteOption[0]);
    }

    public void createTable(TableInfo tableInfo) {
        this.bigQuery.create(tableInfo, new BigQuery.TableOption[0]);
    }

    public void dropTable(TableId tableId) {
        this.bigQuery.delete(tableId);
    }

    Job create(JobInfo jobInfo) {
        return this.bigQuery.create(jobInfo, new BigQuery.JobOption[0]);
    }

    public TableResult query(String sql) {
        try {
            return this.bigQuery.query(QueryJobConfiguration.of((String)sql), new BigQuery.JobOption[0]);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new BigQueryException(0, String.format("Failed to run the query [%s]", sql), (Throwable)e);
        }
    }

    private String selectSql(TableInfo remoteTable, List<String> requiredColumns) {
        String columns = requiredColumns.isEmpty() ? "*" : requiredColumns.stream().map(column -> String.format("`%s`", column)).collect(Collectors.joining(","));
        return this.selectSql(remoteTable.getTableId(), columns);
    }

    public String selectSql(TableId table, String formattedColumns) {
        String tableName = this.fullTableName(table);
        return String.format("SELECT %s FROM `%s`", formattedColumns, tableName);
    }

    private String fullTableName(TableId remoteTableId) {
        String remoteSchemaName = remoteTableId.getDataset();
        String remoteTableName = remoteTableId.getTable();
        remoteTableId = TableId.of((String)remoteTableId.getProject(), (String)remoteSchemaName, (String)remoteTableName);
        return String.format("%s.%s.%s", remoteTableId.getProject(), remoteTableId.getDataset(), remoteTableId.getTable());
    }

    public List<BigQueryColumnHandle> getColumns(BigQueryTableHandle tableHandle) {
        TableInfo tableInfo = this.getTable(tableHandle.getRemoteTableName().toTableId()).orElseThrow(() -> new TableNotFoundException(tableHandle.getSchemaTableName()));
        Schema schema = tableInfo.getDefinition().getSchema();
        if (schema == null) {
            throw new TableNotFoundException(tableHandle.getSchemaTableName(), String.format("Table '%s' has no schema", tableHandle.getSchemaTableName()));
        }
        return (List)schema.getFields().stream().filter(Conversions::isSupportedType).map(Conversions::toColumnHandle).collect(ImmutableList.toImmutableList());
    }

    private static /* synthetic */ boolean lambda$listTables$6(Set allowedTypes, Table table) {
        return allowedTypes.contains(table.getDefinition().getType());
    }

    public static final class RemoteDatabaseObject {
        private final Set<String> remoteNames;

        private RemoteDatabaseObject(Set<String> remoteNames) {
            this.remoteNames = ImmutableSet.copyOf(remoteNames);
        }

        public static RemoteDatabaseObject of(String remoteName) {
            return new RemoteDatabaseObject((Set<String>)ImmutableSet.of((Object)remoteName));
        }

        public RemoteDatabaseObject registerCollision(String ambiguousName) {
            return new RemoteDatabaseObject((Set<String>)ImmutableSet.builderWithExpectedSize((int)(this.remoteNames.size() + 1)).addAll(this.remoteNames).add((Object)ambiguousName).build());
        }

        public String getAnyRemoteName() {
            return Collections.min(this.remoteNames);
        }

        public String getOnlyRemoteName() {
            if (!this.isAmbiguous()) {
                return (String)Iterables.getOnlyElement(this.remoteNames);
            }
            throw new TrinoException((ErrorCodeSupplier)BigQueryErrorCode.BIGQUERY_AMBIGUOUS_OBJECT_NAME, "Found ambiguous names in BigQuery when looking up '" + this.getAnyRemoteName().toLowerCase(Locale.ENGLISH) + "': " + this.remoteNames);
        }

        public boolean isAmbiguous() {
            return this.remoteNames.size() > 1;
        }
    }
}

