/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.bigquery.Field;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.plugin.bigquery.BigQueryType;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class BigQueryColumnHandle
implements ColumnHandle,
BigQueryType.Adaptor {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BigQueryColumnHandle.class).instanceSize();
    private final String name;
    private final BigQueryType bigQueryType;
    private final Field.Mode mode;
    private final Long precision;
    private final Long scale;
    private final List<BigQueryColumnHandle> subColumns;
    private final String description;
    private final boolean hidden;

    @JsonCreator
    public BigQueryColumnHandle(@JsonProperty(value="name") String name, @JsonProperty(value="bigQueryType") BigQueryType bigQueryType, @JsonProperty(value="mode") Field.Mode mode, @JsonProperty(value="precision") Long precision, @JsonProperty(value="scale") Long scale, @JsonProperty(value="subColumns") List<BigQueryColumnHandle> subColumns, @JsonProperty(value="description") String description, @JsonProperty(value="hidden") boolean hidden) {
        this.name = Objects.requireNonNull(name, "column name cannot be null");
        this.bigQueryType = Objects.requireNonNull(bigQueryType, () -> String.format("column type cannot be null for column [%s]", name));
        this.mode = Objects.requireNonNull(mode, "Field mode cannot be null");
        this.precision = precision;
        this.scale = scale;
        this.subColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(subColumns, "subColumns is null"));
        this.description = description;
        this.hidden = hidden;
    }

    @VisibleForTesting
    BigQueryColumnHandle(String name, BigQueryType bigQueryType, Field.Mode mode, Long precision, Long scale, List<BigQueryColumnHandle> subColumns, String description) {
        this(name, bigQueryType, mode, precision, scale, subColumns, description, false);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public BigQueryType getBigQueryType() {
        return this.bigQueryType;
    }

    @Override
    public Map<String, BigQueryType.Adaptor> getBigQuerySubTypes() {
        return (Map)this.subColumns.stream().collect(ImmutableMap.toImmutableMap(BigQueryColumnHandle::getName, column -> column));
    }

    @Override
    @JsonProperty
    public Field.Mode getMode() {
        return this.mode;
    }

    @Override
    @JsonProperty
    public Long getPrecision() {
        return this.precision;
    }

    @Override
    @JsonProperty
    public Long getScale() {
        return this.scale;
    }

    @JsonProperty
    public List<BigQueryColumnHandle> getSubColumns() {
        return this.subColumns;
    }

    @JsonProperty
    public String description() {
        return this.description;
    }

    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    public ColumnMetadata getColumnMetadata() {
        return ColumnMetadata.builder().setName(this.name).setType(this.getTrinoType()).setComment(Optional.ofNullable(this.description)).setNullable(this.mode == Field.Mode.NULLABLE).setHidden(this.hidden).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BigQueryColumnHandle that = (BigQueryColumnHandle)o;
        return Objects.equals(this.name, that.name) && Objects.equals((Object)this.bigQueryType, (Object)that.bigQueryType) && Objects.equals(this.mode, that.mode) && Objects.equals(this.precision, that.precision) && Objects.equals(this.scale, that.scale) && Objects.equals(this.subColumns, that.subColumns) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.bigQueryType, this.mode, this.precision, this.scale, this.subColumns, this.description});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.bigQueryType).add("mode", (Object)this.mode).add("precision", (Object)this.precision).add("scale", (Object)this.scale).add("subColumns", this.subColumns).add("description", (Object)this.description).toString();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.name) + SizeOf.sizeOf((Long)this.precision) + SizeOf.sizeOf((Long)this.scale) + SizeOf.estimatedSizeOf(this.subColumns, BigQueryColumnHandle::getRetainedSizeInBytes) + SizeOf.estimatedSizeOf((String)this.description);
    }
}

