/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.bigquery.BigQueryClientFactory;
import io.trino.plugin.bigquery.BigQueryConfig;
import io.trino.plugin.bigquery.BigQueryConnector;
import io.trino.plugin.bigquery.BigQueryCredentialsSupplier;
import io.trino.plugin.bigquery.BigQueryMetadata;
import io.trino.plugin.bigquery.BigQueryPageSourceProvider;
import io.trino.plugin.bigquery.BigQueryReadClientFactory;
import io.trino.plugin.bigquery.BigQuerySplitManager;
import io.trino.plugin.bigquery.IdentityCacheMapping;
import io.trino.plugin.bigquery.StaticBigQueryCredentialsSupplier;
import io.trino.plugin.bigquery.StaticCredentialsConfig;
import io.trino.plugin.bigquery.ViewMaterializationCache;
import io.trino.spi.NodeManager;

public class BigQueryConnectorModule
extends AbstractConfigurationAwareModule {
    public void setup(Binder binder) {
        this.install((Module)new ClientModule());
        this.install((Module)new StaticCredentialsModule());
    }

    public static class StaticCredentialsModule
    extends AbstractConfigurationAwareModule {
        protected void setup(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(StaticCredentialsConfig.class);
            OptionalBinder.newOptionalBinder((Binder)binder, IdentityCacheMapping.class).setDefault().to(IdentityCacheMapping.SingletonIdentityCacheMapping.class).in(Scopes.SINGLETON);
            OptionalBinder.newOptionalBinder((Binder)binder, BigQueryCredentialsSupplier.class).setDefault().to(StaticBigQueryCredentialsSupplier.class).in(Scopes.SINGLETON);
        }
    }

    public static class ClientModule
    extends AbstractConfigurationAwareModule {
        protected void setup(Binder binder) {
            binder.bind(BigQueryReadClientFactory.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryClientFactory.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryConnector.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryMetadata.class).in(Scopes.SINGLETON);
            binder.bind(BigQuerySplitManager.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryPageSourceProvider.class).in(Scopes.SINGLETON);
            binder.bind(ViewMaterializationCache.class).in(Scopes.SINGLETON);
            ConfigBinder.configBinder((Binder)binder).bindConfig(BigQueryConfig.class);
        }

        @Provides
        @Singleton
        public static HeaderProvider createHeaderProvider(NodeManager nodeManager) {
            return FixedHeaderProvider.create((String[])new String[]{"user-agent", "Trino/" + nodeManager.getCurrentNode().getVersion()});
        }
    }
}

