/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class BigQueryFilterQueryBuilder {
    private static final String QUOTE = "`";
    private static final String ESCAPED_QUOTE = "``";
    private final TupleDomain<ColumnHandle> tupleDomain;

    public static Optional<String> buildFilter(TupleDomain<ColumnHandle> tupleDomain) {
        return new BigQueryFilterQueryBuilder(tupleDomain).buildFilter();
    }

    private BigQueryFilterQueryBuilder(TupleDomain<ColumnHandle> tupleDomain) {
        this.tupleDomain = tupleDomain;
    }

    private Optional<String> buildFilter() {
        Optional domains = this.tupleDomain.getDomains();
        return domains.map(this::toConjuncts).map(this::concat);
    }

    private String concat(List<String> clauses) {
        return clauses.isEmpty() ? null : clauses.stream().collect(Collectors.joining(" AND "));
    }

    private List<String> toConjuncts(Map<ColumnHandle, Domain> domains) {
        List<BigQueryColumnHandle> columns = domains.keySet().stream().map(BigQueryColumnHandle.class::cast).collect(Collectors.toList());
        return this.toConjuncts(columns);
    }

    private List<String> toConjuncts(List<BigQueryColumnHandle> columns) {
        if (this.tupleDomain.isNone()) {
            return ImmutableList.of((Object)"FALSE");
        }
        ImmutableList.Builder clauses = ImmutableList.builder();
        for (BigQueryColumnHandle column : columns) {
            Domain domain = (Domain)((Map)this.tupleDomain.getDomains().get()).get(column);
            if (domain == null) continue;
            this.toPredicate(column.getName(), domain, column).ifPresent(arg_0 -> ((ImmutableList.Builder)clauses).add(arg_0));
        }
        return clauses.build();
    }

    private Optional<String> toPredicate(String columnName, Domain domain, BigQueryColumnHandle column) {
        if (domain.getValues().isNone()) {
            String predicate = domain.isNullAllowed() ? this.quote(columnName) + " IS NULL" : "FALSE";
            return Optional.of(predicate);
        }
        if (domain.getValues().isAll()) {
            String predicate = domain.isNullAllowed() ? "TRUE" : this.quote(columnName) + " IS NOT NULL";
            return Optional.of(predicate);
        }
        ArrayList<CallSite> disjuncts = new ArrayList<CallSite>();
        ArrayList<String> singleValues = new ArrayList<String>();
        for (Range range : domain.getValues().getRanges().getOrderedRanges()) {
            Optional<String> predicate;
            Preconditions.checkState((!range.isAll() ? 1 : 0) != 0);
            if (range.isSingleValue()) {
                Optional<String> value = column.getBigQueryType().convertToString(column.getTrinoType(), range.getSingleValue());
                if (value.isEmpty()) {
                    return Optional.empty();
                }
                singleValues.add(value.get());
                continue;
            }
            ArrayList<String> rangeConjuncts = new ArrayList<String>();
            if (!range.isLowUnbounded()) {
                predicate = this.toPredicate(columnName, range.isLowInclusive() ? ">=" : ">", range.getLowBoundedValue(), column);
                if (predicate.isEmpty()) {
                    return Optional.empty();
                }
                rangeConjuncts.add(predicate.get());
            }
            if (!range.isHighUnbounded()) {
                predicate = this.toPredicate(columnName, range.isHighInclusive() ? "<=" : "<", range.getHighBoundedValue(), column);
                if (predicate.isEmpty()) {
                    return Optional.empty();
                }
                rangeConjuncts.add(predicate.get());
            }
            Preconditions.checkState((!rangeConjuncts.isEmpty() ? 1 : 0) != 0);
            disjuncts.add((CallSite)((Object)("(" + this.concat(rangeConjuncts) + ")")));
        }
        if (singleValues.size() == 1) {
            String predicate = this.quote(columnName) + " = " + (String)Iterables.getOnlyElement(singleValues);
            disjuncts.add((CallSite)((Object)predicate));
        } else if (singleValues.size() > 1) {
            String values = String.join((CharSequence)",", singleValues);
            disjuncts.add((CallSite)((Object)(this.quote(columnName) + " IN (" + values + ")")));
        }
        Preconditions.checkState((!disjuncts.isEmpty() ? 1 : 0) != 0);
        if (domain.isNullAllowed()) {
            disjuncts.add((CallSite)((Object)(this.quote(columnName) + " IS NULL")));
        }
        return Optional.of("(" + String.join((CharSequence)" OR ", disjuncts) + ")");
    }

    private Optional<String> toPredicate(String columnName, String operator, Object value, BigQueryColumnHandle column) {
        Optional<String> valueAsString = column.getBigQueryType().convertToString(column.getTrinoType(), value);
        if (valueAsString.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.quote(columnName) + " " + operator + " " + valueAsString.get());
    }

    private String quote(String name) {
        return QUOTE + name.replace(QUOTE, ESCAPED_QUOTE) + QUOTE;
    }
}

