/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import io.trino.plugin.bigquery.BigQueryCredentialsSupplier;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class BigQueryReadClientFactory {
    private final BigQueryCredentialsSupplier credentialsSupplier;
    private final HeaderProvider headerProvider;

    @Inject
    public BigQueryReadClientFactory(BigQueryCredentialsSupplier bigQueryCredentialsSupplier, HeaderProvider headerProvider) {
        this.credentialsSupplier = Objects.requireNonNull(bigQueryCredentialsSupplier, "credentialsSupplier is null");
        this.headerProvider = Objects.requireNonNull(headerProvider, "headerProvider is null");
    }

    BigQueryReadClient create(ConnectorSession session) {
        Optional<Credentials> credentials = this.credentialsSupplier.getCredentials(session);
        try {
            BigQueryReadSettings.Builder clientSettings = (BigQueryReadSettings.Builder)BigQueryReadSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)BigQueryReadSettings.defaultGrpcTransportProviderBuilder().setHeaderProvider(this.headerProvider).build());
            credentials.ifPresent(value -> clientSettings.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)value)));
            return BigQueryReadClient.create((BigQueryReadSettings)clientSettings.build());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error creating BigQueryReadClient", e);
        }
    }
}

