/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Enums;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.plugin.bigquery.BigQueryType;
import io.trino.spi.connector.ColumnMetadata;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class Conversions {
    private Conversions() {
    }

    public static BigQueryColumnHandle toColumnHandle(Field field) {
        FieldList subFields = field.getSubFields();
        List<BigQueryColumnHandle> subColumns = subFields == null ? Collections.emptyList() : subFields.stream().filter(Conversions::isSupportedType).map(Conversions::toColumnHandle).collect(Collectors.toList());
        return new BigQueryColumnHandle(field.getName(), BigQueryType.valueOf(field.getType().name()), Conversions.getMode(field), field.getPrecision(), field.getScale(), subColumns, field.getDescription(), false);
    }

    @VisibleForTesting
    public static ColumnMetadata toColumnMetadata(Field field) {
        return ColumnMetadata.builder().setName(field.getName()).setType(Conversions.adapt(field).getTrinoType()).setComment(Optional.ofNullable(field.getDescription())).setNullable(Conversions.getMode(field) == Field.Mode.NULLABLE).build();
    }

    public static boolean isSupportedType(Field field) {
        LegacySQLTypeName type = field.getType();
        if (type == LegacySQLTypeName.BIGNUMERIC) {
            if (field.getPrecision() == null && field.getScale() == null) {
                return false;
            }
            if (field.getPrecision() != null && field.getPrecision() > 38L) {
                return false;
            }
        }
        return Enums.getIfPresent(BigQueryType.class, (String)type.name()).isPresent();
    }

    static BigQueryType.Adaptor adapt(final Field field) {
        return new BigQueryType.Adaptor(){

            @Override
            public BigQueryType getBigQueryType() {
                return BigQueryType.valueOf(field.getType().name());
            }

            @Override
            public Long getPrecision() {
                return field.getPrecision();
            }

            @Override
            public Long getScale() {
                return field.getScale();
            }

            public ImmutableMap<String, BigQueryType.Adaptor> getBigQuerySubTypes() {
                FieldList subFields = field.getSubFields();
                if (subFields == null) {
                    return ImmutableMap.of();
                }
                return (ImmutableMap)subFields.stream().collect(ImmutableMap.toImmutableMap(Field::getName, Conversions::adapt));
            }

            @Override
            public Field.Mode getMode() {
                return Conversions.getMode(field);
            }
        };
    }

    private static Field.Mode getMode(Field field) {
        return (Field.Mode)MoreObjects.firstNonNull((Object)field.getMode(), (Object)Field.Mode.NULLABLE);
    }
}

