/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redis;

import io.airlift.log.Logger;
import io.trino.plugin.redis.RedisConnectorConfig;
import io.trino.spi.HostAddress;
import io.trino.spi.NodeManager;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisJedisManager {
    private static final Logger log = Logger.get(RedisJedisManager.class);
    private final ConcurrentMap<HostAddress, JedisPool> jedisPoolCache = new ConcurrentHashMap<HostAddress, JedisPool>();
    private final RedisConnectorConfig redisConnectorConfig;
    private final JedisPoolConfig jedisPoolConfig;

    @Inject
    RedisJedisManager(RedisConnectorConfig redisConnectorConfig, NodeManager nodeManager) {
        this.redisConnectorConfig = Objects.requireNonNull(redisConnectorConfig, "redisConnectorConfig is null");
        this.jedisPoolConfig = new JedisPoolConfig();
    }

    @PreDestroy
    public void tearDown() {
        for (Map.Entry entry : this.jedisPoolCache.entrySet()) {
            try {
                ((JedisPool)entry.getValue()).destroy();
            }
            catch (Exception e) {
                log.warn((Throwable)e, "While destroying JedisPool %s:", new Object[]{entry.getKey()});
            }
        }
    }

    public RedisConnectorConfig getRedisConnectorConfig() {
        return this.redisConnectorConfig;
    }

    public JedisPool getJedisPool(HostAddress host) {
        Objects.requireNonNull(host, "host is null");
        return this.jedisPoolCache.computeIfAbsent(host, this::createConsumer);
    }

    private JedisPool createConsumer(HostAddress host) {
        log.info("Creating new JedisPool for %s", new Object[]{host});
        return new JedisPool((GenericObjectPoolConfig)this.jedisPoolConfig, host.getHostText(), host.getPort(), Math.toIntExact(this.redisConnectorConfig.getRedisConnectTimeout().toMillis()), this.redisConnectorConfig.getRedisPassword(), this.redisConnectorConfig.getRedisDataBaseIndex());
    }
}

