/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.functions;

import com.linkedin.coral.trino.rel2trino.functions.RelDataTypeToTrinoTypeStringConverter;
import com.linkedin.coral.trino.rel2trino.functions.TrinoArrayTransformFunction;
import com.linkedin.coral.trino.rel2trino.functions.TrinoKeywordsConverter;
import com.linkedin.coral.trino.rel2trino.functions.TrinoMapTransformValuesFunction;
import com.linkedin.coral.trino.rel2trino.functions.TrinoStructCastRowFunction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.MapSqlType;

public class GenericProjectToTrinoConverter {
    private GenericProjectToTrinoConverter() {
    }

    public static RexCall convertGenericProject(RexBuilder builder, RexCall call, RelNode node) {
        RexLiteral columnNameLiteral = (RexLiteral)call.getOperands().get(1);
        String transformColumnFieldName = RexLiteral.stringValue((RexNode)columnNameLiteral);
        RexNode transformColumn = (RexNode)call.getOperands().get(0);
        if (transformColumn instanceof RexInputRef) {
            int columnIndexInBaseTable = ((RexInputRef)transformColumn).getIndex();
            LinkedList nodeDeque = new LinkedList(node.getInputs());
            while (!nodeDeque.isEmpty()) {
                RelDataTypeField relDataTypeField;
                RelNode currentNode = (RelNode)nodeDeque.pollFirst();
                List fieldList = currentNode.getRowType().getFieldList();
                if (columnIndexInBaseTable < fieldList.size() && (relDataTypeField = (RelDataTypeField)fieldList.get(columnIndexInBaseTable)).getType() == transformColumn.getType() && !transformColumnFieldName.equalsIgnoreCase(relDataTypeField.getName())) {
                    transformColumnFieldName = relDataTypeField.getName();
                    break;
                }
                nodeDeque.addAll(currentNode.getInputs());
            }
        }
        RelDataType fromDataType = transformColumn.getType();
        RelDataType toDataType = call.getOperator().inferReturnType(null);
        switch (toDataType.getSqlTypeName()) {
            case ROW: {
                String structDataTypeArgumentString = GenericProjectToTrinoConverter.structDataTypeArgumentString((RelRecordType)fromDataType, (RelRecordType)toDataType, transformColumnFieldName);
                TrinoStructCastRowFunction structFunction = new TrinoStructCastRowFunction(toDataType);
                return (RexCall)builder.makeCall((SqlOperator)structFunction, new RexNode[]{builder.makeLiteral(structDataTypeArgumentString)});
            }
            case ARRAY: {
                String arrayDataTypeArgumentString = GenericProjectToTrinoConverter.arrayDataTypeArgumentString((ArraySqlType)fromDataType, (ArraySqlType)toDataType, transformColumnFieldName);
                TrinoArrayTransformFunction arrayFunction = new TrinoArrayTransformFunction(toDataType);
                return (RexCall)builder.makeCall((SqlOperator)arrayFunction, new RexNode[]{builder.makeLiteral(arrayDataTypeArgumentString)});
            }
            case MAP: {
                String mapDataTypeArgumentString = GenericProjectToTrinoConverter.mapDataTypeArgumentString((MapSqlType)fromDataType, (MapSqlType)toDataType, transformColumnFieldName);
                TrinoMapTransformValuesFunction mapFunction = new TrinoMapTransformValuesFunction(toDataType);
                return (RexCall)builder.makeCall((SqlOperator)mapFunction, new RexNode[]{builder.makeLiteral(mapDataTypeArgumentString)});
            }
        }
        return call;
    }

    private static String mapDataTypeString(MapSqlType fromDataType, MapSqlType toDataType, String fieldNameReference) {
        String mapDataTypeArgumentString = GenericProjectToTrinoConverter.mapDataTypeArgumentString(fromDataType, toDataType, fieldNameReference);
        return String.format("transform_values(%s)", mapDataTypeArgumentString);
    }

    private static String mapDataTypeArgumentString(MapSqlType fromDataType, MapSqlType toDataType, String fieldNameReference) {
        String mapKeyFieldReference = "k";
        String mapValueFieldReference = "v";
        String valueTransformedFieldString = GenericProjectToTrinoConverter.relDataTypeFieldAccessString(fromDataType.getValueType(), toDataType.getValueType(), mapValueFieldReference);
        return String.format("%s, (%s, %s) -> %s", fieldNameReference, mapKeyFieldReference, mapValueFieldReference, valueTransformedFieldString);
    }

    private static String arrayDataTypeString(ArraySqlType fromDataType, ArraySqlType toDataType, String fieldNameReference) {
        String arrayDataTypeArgumentString = GenericProjectToTrinoConverter.arrayDataTypeArgumentString(fromDataType, toDataType, fieldNameReference);
        return String.format("transform(%s)", arrayDataTypeArgumentString);
    }

    private static String arrayDataTypeArgumentString(ArraySqlType fromDataType, ArraySqlType toDataType, String fieldNameReference) {
        String elementFieldReference = "x";
        String elementTransformedFieldString = GenericProjectToTrinoConverter.relDataTypeFieldAccessString(fromDataType.getComponentType(), toDataType.getComponentType(), elementFieldReference);
        return String.format("%s, %s -> %s", fieldNameReference, elementFieldReference, elementTransformedFieldString);
    }

    private static String structDataTypeString(RelRecordType fromDataType, RelRecordType toDataType, String fieldNameReference) {
        String structDataTypeArgumentString = GenericProjectToTrinoConverter.structDataTypeArgumentString(fromDataType, toDataType, fieldNameReference);
        return String.format("cast(%s)", structDataTypeArgumentString);
    }

    private static String structDataTypeArgumentString(RelRecordType fromDataType, RelRecordType toDataType, String fieldNameReference) {
        String structFieldsAccessString = GenericProjectToTrinoConverter.buildStructRelDataTypeFieldAccessString(fromDataType, toDataType, fieldNameReference);
        String castToRowTypeString = RelDataTypeToTrinoTypeStringConverter.buildTrinoTypeString((RelDataType)toDataType);
        return String.format("%s as %s", structFieldsAccessString, castToRowTypeString);
    }

    private static String relDataTypeFieldAccessString(RelDataType fromDataType, RelDataType toDataType, String fieldNameReference) {
        if (fromDataType.equals(toDataType)) {
            return fieldNameReference;
        }
        switch (toDataType.getSqlTypeName()) {
            case ROW: {
                return GenericProjectToTrinoConverter.structDataTypeString((RelRecordType)fromDataType, (RelRecordType)toDataType, fieldNameReference);
            }
            case ARRAY: {
                return GenericProjectToTrinoConverter.arrayDataTypeString((ArraySqlType)fromDataType, (ArraySqlType)toDataType, fieldNameReference);
            }
            case MAP: {
                return GenericProjectToTrinoConverter.mapDataTypeString((MapSqlType)fromDataType, (MapSqlType)toDataType, fieldNameReference);
            }
        }
        return fieldNameReference;
    }

    private static String buildStructRelDataTypeFieldAccessString(RelRecordType fromDataType, RelRecordType toDataType, String fieldNameReference) {
        ArrayList<String> structSelectedFieldStrings = new ArrayList<String>();
        for (RelDataTypeField toDataTypeField : toDataType.getFieldList()) {
            RelDataTypeField fromDataTypeField = fromDataType.getField(toDataTypeField.getName(), false, false);
            if (fromDataTypeField == null) {
                throw new RuntimeException(String.format("Field %s was not found in column %s.", toDataTypeField.getName(), fieldNameReference));
            }
            String fromDataTypeFieldName = String.format("%s.%s", TrinoKeywordsConverter.quoteWordIfNotQuoted(fieldNameReference), TrinoKeywordsConverter.quoteWordIfNotQuoted(fromDataTypeField.getName()));
            structSelectedFieldStrings.add(GenericProjectToTrinoConverter.relDataTypeFieldAccessString(fromDataTypeField.getType(), toDataTypeField.getType(), fromDataTypeFieldName));
        }
        String subFieldsString = String.join((CharSequence)", ", structSelectedFieldStrings);
        return String.format("row(%s)", subFieldsString);
    }
}

