/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.trino2rel;

import com.linkedin.coral.common.HiveMetastoreClient;
import com.linkedin.coral.common.ToRelConverter;
import com.linkedin.coral.common.functions.FunctionRegistry;
import com.linkedin.coral.hive.hive2rel.DaliOperatorTable;
import com.linkedin.coral.hive.hive2rel.HiveConvertletTable;
import com.linkedin.coral.hive.hive2rel.HiveRelBuilder;
import com.linkedin.coral.hive.hive2rel.HiveSqlValidator;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunctionResolver;
import com.linkedin.coral.hive.hive2rel.functions.StaticHiveFunctionRegistry;
import com.linkedin.coral.trino.trino2rel.ParseTreeBuilder;
import com.linkedin.coral.trino.trino2rel.ParserVisitorContext;
import com.linkedin.coral.trino.trino2rel.PrestoParserDriver;
import com.linkedin.coral.trino.trino2rel.Trino2CoralOperatorConverter;
import com.linkedin.coral.trino.trino2rel.TrinoSqlConformance;
import com.linkedin.coral.trino.trino2rel.TrinoSqlToRelConverter;
import com.linkedin.coral.trino.trino2rel.TrinoViewExpander;
import coral.shading.io.trino.sql.tree.AstVisitor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.hadoop.hive.metastore.api.Table;

public class TrinoToRelConverter
extends ToRelConverter {
    private final ParseTreeBuilder parseTreeBuilder = new ParseTreeBuilder();
    private final ParserVisitorContext parserVisitorContext = new ParserVisitorContext();
    private final HiveFunctionResolver functionResolver = new HiveFunctionResolver((FunctionRegistry)new StaticHiveFunctionRegistry(), new ConcurrentHashMap());
    private final SqlValidator sqlValidator = new HiveSqlValidator(this.getOperatorTable(), this.getCalciteCatalogReader(), (JavaTypeFactory)this.getRelBuilder().getTypeFactory(), TrinoSqlConformance.TRINO_SQL);

    public TrinoToRelConverter(HiveMetastoreClient hiveMetastoreClient) {
        super(hiveMetastoreClient);
    }

    public TrinoToRelConverter(Map<String, Map<String, List<String>>> localMetaStore) {
        super(localMetaStore);
    }

    protected SqlRexConvertletTable getConvertletTable() {
        return new HiveConvertletTable();
    }

    protected SqlValidator getSqlValidator() {
        return this.sqlValidator;
    }

    protected SqlOperatorTable getOperatorTable() {
        return ChainedSqlOperatorTable.of((SqlOperatorTable[])new SqlOperatorTable[]{SqlStdOperatorTable.instance(), new DaliOperatorTable(this.functionResolver)});
    }

    protected SqlToRelConverter getSqlToRelConverter() {
        return new TrinoSqlToRelConverter(new TrinoViewExpander(this), this.getSqlValidator(), (Prepare.CatalogReader)this.getCalciteCatalogReader(), RelOptCluster.create((RelOptPlanner)new VolcanoPlanner(), (RexBuilder)this.getRelBuilder().getRexBuilder()), this.getConvertletTable(), SqlToRelConverter.configBuilder().withRelBuilderFactory(HiveRelBuilder.LOGICAL_BUILDER).build());
    }

    protected SqlNode toSqlNode(String sql, Table trinoView) {
        String trimmedSql = TrinoToRelConverter.trimParenthesis(sql.toUpperCase());
        SqlNode parsedSqlNode = (SqlNode)PrestoParserDriver.parse(trimmedSql).accept((AstVisitor)this.parseTreeBuilder, (Object)this.parserVisitorContext);
        SqlNode convertedSqlNode = (SqlNode)parsedSqlNode.accept((SqlVisitor)new Trino2CoralOperatorConverter());
        return convertedSqlNode;
    }

    protected RelNode standardizeRel(RelNode relNode) {
        return relNode;
    }

    private static String trimParenthesis(String value) {
        String str = value.trim();
        if (str.startsWith("(") && str.endsWith(")")) {
            return TrinoToRelConverter.trimParenthesis(str.substring(1, str.length() - 1));
        }
        return str;
    }
}

