/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.session.db;

import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.plugin.session.db.DbSessionPropertyManager;
import io.trino.plugin.session.db.DbSessionPropertyManagerModule;
import io.trino.spi.resourcegroups.SessionPropertyConfigurationManagerContext;
import io.trino.spi.session.SessionPropertyConfigurationManager;
import io.trino.spi.session.SessionPropertyConfigurationManagerFactory;
import java.util.Map;
import org.weakref.jmx.guice.MBeanModule;

public class DbSessionPropertyManagerFactory
implements SessionPropertyConfigurationManagerFactory {
    public String getName() {
        return "db";
    }

    public SessionPropertyConfigurationManager create(Map<String, String> config, SessionPropertyConfigurationManagerContext context) {
        try {
            Bootstrap app = new Bootstrap(new Module[]{new MBeanModule(), new MBeanServerModule(), new JsonModule(), new DbSessionPropertyManagerModule()});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (SessionPropertyConfigurationManager)injector.getInstance(DbSessionPropertyManager.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

