/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.session.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import io.trino.plugin.session.SessionMatchSpec;
import io.trino.plugin.session.db.DbSessionPropertyManagerConfig;
import io.trino.plugin.session.db.DbSpecsProvider;
import io.trino.plugin.session.db.SessionPropertiesDao;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class RefreshingDbSpecsProvider
implements DbSpecsProvider {
    private static final Logger log = Logger.get(RefreshingDbSpecsProvider.class);
    private final AtomicReference<List<SessionMatchSpec>> sessionMatchSpecs = new AtomicReference<ImmutableList>(ImmutableList.of());
    private final SessionPropertiesDao dao;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"RefreshingDbSpecsProvider"));
    private final AtomicBoolean started = new AtomicBoolean();
    private final long refreshPeriodMillis;
    private final CounterStat dbLoadFailures = new CounterStat();

    @Inject
    public RefreshingDbSpecsProvider(DbSessionPropertyManagerConfig config, SessionPropertiesDao dao) {
        Objects.requireNonNull(config, "config is null");
        this.dao = Objects.requireNonNull(dao, "dao is null");
        this.refreshPeriodMillis = config.getSpecsRefreshPeriod().toMillis();
        dao.createSessionSpecsTable();
        dao.createSessionClientTagsTable();
        dao.createSessionPropertiesTable();
    }

    @PostConstruct
    public void initialize() {
        if (!this.started.getAndSet(true)) {
            this.executor.scheduleWithFixedDelay(this::refresh, 0L, this.refreshPeriodMillis, TimeUnit.MILLISECONDS);
        }
    }

    @VisibleForTesting
    void refresh() {
        Objects.requireNonNull(this.dao, "dao is null");
        try {
            this.sessionMatchSpecs.set((List<SessionMatchSpec>)ImmutableList.copyOf(this.dao.getSessionMatchSpecs()));
        }
        catch (Throwable e) {
            this.dbLoadFailures.update(1L);
            log.error(e, "Error loading configuration from database");
        }
    }

    @PreDestroy
    public void destroy() {
        this.executor.shutdownNow();
    }

    @Override
    public List<SessionMatchSpec> get() {
        return this.sessionMatchSpecs.get();
    }

    @Managed
    @Nested
    public CounterStat getDbLoadFailures() {
        return this.dbLoadFailures;
    }
}

