/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.session.file;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.plugin.session.AbstractSessionPropertyManager;
import io.trino.plugin.session.SessionMatchSpec;
import io.trino.plugin.session.file.FileSessionPropertyManagerConfig;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class FileSessionPropertyManager
extends AbstractSessionPropertyManager {
    public static final JsonCodec<List<SessionMatchSpec>> CODEC = new JsonCodecFactory(() -> new ObjectMapperProvider().get().enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).listJsonCodec(SessionMatchSpec.class);
    private final ImmutableList<SessionMatchSpec> sessionMatchSpecs;

    @Inject
    public FileSessionPropertyManager(FileSessionPropertyManagerConfig config) {
        Objects.requireNonNull(config, "config is null");
        Path configurationFile = config.getConfigFile().toPath();
        try {
            this.sessionMatchSpecs = ImmutableList.copyOf((Collection)((Collection)CODEC.fromJson(Files.readAllBytes(configurationFile))));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (IllegalArgumentException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnrecognizedPropertyException) {
                UnrecognizedPropertyException ex = (UnrecognizedPropertyException)cause;
                String message = String.format("Unknown property at line %s:%s: %s", ex.getLocation().getLineNr(), ex.getLocation().getColumnNr(), ex.getPropertyName());
                throw new IllegalArgumentException(message, e);
            }
            if (cause instanceof JsonMappingException) {
                if (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                throw new IllegalArgumentException(cause.getMessage(), e);
            }
            throw e;
        }
    }

    @Override
    protected List<SessionMatchSpec> getSessionMatchSpecs() {
        return this.sessionMatchSpecs;
    }
}

