/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;

public class VarcharToIntegerNumberCoercer<T extends Type>
extends TypeCoercer<VarcharType, T> {
    private final long minValue;
    private final long maxValue;

    public VarcharToIntegerNumberCoercer(VarcharType fromType, T toType) {
        super(fromType, toType);
        if (toType.equals(TinyintType.TINYINT)) {
            this.minValue = -128L;
            this.maxValue = 127L;
        } else if (toType.equals(SmallintType.SMALLINT)) {
            this.minValue = -32768L;
            this.maxValue = 32767L;
        } else if (toType.equals(IntegerType.INTEGER)) {
            this.minValue = Integer.MIN_VALUE;
            this.maxValue = Integer.MAX_VALUE;
        } else if (toType.equals(BigintType.BIGINT)) {
            this.minValue = Long.MIN_VALUE;
            this.maxValue = Long.MAX_VALUE;
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Could not create Coercer from varchar to %s", toType));
        }
    }

    @Override
    protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
        try {
            long value = Long.parseLong(((VarcharType)this.fromType).getSlice(block, position).toStringUtf8());
            if (this.minValue <= value && value <= this.maxValue) {
                this.toType.writeLong(blockBuilder, value);
            } else {
                blockBuilder.appendNull();
            }
        }
        catch (NumberFormatException e) {
            blockBuilder.appendNull();
        }
    }
}

